/***************************************************************************
* Benchmark Program to compare Clipper's DBFNTX, DBFCDX, and Extend Systems
* AXS Drivers.
*
* Tests are designed to be multi-user.
*
* Only for Clipper 5.2c (because of the driver functions only)
*
* Note: The CDX Tests were abandoned because of the unreliability of
* Clipper 5.2c DBFCDX driver.
*
* Written: 11/93, M.Smith, Kepner-Tregoe
***************************************************************************/
Static cInfo

*****************************************************************
Function DbfBenchMarks( xInfo )
   /****************************************************************
   * Test  Action
   *  1    Loop through each of the open files with active index
   *  2    Set relation for 3 files, loop through master file
   *  3    Random Seeks through 3 files
   *  4    Add 500 records to each file
   *  5    Randomly update keys in each file
   *****************************************************************/
   Local x, y, nSec, GetList := {}, nFiles, nSeed, z, aKeyFields, aStruct

   Set Exclusive Off

   #ifdef CDX                                    // defined on CLIPPER line
      Request DBFCDX
      RddSetDefault("DBFCDX")
   #endif

   If xInfo == NIL
      cInfo := "Debugging"
   Else
      cInfo := xInfo
   Endif

   Clear
   nFiles := OpenFiles()
   ? DbSetDriver() + " " + Left(Version(),16) + " " + cInfo
   ?

   // An array of key field names, and 'random' values to store into them
   aKeyFields := Array(nFiles,5,2)
   For x := 1 To nFiles
      dbSelectArea(x)
      aStruct := dbStruct()
      For y := 1 To 5
         If FieldPos( IndexKey(y) ) != 0
            aKeyFields[x,y,1] :=  FieldPos( IndexKey(y) )
            If aStruct[aKeyFields[x,y,1]][2] = "N"
               aKeyFields[x,y,2] :=  10^aStruct[aKeyFields[x,y,1]][3]
            Else
               aKeyFields[x,y,2] :=  aStruct[aKeyFields[x,y,1]][3]
            Endif
         Endif
      Next
   Next

   // =========================================================================
   // Test 1
   // =========================================================================
   ? Pad("Test 1 -- Do Loop, 10 Files, No Relation",60)
   nSec := Seconds()
   For x := 1 to nFiles
      dbSelectArea(x)
      Do While !Eof()
         dbSkip()
      Enddo
   Next
   LogTest(1, Seconds() - nSec )

   // =========================================================================
   // Test 2
   // =========================================================================
   Sales->(dbSetRelation( "Clients", { || Sales->CliNum } ))
   Sales->(dbSetRelation( "Trans", { || Sales->SaleNum } ))
   Trans->(dbSetRelation( "Items", { || Trans->PackCode } ))

   ? Pad("Test 2 -- Do Loop, 3 Related Files, Loop thru Sales",60)
   nSec := Seconds()
   Sales->(dbGoTop())
   Do While !Sales->(Eof())
      Sales->(dbSkip())
   Enddo
   LogTest( 2, Seconds() - nSec )

   Sales->(dbClearRel())
   Trans->(dbClearRel())

   // =========================================================================
   // Test 3
   // =========================================================================
   dbUseArea(.t.,,"Seeks",,.t.,.f.)
   ? Pad("Test 3 -- Random SEEK Loop (" + Ltrim(Str(Seeks->(RecCount()))) + " seeks)",60)
   nSec := Seconds()
   Seeks->(dbGoTop())
   Do While !Seeks->(Eof())
      (Seeks->Alias)->(dbSeek(Seeks->Key))
      Seeks->(dbSkip())
   Enddo
   LogTest( 3, Seconds() - nSec )
   Seeks->(dbCloseArea())

   // =========================================================================
   // Test 4
   // =========================================================================
   ? Pad("Test 4 -- Append 500 Records to 4 files",60)
   nSec := Seconds()
   For y := 1 To 500
      For x := 1 To 4
         dbSelectArea(x)
         Do While !Flock()
         Enddo
         dbAppend()
         Do While NetErr()
            dbAppend()
         Enddo
         AEval( aKeyFields[x], { |n| Iif( n[1] != NIL, FieldPut(n[1], ;
            Iif( ValType(FieldGet(n[1])) = "N", Iif(y*x < n[2], x*y, n[2]-x), ;
            Str(y*x,n[2]) ) ), Nil ) } )
         dbUnLock()
      Next
   Next
   LogTest( 4, Seconds() - nSec )

   // =========================================================================
   // Test 5
   // =========================================================================
   ? Pad("Test 5 -- Update Keys Randomly for databases",60)
   nSec := Seconds()
   For y := 1 To 500
      For x := 1 To 4
         dbSelectArea(x)
         z := ((z := Seconds()) - Int(z)) * 100  // Get # between 1 & 100
         z := Round(RecCount()/100 * z,0)
         If z > RecNo()
            dbGoto(x*y)
         Else
            dbGoto(z)
         Endif
         Do While !Rlock()
         Enddo
         AEval( aKeyFields[x], { |n| Iif( n[1] != NIL, FieldPut(n[1], ;
            Iif( ValType(FieldGet(n[1])) = "N", Iif(y*x < n[2], x*y, n[2]-x), ;
            Str(y*x,n[2]) ) ), Nil ) } )
         dbUnLock()
      Next
   Next
   LogTest( 5, Seconds() - nSec )

   dbCloseAll()

   DevPos(24,0)
Return Nil

*****************************************************************
Function OpenFiles()

   dbUseArea(.t.,,"Sales",,.t.,.f.)
   If IndexExt() = ".NTX"
      dbSetIndex("Sales1")
      dbSetIndex("Sales2")
      dbSetIndex("Sales3")
      dbSetIndex("Sales4")
      dbSetIndex("Sales5")
   Else
      dbSetIndex(Alias())
   Endif

   dbUseArea(.t.,,"Clients",,.t.,.f.)
   If IndexExt() = ".NTX"
      dbSetIndex("Clients1")
      dbSetIndex("Clients2")
      dbSetIndex("Clients3")
      dbSetIndex("Clients4")
      dbSetIndex("Clients5")
   Else
      dbSetIndex(Alias())
   Endif

   dbUseArea(.t.,,"Trans",,.t.,.f.)
   If IndexExt() = ".NTX"
      dbSetIndex("Trans1")
      dbSetIndex("Trans2")
      dbSetIndex("Trans3")
      dbSetIndex("Trans4")
      dbSetIndex("Trans5")
   Else
      dbSetIndex(Alias())
   Endif

   dbUseArea(.t.,,"Items",,.t.,.f.)
   If IndexExt() = ".NTX"
      dbSetIndex("Items1")
      dbSetIndex("Items2")
      dbSetIndex("Items3")
      dbSetIndex("Items4")
      dbSetIndex("Items5")
   Else
      dbSetIndex(Alias())
   Endif

   dbUseArea(.t.,,"Log",,.t.,.f.)

Return Select()

*****************************************************************
Static Function LogTest( nTest, nSeconds )
   ?? "Seconds: " + Ltrim(Str(nSeconds,10,2))

   Do While !Log->(Flock())
   Enddo
   Log->(dbAppend())
   Log->Test      := nTest
   Log->Date      := Date()
   Log->Time      := Time()
   Log->Seconds   := nSeconds
   Log->Info      := Substr(dBSetDriver(),4) + " " + Substr(Version(),13,4) + " " + cInfo
   Log->(dbUnLock())
   dbCommitAll()

Return Nil

External StrZero
