* Author.: Joseph D. Booth
* Company: Precision Engineered Parts, Inc
*          610 Lakeside Drive
*          Southhampton, PA 18966
*
* W Phone: 215-953-1202    (8:30-5:30 E.S.T)
*
* H Phone: 215-245-6774
*
* Purpose: These functions may be used to automate the process of preparing
*          memory variables for each field in a workarea.
*
*           AUTOMEM() - prepare memory variables for each field in the
*                       selected workarea
*
*                       and
*
*           AUTOREP() - replace the memory variables back into the database
*                       fields
*
* Syntax.: AUTOMEM( <expC1> , <expC2> , <expL1> )
* Where..:
*          <expC1>     the memory varible prefix (usually "M_")
*
*          <expC2>     the workarea to build variables for
*
*          <expL1>     if .T., variables created contain the fields from
*                      the database
*
*                      if .F., variables created are empty
*
* Returns:  .T.      If workarea was found, and variables created
*           .F.      An error occurred
*
*
* Syntax.: AUTOREP( <expC1> , <expC2> )
* Where..:
*          <expC1>     the memory varible prefix (usually "M_")
*
*          <expC2>     the workarea to REPLACE variables into
*
*
* Returns:   .T.     Record replaced OK.
*            .F.     An error occurred.
*
*
* Notes..:  With these functions, a file update routine might look as
*           follows:
*
*           USE customer  INDEX custcode
*           SEEK m_code
*           newcust = eof()
*           IF automem( "M_","CUSTOMER",found() )
*                 :
*                 :
*              GET's / READ command
*
*              IF lastkey() <> 27
*                 IF newcust
*                    APPEND BLANK
*                 ENDIF
*                 autorep("M_","CUSTOMER")
*              ENDIF
*           ELSE
*              * An error occurred
*           ENDIF
*
* Since these functions make use of macros, a bit of a slow down may be noticed
* when using large (many fields) databases.  I've used it with database up to
* about 40-50 fields before I noticed the slowdown, but then again, I am using
* a 386 machine at 16 Mg. (I have a nice boss!!)
*
* If you find these functions useful, a $5 contribution is requested.
*
*****************************************************************************
FUNCTION automem
*
* Automatically create memory variables to holds fields from a database
*
PARAMETER a_prefix,a_workarea,a_chg
PRIVATE a_k,a_field,a_type,a_return

a_return = .F.

SELECT &a_workarea

IF alias() = a_workarea

   FOR a_k = 1 TO fcount()
      a_field   =  field(a_k)
      a_type    =  type("&a_field")
      IF a_type <> "M"
         PUBLIC &a_prefix&a_field
         DO CASE
            CASE a_type = "C"
                 &a_prefix&a_field = iif(a_chg, &a_field , SPAC(LEN(&mm_field)) )
            CASE a_type = "D"
                 &a_prefix&a_field = iif(a_chg, &a_field , CTOD("  /  /  ") )
            CASE a_type = "L"
                 &a_prefix&a_field = iif(a_chg, &a_field , .F. )
            CASE a_type = "N"
                 &a_prefix&a_field = iif(a_chg, &a_field , 0 )
         ENDCASE
      ENDIF
   NEXT

   a_return = .T.

ENDIF

RETURN a_return

* ---------------------------------------------------------------------------

FUNCTION autorep
*
* Automatically REPLACE values into a database
*
PARAMETER a_prefix,a_workarea
PRIVATE a_k,a_field,a_type,a_rep,a_return

a_return = .F.

SELECT &a_workarea

IF alias() = a_workarea

   FOR a_k = 1 TO fcount()

      a_field = field(a_k)
      a_type  = type("&a_field")
      a_rep   = trim(a_prefix)+a_field

      IF a_type <> "M"
         REPL &a_field WITH &a_rep
      ENDIF

   NEXT
   a_return = .T.

ENDIF

RETURN a_return

* ---------------------------------------------------------------------------