* PROCEDURE automem

* NOTE: this is a revision to a previously released program called
*       FILE2MEM.PRG by Jerry Whittaker

* Creates and releases public memory variables of same type and size
*   as fields in the file (except memo fields) using .dbf field names 
*   as the controlling parameters

* Appends and/or replaces file fields from memory variables
*   using .dbf field names as the controlling parameters

* works with dBASE III+ or FoxBASE+ and likely all other dBASE work-alikes

* Author:  Jerry Whittaker
*          6210 Constance Circle N.W.
*          Canton, Ohio 44718

* Date: 04/04/88 - first writing
*       09/15/88 - all prior revisions are history - released to public
*                  domain - enjoy!


*************************************************************************
*                                                                       *
* The calling syntax for AUTOMEM is: DO AUTOMEM WITH <param>            *
*                                                                       *
* Here are the parameters which can be passed and the operations they   *
* perform.                                                              *
*                                                                       *
*   PARAM          FUNCTION                                             *
*   ---------------------------------------------------------------     *
*    "C"           Create memory variables with the same names          *
*                  as the fields in the currently selected file         *
*                  and fill the variables with the data from the        *
*                  record.                                              *
*                                                                       *
*    "B"           Create Blank memory variables with the same          *
*                  names as the fields in the currently selected        *
*                  file.                                                *
*                                                                       *
*    "R"           Replace the data in the current record with data     *
*                  from memory variables sharing the same names as      *
*                  the fields.                                          *
*                                                                       *
*    "A"           Append a blank record to the file and fill the       *
*                  fields with data from memory variables sharing the   *
*                  same names as the fields.                            *
*                                                                       *
*    "X"           Remove memory variables having the same names        *
*                  as the fields in the currently select file.          *
*                                                                       *
*************************************************************************


PARAMETERS action

* make all memvars used in routine private
PRIVATE action,field_nm,field_cntr,file_nm

action = UPPER(action)

* if action is for blank record (the "phantom record")
*    or action is for file append, move file pointer
*    all other actions assume the current record
DO CASE
   CASE action = 'B' .AND. RECCOUNT() <> 0
      * if the file is empty (zero records) we already on a
      *   'phantom-like' record otherwise need to go to the real phantom
      * (prevends 'end of file encountered' error on empty file)
      GO BOTTOM
      SKIP
   CASE action = 'A'   && append a blank record
      APPEND BLANK
ENDCASE

* process up to 128 field names - if using FoxBASE+ you could use
*   FCOUNT() function here and remove the null field-name check
*   i.e.     DO WHILE field_cntr <= FCOUNT()

field_cntr = 1
DO WHILE field_cntr < 129 .AND. '' <> field(field_cntr)
   * create a memory variable of the field name
   field_nm = field(field_cntr)

   DO CASE
      CASE (action = 'B' .OR. action = 'C') .AND. ;
           TYPE('field(field_cntr)') <> 'M'  && cannot use memo fields
         * create a public memvar with same name as the file field
         PUBLIC &field_nm
         * store the content of the file field to the memory variable
         m->&field_nm = &field_nm
      CASE action = 'X'
         * release the memory variable
         RELEASE &field_nm
      CASE (action = 'R' .OR. action = 'A') .AND. ;
         TYPE('field(field_cntr)') <> 'M'  && cannot use memo fields
         * replace the content file field with the
         *   content of the memvar
         IF TYPE("&field_nm") = "C"
            * left justify character fileds
            REPLACE &field_nm WITH LTRIM(m->&field_nm)
         ELSE
            REPLACE &field_nm WITH &field_nm
         ENDIF
   ENDCASE
   field_cntr = field_cntr + 1
ENDDO

RETURN

*----------------------- end of Procedure AUTOMEM -------------------------
