* Program ...: Boxutil.PRG
* Author ....: James Chuang
* Date ......: March 1, 1988
* Notes .....: Procedure called by Boxes.PRG.

PROCEDURE Box

PARAMETERS tc, tr, bc, br, pagec, tbox

* ---Put single or double box character set in the working variables.
IF tbox = "S"
   tlcner = stlcner
   trcner = strcner
   blcner = sblcner
   brcner = sbrcner
   across = sacross
   vert   = svert
ELSE
   tlcner = dtlcner
   trcner = dtrcner
   blcner = dblcner
   brcner = dbrcner
   across = dacross
   vert   = dvert
ENDIF


DO CASE
CASE tr = br
   * ---Horizontal line only.
   lineh = [@ ] + STR(br, 2, 0) + [, ] +;
           STR(tc, 2, 0) + [  SAY REPL(CHR(] +;
           STR(ASC(across), 3, 0) + [),] +;
           STR(bc - tc + 1, 3) + [) ]
   APPEND BLANK
   REPLACE Content WITH lineh,;
           Pagenum WITH pagec
   RETURN

CASE tc = bc
   * ---Vertical line only.
   workline = tr
   DO WHILE workline <= br
      lineh = "@ " + STR(workline, 2, 0) + ", " + ;
              STR(tc, 2, 0) + [  SAY "] + vert + ["]
      APPEND BLANK
      REPLACE Content WITH lineh,;
              Pagenum WITH pagec
      workline = workline + 1
   ENDDO
   RETURN

OTHERWISE

   * ---Top line of box.
   lineh = [@ ] + STR(tr, 2, 0) + [, ] + ;
           STR(tc, 2, 0) + [  SAY "] +;
           tlcner + [" + REPL(CHR(] + ;
           STR(ASC(across), 3, 0) + [),] +;
           STR(bc - tc - 1, 3) + [) + "] + trcner + ["]
   APPEND BLANK
   REPLACE Content WITH lineh,;
           Pagenum WITH pagec

   * ---Bottom line of box.
   lineh = [@ ] + STR(br, 2, 0) + [, ] +;
           STR(tc, 2, 0) + [  SAY "] +;
           blcner + [" + REPL(CHR(] + ;
           STR(ASC(across), 3, 0) + [),] +;
           STR(bc - tc - 1, 3) + [) + "] + brcner + ["]
   APPEND BLANK
   REPLACE Content WITH lineh,;
           Pagenum WITH pagec

   * ---Insert the vertical lines.
   workline = tr + 1
   DO WHILE workline < br
      lineh = "@ " + STR(workline, 2, 0) + ", " +;
              STR(tc, 2, 0) + [  SAY "] + vert + ["]
      APPEND BLANK
      REPLACE Content WITH lineh,;
              Pagenum WITH pagec
      lineh = "@ " + STR(workline, 2, 0) + ", " +;
              STR(bc, 2, 0) + [  SAY "] + vert + ["]
      APPEND BLANK
      REPLACE Content WITH lineh,;
              Pagenum WITH pagec
      workline = workline + 1
   ENDDO
ENDCASE
RETURN
* EOP: Boxutil.PRG

