#include <nandef.h>
#include <extend.h>

/*****************************************************************************/
/*                                                                           */
/* Author:  John Kaster                                                      */
/* Date..:  3/22/1989                                                        */
/* Notice:  Released into the public domain                                  */
/*                                                                           */
/* This function is handy for two things:                                    */
/* 1.  It allows you to use ASSEMBLER and C functions (like those in FUNCKY) */
/*     with Clipper color settings FROM Clipper, as most of these routines   */
/*     require an integer representation of the color.                       */
/*                                                                           */
/* 2.  It can easily be modified to allow you to code color settings in C    */
/*     with Clipper-style strings.  Handy for those of you (like me) who do  */
/*     cross-language applications.                                          */
/*                                                                           */
/* Syntax:                                                                   */
/*                                                                           */
/*    attrib = attrval( <color setting string> )                             */
/*                                                                           */
/*    for example,                                                           */
/*                                                                           */
/*    attrval( 'GR+' )        ==> 14                                         */
/*    attrval( 'GR+/gb+' )    ==> 62                                         */
/*    attrval( 'W*' )         ==> 135                                        */
/*    attrval( 'R+' )         ==> 12                                         */
/*    attrval( 'N/W+' )       ==> 120                                        */
/*                                                                           */
/*    any value above 128 will blink, unless you use something like dLesko's */
/*    blinkbit(.f.) (see my message on KWIBBLE) which will enable you to     */
/*    have high-intensity background colors.                                 */
/*                                                                           */
/*****************************************************************************/


#define BLUE 1
#define GREEN 2
#define RED 4
#define WHITE 7
#define tolower(c)      ( (c) >= 'A' && (c) <= 'Z' ? (c)-'A'+'a' : (c) )

CLIPPER attrval( void )
{
   if ( ISCHAR( 1 ) )
   {
      int   f        = 0,
            b        = 0,
            onback   = 0,
            blink    = 0;

      char *att;

      att = _parc( 1 );

      do
      {
         switch ( tolower( *att ) )
         {
         case 'r':
            if ( onback )
               b += RED;
            else
               f += RED;
            break;
         case 'g':
            if ( onback )
               b += GREEN;
            else
               f += GREEN;
            break;
         case 'b':
            if ( onback )
               b += BLUE;
            else
               f += BLUE;
            break;
         case 'w':
            if ( onback )
               b += WHITE;
            else
               f += WHITE;
            break;
         case '/':
            onback = 1;
            break;
         case '*':
            blink = 1;
            break;
         case '+':
            f += 8;
         }
      }
      while ( *att++ );

      _retni ( f + ( b * 16 ) + ( (blink) ? 128 : 0 ) );
   }
   else
      _retni( 7 ); /* white */

}
