/****************************************************************
*  ATC.C                                                        *
*                                                               *
*  By        : Leonard Zerman                                   *
*  Notice    : Placed into the Public Domain by Leonard Zerman  *
*  Date      : 04/28/1990                                       *
*  Version   : 1.01                                             *
*  Revision  : None                                             *
*  Syntax    : ATC(<search char>, <search str>, [<occurence>])  *
*  Returns   : Position of search char of Nth occurence         *
*              in search str case insensitive.                  *
*  Compile   : CL /AL /Gs /Zl /FPa /oalt /c atc.c               *
*  Operation :                                                  *
*  Notes     : nandef.h and extend.h must be in current dir     *
****************************************************************/
/****************************************************************
* Revision   : 05/01/90 LAZ                                     *
*              Made all ints unsigned to work with 64K strings  *
*              Made occurence an optional parameter             *
****************************************************************/

#define islower(p)  ('a' <= (p) && (p) <= 'z')
#define toupper(p)  (islower(p) ? ((p) - ('a' - 'A')) : (p))
#define ERROR       -1

#define CLIPPER                 /* define for use with Clipper */

#ifdef CLIPPER                  /* if CLIPPER function */
#undef CLIPPER                  /* redefine in extend.h */
#include "nandef.h"             /* Clipper defines */
#include "extend.h"             /* Extend System declares */
#endif

/*-----------------------* C Function *------------------------*/

unsigned int atc(char c, char * string, unsigned int occurence)
{
   unsigned int i;
   unsigned int pos;

   c = toupper(c);      /* upper case search char */
   for (i = pos = 0; *string; i++, string++)
   {
      if (toupper(*string) == c)  /* match ? */
      {
         occurence--;            /* dec occurences */
         if (occurence == 0)     /* if last occurence */
         {
            pos = (++i);         /* position in string */
            break;
         }
      }
   }
   return(pos);                   /* return position */
}

/*-----------------* Clipper callable function *---------------*/

CLIPPER ATC(void)
{
   int pcount;
   unsigned int occurence;

   pcount = PCOUNT;

   if (!((pcount >= 2) && ISCHAR(1) && ISCHAR(2)))
   {
        _retni(ERROR);  /* NO, return ERROR */
        return;
   }

   if (pcount > 2)
   {
      if (!ISNUM(3))
      {
           _retni(ERROR);  /* NO, return ERROR */
           return;
      }
      occurence = (unsigned int) _parnl(3); /* get start pos */
   }
   else
      occurence = 1;    /* default for optional parameter */
   _retnl((long)atc(*_parc(1), _parc(2), occurence));
}

/*------------------------* EOF ATC.C *------------------------*/

