/*	atint2f.c	Copyright 1991 Code Craft Software	*/

/*	A sample int 2Fh handler for Turbo C	*/

static void interrupt (*oldint2f)();
static void interrupt newint2f();
void hookint2f(void);
void unhookint2f(void);

void hookint2f(void)
{
	oldint2f = getvect(0x2f);
	setvect(0x2f, newint2f);
}

void unhookint2f(void)
{
	setvect(0x16, oldint16);
}

static void interrupt newint2f()
{
	unsigned char ah, al;

	ah = _AH;
	al = _AL;
	if (ah == 0xCF)	{		/*	our id?				*/
		if (al == 0)         /*	id check request	*/
			al = 0xFF;        /*	say we're here		*/
		else	{
			if (al == 1)		{	/*	keyboard status request	*/
				if (buffer_empty_expression)
					al = 0;		/*	0 keys in buffer				*/
				else
					al = 1;		/*	more than 0 keys in buffer	*/
			}
			else
				al = 0xEE;		/*	unknown request				*/
		}
		_AL = al;
	}
	else	{
		_AH = ah;
		_AL = al;
		(*oldint2f)();
	}
}
