/* File .......: ASVRD.Prg
 * Author .....: Brad Choate   (CS ID: 75056,1247)
 * Date .......: 11/29/1990
 * Revision ...: 1

 * See also ...: File ASVRD.CH

       ***

 * Function ...: SaveArray
 * Syntax .....: SaveArray( <aVar> , <cFilename> )
 * Returns ....: .T. if Successful, .F. if not.

 * Purpose ....: To save a multi-dimensional array structure to a file,
 * ............: keeping the structure of said array intact.  This file may
 * ............: be processed at a later time to restore the array using
 * ............: the ReadArray function.

 * Method .....: This function is not recursive.  It uses a stack (another
 * ............: separate array).  I just found out that I am not able to
 * ............: really put into words how this function operates... isn't
 * ............: it enough that I'm giving it freely to the Nantucket Forum??

 * Notes ......: IF YOU MAKE _ANY_ REVISIONS, I WOULD REALLY APPRECIATE
 * ............: SEEING THEM MYSELF -->> CS ID: 75056,1247.

 The function does work rather well, because it passed the test of saving
 and reading the following array structure:

              {{{"abc",23},45,{"ABC","DEF","GHI"}},{23}}
           (The output file size was exactly 46 bytes long)

 */

FUNCTION SaveArray(aVar,cFile)

LOCAL aStack:={},elem:=aVar,where:=1,done:=.F.,fout

IF pcount()#2 .OR. valtype(cFile)#"C" .OR. valtype(aVar)#"A"
   RETURN .F.
ENDIF

fout:=fcreate(cFile)

IF fout<0            // error check for failure to create the file.
   RETURN .F.
ENDIF

BEGIN SEQUENCE
   DO WHILE !done
      typ:=valtype(elem)
      DO CASE
      CASE typ="A"
         fc:=fwrite(fout,"A"+i2bin(len(elem)),3)
         IF fc#3
            BREAK
         ENDIF
         aadd(aStack,{elem,2})
         elem:=elem[1]
         loop
      CASE typ="L"
         elem:=if(elem,chr(1),chr(0))
      CASE typ="D"
         elem:=dtoc(elem)
      CASE typ="N"
         elem:=ltrim(str(elem))
      ENDCASE
      IF typ$"CLDN"
         IF typ="C"
            clen:=i2bin(len(elem))
         ELSEIF typ="L"
            clen:=""
         ELSE
            clen:=chr(len(elem))
         ENDIF
         fc:=fwrite(fout,typ+clen+elem,1+len(clen)+len(elem))
         IF fc#(1+len(clen)+len(elem))
            BREAK
         ENDIF
      ELSE
         fc:=fwrite(fout,"U",1)
         IF fc#1
            BREAK
         ENDIF
      ENDIF
      IF len(aStack)=0
         EXIT
      ELSE
         DO WHILE .T.
            elem:=aStack[len(aStack),1]
            where:=aStack[len(aStack),2]
            IF where>len(elem)
               IF len(aStack)>1
                  asize(aStack,len(aStack)-1)
               ELSE
                  done:=.T.
                  EXIT
               ENDIF
            ELSE
               elem:=elem[where]
               aStack[len(aStack),2]++
               EXIT
            ENDIF
         ENDDO
      ENDIF
   ENDDO
END SEQUENCE

fclose(fout)

RETURN done

       ***

/* Function ...: ReadArray
 * Syntax .....: ReadArray( @<aVar> , <cFile> )
 * Returns ....: .T. if successful, .F. if not.
 * Purpose ....: To restore an array from a file created by SaveArray.
 */

FUNCTION ReadArray(aVar,cFile)

LOCAL aLen:=1,aStack:={},elem,done:=.F.,c,fin,aHold:=aVar,fc

IF pcount()#2 .OR. valtype(cFile)#"C"
   RETURN .F.
ENDIF

fin:=if(file(cFile),fopen(cFile),-1)

IF fin<0
   RETURN .F.
ENDIF

aVar:={}

BEGIN SEQUENCE
   DO WHILE !done
      c:=" "
      fc:=fread(fin,@c,1)
      IF fc#1
         BREAK
      ENDIF
      DO CASE
      CASE c="A"
         c="  "
         fc:=fread(fin,@c,2)
         IF fc#2
            BREAK
         ENDIF
         aAdd(aStack,{aVar,aLen-1})
         aLen:=bin2i(c)
         aVar:={}
         loop
      CASE c$"CND"
         clen:=" "+if(c="C"," ","")      // if character, string length is
         fc:=fread(fin,@clen,len(clen))  // stored in two bytes for maxlen=64k
         IF fc#if(c="C",2,1)
            BREAK
         ENDIF
         clen:=if(c="C",bin2i(clen),asc(clen))
         cstr:=repl(" ",clen)
         fc:=fread(fin,@cstr,clen)
         IF fc#clen
            BREAK
         ENDIF
         IF c="C"
            elem:=cstr
         ELSEIF c="N"
            elem:=val(cstr)
         ELSEIF c="D"
            elem:=ctod(cstr)
         ENDIF
      CASE c="L"
         fc:=fread(fin,@c,1)
         IF fc#1
            BREAK
         ENDIF
         elem:=(c=chr(1))
      CASE c="U"
         elem:=NIL
      ENDCASE
      aAdd(aVar,elem)
      aLen--
      IF aLen=0
         DO WHILE .T.
            aAdd(aStack[len(aStack),1],aVar)
            aVar:=aStack[len(aStack),1]
            aLen:=aStack[len(aStack),2]
            aSize(aStack,len(aStack)-1)
            IF len(aStack)=0
               done:=.T.
               EXIT
            ELSEIF aLen>0
               EXIT
            ENDIF
         ENDDO
      ENDIF
   ENDDO
END SEQUENCE

IF done             // if file read worked properly, done should be .T.
                    // (can only be .F. by issue of a BREAK
   aVar:=aVar[1]    // method of "stacking" nests array one level too deep
ELSE
   aVar:=aHold      // restore original value if file read failed
ENDIF
   
fclose(fin)         // file must be closed whether routine worked or not

RETURN done         // return with status



/*  Please direct all questions/comments to:
 *
 *  Software Extensions, Incorporated
 *  P.O. Box 41952
 *  Memphis, TN  38174-1952
 *  (901) 274-8463
 *  CompuServe: 75056,1247
 *
 *  Ask for Barbara.
 *
 *  Software Extensions is a professional programming corporation specializing
 *  in Clipper/C software development.
 */


* EOF: ASVRD.Prg
