
#include <extend5.h>
#include <math.h>

/******************************************************************************
* ASTDDEV()
* Syntax: ASTDDEV( <Array> )
* Return: Standardabweichung ber alle numerischen Array-Elemente
*/

CLIPPER ASTDDEV()
{
    int count;
    double sum;
    double sqrsum;
    double stddev;
    int k;

    count = 0;
    sum = 0;
    sqrsum = 0;
    stddev = 0;

    if ( PCOUNT == 1 && ISARRAY(1) )
    {
         for ( k = 1; k <= ALENGTH(1); k++ )
         {
              if ( _parinfa(1,k) == NUMERIC )
              {
                   sum = sum + _parnd(1,k);
                   sqrsum = sqrsum + ( _parnd(1,k) * _parnd(1,k) );
                   count++;
              }
         }

         if ( count > 2 )
         {
              stddev = (sqrsum - ((sum*sum)/count)) / (count-1);
         }
    }
    _retnd(sqrt(stddev));
}

/******************************************************************************
*   eof: astddev.c
*/

