;   3 Clipper functions for S'87
;
;   By K. Stephan Larsen, January 1989 for use as a public domain
;     utility, no warrantees, guarantees, or any other promises implied.
;     Please offer comments and suggestions, not necessarily
;     good ones, either.  CIS 76370,1532   MST (303) 220-9050
;
;   Object code was assembled using Microsoft MASM 5.1
;
;   Usage:  DRIVE()       returns current DOS drive with colon
;
;           CURSOR()      returns .T. if cursor is ON, else .F.
;
;           TEMPNAME()    returns legal unique DOS filename
;
;
NAME ASM_UTIL
INCLUDE C:\CLIPPER\EXTENDA.INC      ; BE SURE TO PUT YOUR PATH HERE!!!

CODESEG  ASM_UTIL
DATASEG  DSEG

    CLpublic <CURSOR,DRIVE,TEMPNAME>

    CLstatic <byte DRV <<"?:",0>>>    ; string to return drive letter + ':'
    CLstatic <cptr DRV_PTR DRV>       ; pointer for Clipper to above string

    CLstatic <string TFILE <<".\",13 DUP (0)>>> ; string for temporary filename
    CLstatic <cptr TEMP_PTR TFILE>          ; pointer to the string for DOS
    CLstatic <cptr TEMP_PTR2 TFILE+2>       ; pointer to filename for Clipper

    $define    FALSE    0000h         ; return AX=0 for logical false
    $define    TRUE     0001h



CLfunc log    CURSOR    ; returns .T. if cursor is on, else .F.

CLcode
    mov    AH,0Fh       ; fetch current display page in BH
    int    10h
    mov    AH,03        ; fetch cursor size in CX
    int    10h
    mov    BH,CH        ; save cursor start row for later
    and    CH,20h       ; test if CH bit 5 is on (cursor off, all modes)
    jnz    OFF
    cmp    BH,CL        ; test if start line is less than stop line 
    jbe    ON           ; (cursor ON, text mode)
    
OFF:mov    AX,FALSE
    jmp    HOME
ON: mov    AX,TRUE

HOME:
    CLret  AX           ; end function "CURSOR"





CLfunc char    DRIVE    ; returns "X:" where X is current DOS drive

CLcode
    mov   AH,19h        ; fetch current DOS drive in AL
    int   21h
    add   AL,41h        ; make it alpha
    mov   DRV,AL        ; put it where Clipper can find it
    CLret DRV_PTR




CLfunc    char    TEMPNAME    ; returns unique DOS filename in cur. directory
                              ; requires DOS 3.00 & up
CLcode

   mov   TFILE+2,0      ; put 0 behind the ".\" path string

   xor   CX,CX          ; set file attribute to 0 (read/write)

   mov   DX,TEMP_PTR_OFF   ; load address of TFILE into DS:DX (DS by DATASEG)

   mov   AH,5Ah         ; DOS function 90 (5Ah) for temporary filename
   int   21h            ; returns temp filename and creates file in process

   mov   bx,ax          ; move handle to BX
   mov   ah,3eh         ; close handle
   int   21h

   mov   AH,41h         ; erase the file, we're returning a name only
   int   21h

OK:
   CLret TEMP_PTR2      ; return pointer for Clipper

end







