;   3 Clipper functions for S'87
;
;   By K. Stephan Larsen, January 2, 1989 for use as a public domain
;     utility, no warrantees, guarantees, or any other promises
;     implied.  Please offer comments and suggestions, not necessarily
;     good ones, either.
;
;   Englewood, CO 80111   (303) 220-9050   76370,1532 CIS
;
;   Assembled using Microsoft MASM 5.1
;
;   Usage:  DRIVE()       returns current DOS drive with colon
;
;           CURSOR()      returns .T. if cursor is ON, else .F.
;
;           TEMPNAME()    returns legal unique DOS filename
;
;
NAME ASM_UTIL
INCLUDE C:\CLIPPER\EXTENDA.INC      ; BE SURE TO PUT YOUR PATH HERE!!!

CODESEG    ASM_UTILITIES
DATASEG  DSEG

   CLpublic <CURSOR,DRIVE,TEMPNAME>

    CLstatic <byte DRV <<"?:",0>>>    ; string to return drive letter + ':'
    CLstatic <cptr DRV_PTR DRV>       ; pointer for Clipper to above string

    CLstatic <string TFILE <<13 DUP (0h)>>> ; string for temporary filename
    CLstatic <cptr TEMP_PTR TFILE> ; Clipper provided pointer to the string

    $define    FALSE    0000h         ; return AX=0 for logical false
    $define    TRUE     0001h



CLfunc log    CURSOR         ; returns .T. if cursor is on, else .F.

CLcode
    mov    AH,0Fh    ; fetch current display page in BH
    int    10h
    mov    AH,03     ; fetch cursor size in CX
    int    10h
    MOV    BH,CH     ; save cursor start row for later
    and    CH,20h    ; test if CH bit 5 is on (cursor off, all modes)
    jnz    OFF
    cmp    BH,CL     ; test if start line is less than stop line 
    jbe    ON        ; (cursor ON, text mode)
    
OFF:mov    AX,FALSE
    jmp    HOME
ON: mov    AX,TRUE

HOME:
    CLret  AX        ; end function "CURSOR"





CLfunc char    DRIVE          ; returns "X:" where X is current DOS drive

CLcode
    mov   AH,19h    ; fetch current DOS drive in AL
    int   21h
    add   AL,41h    ; make it alpha
    mov   DRV,AL    ; put it where Clipper can find it
    CLret    DRV_PTR






CLfunc    char    TEMPNAME    ; returns unique DOS filename in cur. directory
                              ; requires DOS 3.00 & up
CLcode

   mov   TFILE,0h    ; make filename storage area a null string
    mov    DX,TEMP_PTR_OFF    ; load address of TFILE into DS:DX (DS by DATASEG)

   xor   CX,CX       ; set file attribute (0 = read/write)

    mov    AH,5Ah    ; function for temporary filename
    int    21h       ; returns temp filename, creating file in process
   ;  NOTE: some versions of DOS preceed name with '\' (root dir. only)

   mov   AH,41h      ; erase the file, we're returning a name only
   int   21h
   mov   AL,TFILE    ; check for backslash
   cmp   AL,'\'
   jne   OK          ; if not there, terminate normally

   push  ES          ; need to move file string up one byte, first save ES
   push  DS
   pop   ES          ; put destination in ES:DI  (TFILE's address)
   mov   DI,DX
   mov   SI,DI       ; start source string after the '\' (TFILE's addr + 1)
   inc   SI
   mov   CX,0Dh      ; move 13 characters (12 for the name + 00h)
   cld
rep   movsb
   pop   ES          ; restore Clipper's ES
OK:
    CLret    TEMP_PTR    ; return pointer for Clipper

end    ; th - th- th- that's all folks!







