;***************************************************************************
;* Filename: ASC_EBC.ASM                                                   *
;* Author:   J.D. Wegner  Compuserve 74146,167   Source NA2306             *
;* Date:     09/02/86                                                      *
;*                                                                         *
;* Purpose:  Clipper-callable Assembly Language routines to translate an   *
;*           ASCII string to EBCDIC or vice versa                          *
;*                                                                         *
;* Usage:    STORE <string expression> TO <memvar>                         *
;*           CALL ebcdic WITH <memvar>                                     *
;*           CALL ascii  WITH <memvar>                                     *
;*                                                                         *
;* Returns:  each character of <memvar> is translated to the named code.   *
;***************************************************************************

            PUBLIC  EBCDIC
            PUBLIC  ASCII

_PROG       SEGMENT BYTE
            ASSUME  CS:_PROG,DS:_PROG,ES:NOTHING,SS:NOTHING

A2ETABLE    DB      000H,040H,040H,040H,040H,040H,040H,040H
            DB      040H,040H,040H,040H,040H,040H,040H,040H
            DB      040H,040H,040H,040H,040H,040H,040H,040H
            DB      040H,040H,040H,040H,040H,040H,040H,040H
            DB      040H,04FH,07FH,07BH,05BH,06CH,050H,07DH
            DB      04DH,05DH,05CH,04EH,06BH,060H,04BH,061H
            DB      0F0H,0F1H,0F2H,0F3H,0F4H,0F5H,0F6H,0F7H
            DB      0F8H,0F9H,07AH,05EH,04CH,07EH,06EH,06FH
            DB      07CH,0C1H,0C2H,0C3H,0C4H,0C5H,0C6H,0C7H
            DB      0C8H,0C9H,0D1H,0D2H,0D3H,0D4H,0D5H,0D6H
            DB      0D7H,0D8H,0D9H,0E2H,0E3H,0E4H,0E5H,0E6H
            DB      0E7H,0E8H,0E9H,04AH,0E0H,05AH,05FH,06DH
            DB      079H,081H,082H,083H,084H,085H,086H,087H
            DB      088H,089H,091H,092H,093H,094H,095H,096H
            DB      097H,098H,099H,0A2H,0A3H,0A4H,0A5H,0A6H
            DB      0A7H,0A8H,0A9H,0C0H,06AH,0D0H,0A1H,08FH
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H

E2ATABLE    DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      020H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,05BH,02EH,03CH,028H,02BH,021H
            DB      026H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,05DH,024H,02AH,029H,03BH,05EH
            DB      02DH,02FH,000H,000H,000H,000H,000H,000H
            DB      000H,000H,07CH,02CH,025H,05FH,03EH,03FH
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,060H,03AH,023H,040H,027H,03DH,022H
            DB      000H,061H,062H,063H,064H,065H,066H,067H
            DB      068H,069H,000H,000H,000H,000H,000H,07FH
            DB      000H,06AH,06BH,06CH,06DH,06EH,06FH,070H
            DB      071H,072H,000H,000H,000H,000H,000H,000H
            DB      000H,07EH,073H,074H,075H,076H,077H,078H
            DB      079H,07AH,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      000H,000H,000H,000H,000H,000H,000H,000H
            DB      07BH,041H,042H,043H,044H,045H,046H,047H
            DB      048H,049H,000H,000H,000H,000H,000H,000H
            DB      07DH,04AH,04BH,04CH,04DH,04EH,04FH,050H
            DB      051H,052H,000H,000H,000H,000H,000H,000H
            DB      05CH,000H,053H,054H,055H,056H,057H,058H
            DB      059H,05AH,000H,000H,000H,000H,000H,000H
            DB      030H,031H,032H,033H,034H,035H,036H,037H
            DB      038H,039H,000H,000H,000H,000H,000H,000H


EBCDIC      PROC    FAR
            PUSH    BP
            MOV     BP,SP

            PUSH    DS
            MOV     BX,OFFSET A2ETABLE
            LDS     SI,DWORD PTR [BP+6]

L1:         MOV     AL,[SI]
            OR      AL,AL
            JZ      RET1
            XLAT    CS:A2ETABLE
            MOV     [SI],AL
            INC     SI

            JMP     L1

RET1:       POP     DS
            POP     BP
            RET

EBCDIC      ENDP



ASCII       PROC    FAR
            PUSH    BP
            MOV     BP,SP

            PUSH    DS
            MOV     BX,OFFSET E2ATABLE
            LDS     SI,DWORD PTR [BP+6]

L2:         MOV     AL,[SI]
            OR      AL,AL
            JZ      RET2
            XLAT    CS:E2ATABLE
            MOV     [SI],AL
            INC     SI
            JMP     L2

RET2:       POP     DS
            POP     BP
            RET

ASCII       ENDP

_PROG       ENDS
            END
