;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;;
;;                      ASCII table for brief
;;
;;        This macro is used to display an ASCII table in Brief.  
;;    
;;  Add this macro to your initials macro and initialize it to use <Ctrl-a>
;;
;;       ascii.m     source code, this file
;;       ascii.cm    compiled macro
;;       ascii.tab   actual ascii table ; read only
;;
;;    ENTER inserts the character under cursor to the edit buffer and
;;    ESC just displays its data on the status line.
;;
;;    Roy Rumaner
;;    Rumaner Consulting
;;    6158 Knollway Drive
;;    Willowbrook, IL 60514
;;    (312) 654-2723
;;
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

(macro id_char
	(
		(string in_char)
		(int ascii)
		(= in_char (read 1))
		(= ascii (atoi in_char 0))
		(if (< ascii 0)
	      (= ascii (+ ascii 256))
		)
		(message "Character is %c : Decimal # %d : Hex is %X " ascii ascii ascii)
	)
)
(macro mup
   (
      (up)
      (up)
      (id_char)
   )
)
(macro mdun
   (
      (int line)
      (inq_position line)
      (if (<= line 23)
         (
            (down)
            (down)
            (id_char)
         )
      )
   )
)
(macro mnxtw
   (
      (int line col)
      (inq_position line col)
      (if (< col 63)
         (
            (next_char)
            (next_char)
         )
      ;else
         ;(if (< line 15)
         (if (< line 25)
            (
               (beginning_of_line)
               (down)
               (down)
            )
         )
      )
      (id_char)
   )                        
)
(macro mprvw
   (
      (int line col)
      (inq_position line col)
      (if (&& (== col 1) (> line 1))
         (
            (end_of_line)
            (prev_char)
            (up)
            (up)
         )
      ;else
         (
            (prev_char)
            (prev_char)
         )
      )
      (id_char)
   )
)
(macro mhome
   (
      (top_of_buffer)
      (id_char)
   )
)
(macro mend
   (
      (end_of_buffer)
      (prev_char)
      (id_char)
   )
)
(macro mergchar
   (
      (int domerge)
      (string mergchr)
      (global domerge mergchr)
      (= domerge 1)
      (= mergchr (read 1))
      (exit)
   )
)
(macro ascii
	(
		(int under_buf over_buf begin end no_table)
		(string bpath table_path bpath_part)
      (= domerge 0)
		(= bpath (inq_environment "BPATH"))
		(= no_table 0)
		(= table_path "ascii.tab")
		(while (&& (! (exist table_path)) (! no_table))
			(
				(if (!= 0 (= end (index bpath "\;")))
					(				
						(= begin 1)
						(= bpath_part (substr bpath begin (- end 1)))
						(= table_path (+ bpath_part "\\ascii.tab"))
						(= bpath (substr bpath (+ end 1)))
					)
				; else
					(
						(= table_path (+ bpath "\\ascii.tab"))
						(if (! (exist table_path))
							(
								(error "ASCII table not found.")
								(= no_table 1)
							)
						)
					)
				)
			)
		)
		(if (! no_table)
			(
				(= under_buf (inq_buffer))
				(= over_buf (create_buffer "ASCII TABLE" table_path 0))
				(create_window 8 18 72 1 " Use  or , [Esc] Ends, [] Inserts char. - R. Rumaner ")
				(attach_buffer over_buf)
				(set_buffer over_buf)
				(refresh)
				(keyboard_push)
				(assign_to_key "#27" "exit")
				(assign_to_key "%#45" "exit")
 				(assign_to_key "%#72" "mup")
				(assign_to_key "%#77" "mnxtw")
				(assign_to_key "%#80" "mdun")
				(assign_to_key "%#75" "mprvw")
           (assign_to_key "#29696" "mnxtw")
				(assign_to_key "#29440" "mprvw")
           (assign_to_key "#18176" "mhome")
		     (assign_to_key "#20224" "mend")
           (assign_to_key "#7181" "mergchar")
           (id_char)
				(process)
 				(keyboard_pop)
				(delete_window)
				(delete_buffer over_buf)
				(set_buffer under_buf)
				(attach_buffer under_buf)
            (if (== domerge 1)
                  (insert mergchr)
            )
			)
		)
 	)
)
