/*
   ASAP - Another System Analysis Product
   (c) Copyright 1989 - 1991, The Leylan Factor

   distribute freely with this header intact

   compile : clipper <file> /m/n/w
*/

#include "box.ch"
#include "inkey.ch"
#include "setcurs.ch"

#include "asap.ch"

#define K_EXIT  K_ESC


FUNCTION MAIN ( nElapMax )
   LOCAL nShell, nCnt
   LOCAL xCursor, xColor

   LOCAL cAsap := REPL( "ASAP - Another System Analysis Product... " + ;
                        "Testing In Progress... DO NOT DISTURB... ", 2 )

   /* set dos error code */
   ERRORLEVEL( 1 )

   /* set maximum elapsed time */
   nElapMax := IF( PCOUNT() == 1, ABS( VAL( nElapMax ) ), 0 )

   /* set environment */
   xCursor := SETCURSOR( SC_NONE )
   xColor := SETCOLOR( BRIGHT( CO_WHITE ) )

   /* start the timer */
   Timer( SECONDS() )

   /* define things */
   AsapNew(  0,  0,  2, 79, BRIGHT( CO_CYAN ), " ASAP ", B_SINGLE, cAsap )
   RealNew(  4,  0,  2, 26, BRIGHT( CO_GREEN ), " Real Time " )
   ElapNew(  7,  0,  2, 26, BRIGHT( CO_GREEN ), " Elapsed Time " )
   RamNew(  10,  0,  2, 32, BRIGHT( CO_BLUE ), " RAM Test " )
   DiskNew( 13,  0,  4, 32, CO_WHITE, " Disk Test " )
   SeriNew( 18,  0,  5, 32, BRIGHT( CO_MAGENTA ), " Serial Port Loop Back Test " )
   ParaNew( 18, 34,  5, 32, BRIGHT( CO_MAGENTA ), " Parallel Line Monitor Test " )
   StatNew(  4, 34, 13, 32, BRIGHT( CO_YELLOW ), " System Status " )
   TempNew(  4, 69, 19,  2, BRIGHT( CO_WHITE ),  4, 73 )

   CLS

   /* display things */
   AsapShow()
   RealShow()
   ElapShow()
   RamShow()
   DiskShow()
   SeriShow()
   ParaShow()
   StatShow()
   TempShow()

   nShell := 1
   WHILE nShell >= 1
  
      /* update things */
      AsapEvent()
      RealEvent()
      ElapEvent()
      RamEvent()
      DiskEvent()
      SeriEvent()
      ParaEvent()
      StatEvent()
      TempEvent()
  
      IF ( INKEY() == K_EXIT ) .OR. ;
         (( nElapMax > 0 ) .AND. ( Timer() > nElapMax ) )

         nShell := 0
      ENDIF
  
   ENDDO

   SETCOLOR( xColor )

   Bye(            0,            0, MAXROW() / 2, MAXCOL() / 2 )
   Bye(            0, MAXCOL() / 2, MAXROW() / 2, MAXCOL() )
   Bye( MAXROW() / 2, MAXCOL() / 2, MAXROW()    , MAXCOL() )
   Bye( MAXROW() / 2,            0, MAXROW()    , MAXCOL() / 2 )

   cAsap := REPL( "The Leylan Factor... ", 2 )
   AsapNew( 20,  0,  2, 20, BRIGHT( CO_CYAN ), " ASAP ", B_SINGLE, cAsap )
   AsapShow()

   FOR nCnt := 1 TO ( LEN( cAsap ) / 2 )
      AsapEvent()
      TONE( 25, 1 )
   NEXT

   SCROLL( 20,  0, 22, 20, 0 )

   /* credits */
   @ 18, 0 SAY "The Leylan Factor"
   @ 19, 0 SAY "98-626 Moanalua Loop, #201"
   @ 20, 0 SAY "Aiea, HI  96701-5172"
   @ 21, 0 SAY "Phone : (808) 487-2230"
   @ 23, 0

   /* reset environment */
   SETCURSOR( xCursor )

   /* reset dos error code */
   ERRORLEVEL(0)

   RETURN NIL


FUNCTION Timer( nSeconds )
   STATIC nStart := 0
   IF !( nSeconds == NIL )
      nStart := nSeconds
   ENDIF
   RETURN ( SECONDS() - nStart )


FUNCTION Sec2Hms( nSeconds )
   LOCAL nHour := INT( nSeconds / 3600 )
   LOCAL nMin  := INT( ( nSeconds - ( nHour * 3600 ) ) / 60)
   LOCAL nSec  := INT( ( nSeconds - ( nHour * 3600 ) - ( nMin * 60 )))
   RETURN STR( nHour, 2 ) + ":" + STR( nMin, 2 ) + ":" + STR( nSec, 2 )


FUNCTION AmPm( cTime )
   LOCAL nHour := VAL( LEFT( cTime, 2 ) )
   RETURN STR( ROUND( nHour % 12.1, 0 ), 2 ) + ;
               RIGHT( cTime, 6 ) + IF( nHour < 12, " AM", " PM" )


FUNCTION Randomize( nMax )
   LOCAL nCnt
   LOCAL nRnd := ( 0.123456789 + (SECONDS() / 1000) + (DAY( DATE() ) / 10 ))

   FOR nCnt := 1 TO nMax
      nRnd := Random( nRnd )
   NEXT
   RETURN nRnd


FUNCTION Random( nRnd )
   RETURN INT(((((nRnd * 31415821) + 1) % 1000000) / 1000000) * 32767)


STATIC FUNCTION Bye( nT, nL, nB, nR)
   LOCAL cScrn1, cScrn2, cScrn3, cScrn4

   /* calculate coordinates */
   LOCAL nH := nT + ((nB - nT) / 2)
   LOCAL nW := nL + ((nR - nL) / 2)

   LOCAL nCnt, nMax := ((nB - nT) / 2)

   /* collapse screen */
   FOR nCnt := 0 TO nMax

      cScrn1 :=  SAVESCREEN( nT, nL, nH, nW )
      cScrn2 :=  SAVESCREEN( nH, nW, nB, nR )
      cScrn3 :=  SAVESCREEN( nT, nW, nH, nR )
      cScrn4 :=  SAVESCREEN( nH, nL, nB, nW )

      IF nCnt == 0
         SCROLL( nT, nL, nB, nR, 0 )
      ENDIF

      RESTSCREEN( nT + 1, nL + 4, nH + 1, nW + 4, cScrn1 )
      RESTSCREEN( nH - 1, nW - 4, nB - 1, nR - 4, cScrn2 )
      RESTSCREEN( nT + 1, nW - 4, nH + 1, nR - 4, cScrn3 )
      RESTSCREEN( nH - 1, nL + 4, nB - 1, nW + 4, cScrn4 )

   NEXT

   RETURN NIL

