/* Program Name: ascan.c
* Author: Chuck Forsyth
* Copyright (c) 1988 by Honeywell ISD-TAC
*------------------------------------------------------------------------*
* Created: 8/25/1988 at 14:31
* Called From:
*
*
* Syntax : arayscan(aray_name,string)
* 
*  e.g., ARAYSCAN(ARAY_ONE,'Chuck Forsyth') would find the first occurence
*			of my name in the array called aray_one.
*			ARAYSCAN(ARAY_ONE,10) would find the first numeric element of the
*			array equal to 10.
*
*  This function will find a character string or a numeric value in an aray
*  ...anywhere within an element of the aray. The aray may consist of any
*  type elements, but the function as currently written will find only the
*  first occurence of the string or the numeric. The variable names should
*  make the coding self explanatory. Note! This function does not pay any
*  attention the EXACT setting and requires that the string passed be
*  matched exactly.
*
*  The string matching routine here is straight out of 'Software Tools'
*  by Kernighan and Plauger.
*
*
*........................................................................*
* Revision: 1.0 Last Revised: 8/25/1988 at 14:31
* Description: Original Creation.
*.........................................................................
* Revision: 1.1 Last Revised: 8/26/1988 at 12:05
* Description: Added ability to scan array for numeric values.
*.........................................................................
*---------------------------- ALL RIGHTS RESERVED -----------------------*/
  
#include "nandef.h"
#include "extend.h"
  
CLIPPER arayscan()
{
    register int j;
    int ret_val,element_type,type_of_search;
    double element_numeric,number;
    char *string,*aray_element;
    if(PCOUNT == 2 && ISARRAY(1) ) /* && ISCHAR(2)) */
    {
        type_of_search = _parinfo(2);
  
        switch( type_of_search )
        {
            case CHARACTER:
                string=_parc(2);
                break;
  
            case NUMERIC:
                number=_parnd(2);
                break;
        }
        ret_val = 0;
        for( j = 1 ;j <= _parinfa(1,0); ++j)
        {
            element_type = _parinfa(1,j);
            if(ret_val == 0 )
            {
                if( type_of_search == element_type  )
                {
                    switch( type_of_search )
                    {

                        case CHARACTER:
  
                            aray_element = _parc(1,j);
                            if(is_in(aray_element,string))
                            {
                                _retni(j);
                                return;
                            }
                            break;
                        case NUMERIC:
  
                            element_numeric = _parnd(1,j);
                            if( element_numeric == number )
                            {
                                _retni(j);
                                return;
                            }
                            break;
                        default:
  
                            break;
                    }  /* end of type_of_search switch */

                }  /* end of element type check */

            }  /* end of if ret_val == 0 */
            
        } /* end of for loop */
    }
    else
        _retni(FALSE);
  
    _retni(ret_val);
}
int is_in(string1,string2)
char *string1;
char *string2;
{
    register int i;
    int ret_val = FALSE;
  
    for( i = 0 ; *( string1 + i) != '\0' ; i++ )
  
    {
        if( amatch( string1, i, string2 ) )
        {
            return(TRUE);
        }
    }
    return(FALSE);
}
  
int amatch(lin,from,pat)
char *lin;
int from;
char *pat;
{
    register int i,j = 0;
    i = from;
    for( j = 0 ; *( pat + j) != '\0' ; j++ )
    {
        if( *(lin + i) != *(pat + j) )
            return(FALSE);
        i++;
    }
    return(i);
}
