/***
*  ArrSort.prg
*  Clipper 5.01
*  Example of ASORT() and various Code Blocks
*
*  Copyright (c) 1991 Nantucket Corp.  All rights reserved.
*       Written by Roy Corneloues on 06/10/91 at 23:15:44
*
*/

#include 'ArrSort.ch'

PROCEDURE Main
   LOCAL cLastColor := SETCOLOR( "W+/B" )

   // Numeric array demonstration
   NumArray()

   // Character array demonstration
   ChrArray()

   // Multi-dimensional array demonstration
   MultiArray()

   SETCOLOR( cLastColor )
   RETURN


STATIC PROCEDURE NUMARRAY
   LOCAL aNumeric := { 3,6,9,4,7,234,4567,23,56,235,412,243,5,4 }

   DispArray( aNumeric ,"Unsorted Numeric Array" )
   SortAndDisplay( aNumeric ,,"Ascending Numeric Array" )
   SortAndDisplay( aNumeric ,DescendBlock(),"Ascending Numeric Array" )
   RETURN


STATIC PROCEDURE CHRARRAY
   LOCAL aCharacter := { 'John','Mary','Fred','Roy','Clare','Geoff',;
      'Peter', 'Kate','Joe','Alvin','James' } 

   DispArray( aCharacter ,"Unsorted Character Array" )
   SortAndDisplay( aCharacter,, "Ascending Character Array" )

   SortAndDisplay( aCharacter, DescendBlock(),;
      "Descending Character Array" )

   SortAndDisplay( aCharacter, RightAscendBlock(),;
      "Character Array Ascending On Right Most Character" )

   SortAndDisplay( aCharacter, RightDescendBlock(),;
      "Character Array Descending On Right Most Character" )

   SortAndDisplay( aCharacter, SubStrAscendBlock(),;
      "Character Array Sorted On Second Character" )
   RETURN


STATIC PROCEDURE MULTIARRAY
   LOCAL aMulti := {}

   // Fill array with necessary information
   AADD( aMulti, AgeDetails( 'John', "10/21/65" ) )
   AADD( aMulti, AgeDetails( 'Mary', "5/9/77" ) )
   AADD( aMulti, AgeDetails( 'Fred', "7/13/50" ) )
   AADD( aMulti, AgeDetails( 'Pete', "1/1/58" ) )
   AADD( aMulti, AgeDetails( 'Jane', "9/25/72" ) )

   DispArray( aMulti ,"Unsorted Multi-Dim Array" )
   SortAndDisplay( aMulti, MultiAscendBlock(1), "Multi-Dim Array Sorted On First Dim" ) 
   SortAndDisplay( aMulti, MultiAscendBlock(2), "Multi-Dim Array Sorted On Second Dim" ) 
   SortAndDisplay( aMulti, MultiAscendBlock(3), "Multi-Dim Array Sorted On Third Dim" ) 
   RETURN


STATIC PROCEDURE SortAndDisplay( aArray, bBlock, cHeading )
   ASORT( aArray,,, bBlock )
   DispArray( aArray, cHeading )
   RETURN


STATIC PROCEDURE DISPARRAY( aArray ,cMessage )
   LOCAL I
   LOCAL J

   CLS
   ? PADC( cMessage, 80 )
   ?

   FOR I := 1 TO LEN( aArray )
      IF VALTYPE( aArray[I] ) == 'A'
         ? SPACE(10)
         FOR J := 1 TO LEN( aArray[I] )
            ?? aArray[I, J], SPACE( 2 )
         NEXT	// J
      ELSE
         ? SPACE(10), aArray[I]
      ENDIF

      IF I/20 == INT(I/20)
         ?
         WAIT
         CLS
      ENDIF
   NEXT	// I

   ?
   WAIT
   RETURN


STATIC FUNCTION AGEDETAILS( cName, cDateOfBirth )
   LOCAL aDetails[DETAIL_LENGTH]

   aDetails[DETAIL_NAME] := cName
   aDetails[DETAIL_DOB] := CTOD( cDateOfBirth )
   aDetails[DETAIL_AGE] := ( YEAR(DATE()) - YEAR(aDetails[DETAIL_DOB]) )
   RETURN (aDetails)
