; File......: ITOB.ASM
; Author....: Cyrus Patel
; Fido ID...: 2:243/7005.13
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
;
; This is an original work by me and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;
;
;  $DOC$
;  $FUNCNAME$
;    ITOB()
;  $CATEGORY$
;    Conversion
;  $ONELINER$
;    Convert a numeric integer to a 16 character bit string
;  $SYNTAX$
;    ITOB( <<nInterger>> ) -> <cBitString>
;  $ARGUMENTS$
;    <nInteger> is an unsigned integer numeric value to convert.
;    Decimal digits are truncated. <nInteger> may be in the range 0 to 65535.
;  $RETURNS$
;    ITOB() returns the binary value of <nInteger> as a 16 character string
;    of zeros and ones.
;  $DESCRIPTION$
;    ITOB() is a low-level conversion function that converts a 16 bit
;    unsigned integer into a character string formatted as the binary
;    value of that integer. The complimentary function of ITOB() is BTOI().
;    It is a fast equivalent of:
;    FUNCTION ITOB( nInteger )
;    LOCAL cBitString:=''
;    WHILE nInteger>0
;      cBitString:=CHR( ( nInteger%2 )+48 )+cBitString
;      nInteger:=INT( nInteger/2 )
;    END
;    RETURN( PADL( cBitString, 16, '0' ) )
;  $EXAMPLES$
;     ITOB( 129 )                   -> "0000000010000001"
;     ITOB( 65524 )                 -> "1111111111110100"
;     #Translate IsPosBright( nRow, nCol ) => ;
;                 ( SubStr( ITOB( Asc( Right( ;
;                 ; SaveScreen( nRow, nCol, nRow, nCol ),;
;                 ; 1 ) ) ), 13, 1 )=="1" )
;  $SEEALSO$
;     BTOI()
;  $END$
;

PUBLIC               ITOB
EXTRN                __parni:FAR
EXTRN                __retclen:FAR
DGROUP               GROUP  _DATA

_DATA   SEGMENT PUBLIC  'DATA'
; uses stack segment for temporary storage.
_DATA   ENDS

_CODE        SEGMENT 'CODE'
             ASSUME cs:_CODE, ds:DGROUP

ITOB         PROC    FAR

             mov     bx,1            ; Parameter #1
             push    bx              ; Set it up
             call    __parni         ; get integer

             mov     cx,16           ; number of loops
             mov     dl,'0'          ; reg argument is faster than immediate

shadd:       xor     dh,dh           ; Clear remainder
             shr     ax,1            ; Divide by 2
             adc     dh,dl           ; Add carry (remainder)
             push    dx              ; put in place
             inc     sp              ; compensate for dl
             loop    shadd           ; repeat 16 times

             mov     bx,sp           ; offset pointer
             mov     cx,16           ; setup length
             push    cx              ; length
             push    ss              ; segment
             push    bx              ; offset
             call    __retCLen       ; Return string via extend
             add     sp,6+16+2       ; clean up the stack

             ret                     ; return
ITOB         ENDP                    ; End of routine
_CODE        ENDS                    ; End of code segment
             END                     ; End of assembly
