; File......: BTOI.ASM
; Author....: Cyrus Patel
; Fido ID...: 2:243/7005.13
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
;
; This is an original work by the seven dwarfs and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;
;
;  $DOC$
;  $FUNCNAME$
;    BTOI()
;  $CATEGORY$
;    Conversion
;  $ONELINER$
;    Convert a 16 character bit string to a numeric integer
;  $SYNTAX$
;    BTOI( <<cBitString>> ) -> <nInteger>
;  $ARGUMENTS$
;    <cBitString> is a character string of zeros and ones.
;  $RETURNS$
;    <nInteger> is an unsigned integer numeric value in the range
;    0 to 65535.
;  $DESCRIPTION$
;    BTOI() is a low-level conversion function that converts a 16 character
;    (or shorter) bit string representing a binary value into it's integer
;    equivalent. The complimentary function of BTOI() is ITOB().
;    It is a fast equivalent of:
;    FUNCTION BTOI( cBitString )
;    LOCAL nInteger:=0 , nBit
;    FOR nBit = LEN( cBitString ) TO 1 STEP -1
;      nInteger+=( VAL( SUBSTR( cBitString, nBit, 1 ) )*( 2^( 8-nBit ) ) )
;    NEXT
;    RETURN( nInteger )
;  $EXAMPLES$
;     BTOI( "0000000010000001" )    -> 129
;     BTOI( "1111111111110100" )    -> 65524
;     #Translate MakePosBright( nRow, nCol ) => ;
;                 Transform( SaveScreen( nRow, nCol, nRow, nCol ),;
;                 ; "X"+Chr( BTOI( Stuff( ItoB( Asc( Right( ;
;                 ; SaveScreen( nRow, nCol, nRow, nCol ),;
;                 ; 1 ) ) ), 13, 1, "1" ) ) ) )
;  $SEEALSO$
;     ITOB()
;  $END$
;
; -------------------------------------------------------------------------
; BTOI - ASM function to convert a 16 digit bitstring to its decimal equiv.
;             By Cyrus Patel. Released to the public domain
;             Syntax:   nUnsigInteger := BTOI( cBitString )
; -------------------------------------------------------------------------

PUBLIC               BTOI
EXTRN                __retnL:FAR
EXTRN                __parc:FAR
DGROUP               GROUP  _DATA

_DATA   SEGMENT PUBLIC  'DATA'
; no data required
_DATA   ENDS

_CODE        SEGMENT 'CODE'
             ASSUME cs:_CODE, ds:DGROUP

BTOI         PROC    FAR

             push    bp              ; Save registers
             mov     bp,sp           ; Set new base pointer

             mov     ax,1            ; Parameter #1
             push    ax              ; set it up
             call    __ParC          ; get pointer

             mov     [bp-2],es       ; save these goodies
             push    di

             mov     bx,ax           ; Save beginning
             mov     di,bx           ; Point to the beginning
             mov     es,dx           ; Copy the segment number
             xor     ax,ax           ; Clear for total and scan value

;            cld                     ; clear direction flag (read forwards)
             mov     cx,-1           ; find terminating 0
             repnz   scasb           ; (quick way to get length: cx=-length-2)
             dec     di              ; Compensate for overread

             xor     cx,cx           ; Position counter / Multiply by
ShAdd:       xor     dx,dx           ; Clear the work area
             dec     di              ; Move up to the previous character
             mov     dl,es:[di]      ; Get the digit
             sub     dl,'0'          ; Make it 0 or 1
             shl     dx,cl           ; Move it to it's slot
             inc     cx              ; Increment the position counter
             or      ax,dx           ; Overlay the total with the digit
             cmp     di,bx           ; Was that the first character?
             jnz     shadd           ; No: loop for next digit

             pop     di
             pop     es              ; Restore players of the year

             xor     dx,dx           ; Clear the MSW
             push    dx              ; Set it up
             push    ax              ; Set up the integer
             call    __RetnL         ; Return as long unsigned int
             add     sp,4            ; Realign the stack

             pop     bp              ; restore base pointer
             ret                     ; return

BTOI         ENDP                    ; End of routine

_CODE        ENDS                    ; End of code segment
             END
