/*
    ARC_VIEW.PRG
    Author:  Eric J. Givler
    Written: 06/05/92
    Mods:    06/26/92 - Documented support for ARJ files.  Some 'mite' fixes.
                        Added PAK support by modifying ARCDIR.PRG to not
                        choke on 2nd char after chr(26) being > 12.
             09/24/93 - Changed message displayed if no file passed.
    Purpose: View .ARC, .ARJ, .DWC, .HYP, .LZH, .PAK, .ZIP, .ZOO.  
             Will support more later.  Secondfile option added as quick-kludge
             to show off multi-browse (I use this in Mega-Cat Diskette 
             Catalogger.)
*/

FUNCTION Main( filetoview, secondfile )
LOCAL lmissing := .F., ncursor := setcursor(0)

    if ! empty( filetoview ) .and. (lmissing := file(filetoview))
        FileView({ filetoview, secondfile })
    else
        ? 'ARC_VIEW 1.31, (c)1991-1994, Eric J. Givler, All Rights Reserved.'
        ? 'Supports ARC, ARJ, DWC, HYP, LZH, PAK, ZIP, ZOO files.'
        ? 'Syntax: ARC_VIEW <arcname> [<2ndfile>]'
        ? 'Error: ' + if(lMissing, '<File not found>', '<Argument Missing>')
    endif
    setcursor(ncursor)

RETURN NIL