* This is a sample piece of code which demonstrates how to make
* an ACHOICE() menu act exactly like a MENU TO menu. It involves
* creating a User Defined Function to simulate first letter
* selection and wrap.
*
* First I declare the array for the menu,  I then fill the array
* with my menu choices making sure that the first letter I want
* to select on is the first character in each array.
*
* The reason for this is because I find ACHOICE preferable to
* MENU TO for menus due to it's ability to access a UDF and do
* other things while remaining in the menu.  It is possible to
* write large applications in Clipper in which the whole program
* is executed from within an ACHOICE menu.  In this example I also
* illustrate a method of spreading out the menu choices.

PUBLIC array[10],logic[10]
afill(logic,.f.)
afill(array,space(5))
for b=1 to 5
  array[b*2] = ltrim(str(b*10000))
  logic[b*2] = .t.
next

* Now I set up the menu and put it in a loop for easy testing.
set color to w/n,n/w,,,w/n
clear
@ 5,32 to 17,48 double
do while LASTKEY() # 27
  answer = Achoice(6,35,16,45,array,logic,"arrayfunc")/2
  @ 23,38 say answer
enddo
return

* Here is the UDF that makes this happen.  First I get the parameters
* that Clipper passes.  The only one I care about is MODE, but I get
* the rest for good measure.  Then I capture the LASTKEY() for later
* use. Now on to the good stuff.

FUNCTION arrayfunc
  parameter mode, element, position
  last1 = lastkey()

  * If mode = 1, they hit the up arrow at the top of the list, I
  * keyboard a Ctrl-PgDn to put the cursor at the bottom of the list,
  * and if mode = 2, they hit down at the bottom of the list, I
  * keyboard a Ctrl-Home to put them at the top of the list.
  do case

    case mode = 1
       keyboard chr(30)
       return 2

    case mode = 2
       keyboard chr(29)
       return 2

    * If mode = 0, they hit a legal movement key, I return a 2 which says
    * keep going with the selection process.

    case mode = 0
       return 2

    * If mode = 3, they hit a key which is not internally processed then
    * I need to see if it is a key that I should act on. For Esc, 27, I
    * return a 0 which aborts achoice and returns a 0.  For Enter, 13, I
    * return a 1 which says to abort achoice and return the number of the
    * item that is currently selected.  If they hit a key which corresponds
    * to the first letter of one of the selections, tested with ascan()>0,
    * I keyboard an Enter so that the next time around the current
    * selection is made.  Last  I return a 3 which tells ACHOICE to
    * move the cursor to the first selection which coresponds to the
    * last key hit.

    case mode = 3
       if LAST1 = 27
          return 0
       elseif last1 = 13
          return 1
       elseif ascan(array,upper(chr(last1)))>0
          found1 = .T.
          keyboard chr(13)
       endif
       return 3

  endcase

  * If nothing worked then I return a 2 which says to continue
  * the selection process.

  return 2

*ENDFUNC arrayfunc
