/*
 * File......: ARRAYSAV.PRG
 * Original
 *   Author..: David Barrett
 * CIS ID....: 72037,105
 * Date......: $Date:   15 Aug 1991 23:06:06  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/savearr.prv  $
 *
 * This is an original work by David Barrett and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/savearr.prv  $
 * 
 * This Rev.?.? 19 Dec 1991 00:00:00   CHRIS
 * Christopher T. Shortt modified to save/restore to/from string
 *
 *    Rev 1.2   15 Aug 1991 23:06:06   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:52:54   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   07 Jun 1991 23:39:38   GLENN
 * Initial revision.
 *
 *
 */



MEMVAR lRet

#ifdef FT_TEST              // test program to demonstrate functions

 LOCAL  aArray := { {'Invoice 1', CTOD('04/15/91'), 1234.32, .T.},;
                {'Invoice 2', DATE(), 234.98, .F.},;
                {'Invoice 3', DATE() + 1, 0, .T.}  }, aSave
 LOCAL nErrorCode := 0
 LOCAL sArrayString:=[]
 sArrayString := FT_ARTOSTRING(aArray)
 DispArray(aArray)
 aSave := FT_STRTOARRAY(sArrayString)
 DispArray(aSave)
 RETURN

 FUNCTION DispArray(aTest)
   LOCAL nk
   FOR nk := 1 TO LEN(aTest)
     ? aTest[nk, 1]
     ?? '  '
     ?? DTOC(aTest[nk, 2])
     ?? '  '
     ?? STR(aTest[nk, 3])
     ?? '  '
     ?? IF(aTest[nk, 4], 'true', 'false')
   NEXT
 RETURN Nil
#endif




/*  $DOC$
 *  $FUNCNAME$
 *     FT_ARTOSTRING()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Save Clipper array to a character string.
 *  $SYNTAX$
 *     FT_ARTOSTRING( <aArray> ) -> cString
 *  $ARGUMENTS$
 *     <aArray> is any Clipper array except those containing
 *     compiled code blocks.
 *
 *     All arguments are required.
 *
 *  $RETURNS$
 *     cstring that represents array passed
 *  $DESCRIPTION$
 *     FT_ARTOSTRING() saves any Clipper array, except those
 *     containing compiled code blocks, to a charater string.
 *     The array can be restored from the string using
 *     FT_STRTOARRAY().
 *
 *  $EXAMPLES$
 *    aArray := { {'Invoice 1',CTOD('04/15/91'),1234.32,.T.},;
 *                {'Invoice 2',DATE(),234.98,.F.},;
 *                {'Invoice 3',DATE() + 1,0,.T.}  }
 *    nErrorCode := 0
 *    cCharString := ""
 *    cCharString := FT_ARTOSTRING(aArray)
 *    aSave := FT_STRTOARRAY('INVOICE.DAT')
 *
 *  $SEEALSO$
 *     FT_STRTOARRAY()
 *  $END$
 */


FUNCTION FT_ArToString(aArray)
LOCAL cArrayString:=""
_ftsavesub(aArray,@cArrayString)
RETURN cArrayString

STATIC FUNCTION _ftsaveAsub(aArray,cArrayString)
LOCAL xValType, nLen, cString,lRet := .T.
xValType := VALTYPE(aArray)
cArrayString += xValType
DO CASE
  CASE xValType = "A"
    nLen := LEN(aArray)
    cArrayString += L2BIN(nLen)
    AEVAL(aArray, {|aArrayElement| lRet := _ftsavesub(aArrayElement,@cArrayString) } )
  CASE xValType = "B"
    lRet := .F.
  CASE xValType = "C"
    nLen := LEN(aArray)
    cArrayString += L2BIN(nLen) + aArray
  CASE xValType = "D"
    nLen := 8
    cArrayString += L2BIN(nLen) + DTOC(aArray)
  CASE xValType = "L"
    nLen := 1
    cArrayString += L2BIN(nLen) + IF(aArray, "T", "F")
  CASE xValType = "N"
    cString := STR(aArray)
    nLen := LEN(cString)
    cArrayString += L2BIN(nLen) + cString
ENDCASE
RETURN lRet

/*  $DOC$
 *  $FUNCNAME$
 *     FT_STRTOARRAY()
 *  $CATEGORY$
 *     Array
 *  $ONELINER$
 *     Restore a Clipper array from a character string.
 *  $SYNTAX$
 *     FT_STRTOARRAY( <cStringName> ) -> aArray
 *  $ARGUMENTS$
 *     <cStringName> is a character string name.
 *
 *     All arguments are required.
 *  $RETURNS$
 *     Return an array variable.
 *  $DESCRIPTION$
 *     FT_STRTOARRAY() restores an array which was saved to
 *     a character string using FT_ARTOSTRING().
 *
 *  $EXAMPLES$
 *    aArray := { {'Invoice 1',CTOD('04/15/91'),1234.32,.T.},;
 *                {'Invoice 2',DATE(),234.98,.F.},;
 *                {'Invoice 3',DATE() + 1,0,.T.}  }
 *    nErrorCode := 0
 *    cCharString := ""
 *    FT_ARTOSTRING(aArray)
 *    aSave := FT_STRTOARRAY(cCharString)
 *
 *  $SEEALSO$
 *     FT_SAVEARR()
 *  $END$
 */

FUNCTION FT_StrToArray(pString)
LOCAL aArray
aArray := _ftrestsub(@pString)
RETURN aArray

STATIC FUNCTION _ftrestAsub(cString)
LOCAL xValType, nLen, nLenStr, xMemVar, cMemVar, nk
xValType := LEFT(cString,1)
cString := Right(cString,LEN(cString)-1)
nLenStr := LEFT(cString,4)
cString := Right(cString,LEN(cString)-4)
nLen := Bin2L(nLenStr)
DO CASE
  CASE xValType = "A"
    xMemVar := {}
    FOR nk := 1 TO nLen
      AADD(xMemVar, _ftrestsub(@cString))      // Recursive call
    NEXT
  CASE xValType = "C"
    xMemVar := LEFT(cString,nLen)
    cString := Right(cString,LEN(cString)-nLen)
  CASE xValType = "D"
    xMemVar = CTOD(LEFT(cString,8))
    cString := Right(cString,LEN(cString)-8)
  CASE xValType = "L"
    cMemVar := LEFT(cString,1)
    xMemVar := (cMemVar =  "T")
    cString := Right(cString,LEN(cString)-1)
  CASE xValType = "N"
    xMemVar := VAL(LEFT(cString,nLen))
    cString := Right(cString,LEN(cString)-nLen)
ENDCASE
RETURN xMemVar

