*:*********************************************************************
*:
*:        Program: APRFUN.PRG
*:
*:         System: APR Caculation
*:         Author: John Beckner
*:      Copyright (c) 1990, John Beckner
*:  Last modified: 07/07/90     19:11
*:
*:  Procs & Fncts: APR()
*:
*:      Documented 07/07/90 at 19:14                SNAP!  version 4.02d
*:*********************************************************************

FUNCTION apr
PARAMETER af,pmt,N
* af 1. Amount Financed.
* pmt 2. Payment amount.
* n 3. Number of payments.
PRIVATE ii,dv,I,X,ctr
ctr=0
STORE 5 TO ii,dv
DO WHILE .T.
   ii=ii+dv
   ctr=ctr+1
   IF ctr>500
      RETURN(999.99) &&assume error
   ENDIF
   I=ii/100.0000/12
   X=pmt*((1-(1+I)^(-N))/I)
   IF X=af
      EXIT
   ENDIF
   IF X<af
      IF dv=5
         dv=.5
         ii=ii-5
         LOOP
      ENDIF
      IF dv=.5
         dv=.01
         ii=ii-.5
         LOOP
      ENDIF
      ii=ii-dv
      EXIT
   ENDIF
ENDDO
RETURN (ii)

*: EOF: APRFUN.PRG
