************************************************************************
*     PROGRAM: AC_OPT.PRG                                              *
*     WRITTEN BY: KRAIG W. KRIST/T BEAR COMPUTER SERVICES.             *
*     DATE: APRIL 1993.                                                *
*     DESCRIPTION: ACHOICE FUNCTION PROCESSOR.                         *
************************************************************************
*             ---- MODIFICATION LOG ----
*  WHEN:
*   WHY:
************************************************************************
*
* CALLED BY: AUTOMATICALLY TO ACHOICE
*   PASSED FROM ACHOICE: MODE, CUR_ELEM, REL_POS, nWBOTTOM (PRIVATE)
*   RETURNS TO ACHOICE: SUBSCRIPT VALUE COORESPONDING TO SELECTED VALUE
*
* CALLS: SCROLBAR
*   PASSES TO SCROLBAR: CURRENT ELEMENT, ARRAY SIZE
*   RETURNED FROM SCROLBAR: NOTHING
*
************************************************************************
#INCLUDE "ACHOICE.CH"
#INCLUDE "INKEY.CH"
FUNCTION AC_OPT(MODE, CUR_ELEM, REL_POS)
************************************************************************
*   DEFINE VARIABLES
************************************************************************
  MEMVAR nCENTER, nARR_SIZE, nWBOTTOM, aScrollBar, nWTOP
  LOCAL GETLIST := {}
  LOCAL cOLDCOLOR := SPACE(19)
  LOCAL cRET_VAL, cLKEY
************************************************************************
*     ISSUE APPROPRIATE TOP OF WINDOW MESSAGE.                         *
************************************************************************
  IF CUR_ELEM > (REL_POS + 1)
    @ nWTOP,nCENTER SAY ' More ' + CHR(24) + ' '
  ELSE
    @ nWTOP,nCENTER SAY '  Top  '
  ENDIF
************************************************************************
*     ISSUE APPROPRIATE BOTTOM OF WINDOW MESSAGE.                      *
************************************************************************
  IF (CUR_ELEM - REL_POS + 1) <= nARR_SIZE - (nWBOTTOM - nWTOP - 2)
    @ nWBOTTOM,nCENTER SAY ' More ' + CHR(25) + ' '
  ELSE
    @ nWBOTTOM,nCENTER SAY ' Bottom '
  ENDIF
************************************************************************
*     UPDATE ScrollBar
************************************************************************
  ScrollBarUpdate(CUR_ELEM,nARR_SIZE)
  SETCOLOR(cOLDCOLOR)
************************************************************************
*     DETERMINE SELECTION.                                             *
************************************************************************
  DO CASE
    CASE MODE = AC_EXCEPT
      cLKEY := LASTKEY()
      DO CASE
        CASE cLKEY = K_ENTER
************************************************************************
*     RETURN PRESSED -- A PLAYER NAME WAS SELECTED.                    *
************************************************************************
          cRET_VAL := AC_SELECT
        CASE cLKEY = K_ESC
************************************************************************
*     ESCAPE PRESSED -- GET OUT.                                       *
************************************************************************
          cRET_VAL := AC_ABORT
        CASE UPPER(CHR(cLKEY)) $ 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
************************************************************************
*     MOVE HIGHLIGHT BAR TO THE NEXT PROMPT WHOSE 1ST CHARACTER MATCHES
* THE LAST KEYSTROKE ENTERED.
************************************************************************
          cRET_VAL := AC_GOTO
        OTHERWISE
************************************************************************
*     CONTINUE.
************************************************************************
          cRET_VAL := AC_CONT
      ENDCASE
    OTHERWISE
    cRET_VAL := AC_CONT
  ENDCASE
RETURN(cRET_VAL)
