*========================================
*  America the Beautiful
*
*  written for Clipper Summer 87
*  by Larry Bauder, Vancouver, B.C.
*
*  CIS 71320,2707
*
*  link file must include LIB clipper + extend + proclip
*
*========================================

para y,z

* "y" allows you to change the tempo.
* 40 is about right.

clear
@ 5,0 say "AMERICA THE BEAUTIFUL"
WAIT
clear
set cursor off

priv x,n,line[5],freq[10],tempo[4],m_hole,flop

public odd

odd  = .T.
flop = .F.

if type("y") = "U"
  x = 40
else
  x = val("&y")
endif

* set the limits of x -> low(x) = 8 high(x) = 90

x = if( x > 90 .or. x < 8, if( x > 90, 90, 8 ), x )

if type("z") = "U"
  z = .43
else
  y = z
  priv z
  z = val("&y")
endif

* set the limits of z -> low(z) = .15 high(z) = 15

z = if( z > 15 .or. z < .15, if( z > 15, 15, .15 ), z )

line[1]  = "O beautiful for spacious skies, For amber waves of grain,"
line[2]  = "For purple mountain majesties, Above the fruited plain."
line[3]  = "America! America! God shed His grace on thee,"
line[4]  = "And crown thy good with brotherhood,"
line[5]  = "From sea to shining sea."

* declare all the frequencies we want to play

freq[1]  = z * 293.66   &&  D
freq[2]  = z * 329.63   &&  E
freq[3]  = z * 349.23   &&  F
freq[4]  = z * 392.00   &&  G
freq[5]  = z * 440.00   &&  A
freq[6]  = z * 493.88   &&  B
freq[7]  = z * 523.25   &&  C
freq[8]  = z * 554.37   &&  C#
freq[9]  = z * 587.33   &&  D
freq[10] = z * 659.26   &&  E

* declare the tempos we need, relative to our "start-up" tempo

tempo[1] = x * 0.125    &&  (1/8)
tempo[2] = x * 0.25     &&  (1/4)
tempo[3] = x * 0.375    &&  (1/4) + (1/8)
tempo[4] = x * 0.75     &&  (1/2) + (1/4)

* write the verse to the screen

for n = 5 to 9          
  @ n,1 say line[n-4]
next

* save the screen to memory

m_hole = savescreen(5,1,9,70) 

* here's the stuff

play(5,1,1,1,1,4,2)        && O
play(5,3,1,3,4,4,3)        && beau
play(5,7,1,7,2,2,1)        && ti
play(5,9,1,9,3,2,2)        && ful
play(5,13,1,13,3,4,2)      && for
play(5,17,1,17,3,4,3)      && spa
play(5,20,1,20,5,1,1)      && cious
play(5,26,1,26,5,1,2)      && skies
play(5,33,1,33,3,2,2)      && For
play(5,37,1,37,2,3,2)      && am
play(5,39,1,39,3,4,2)      && ber
play(5,43,1,43,5,5,2)      && waves
play(5,49,1,49,2,6,2)      && of
play(5,52,1,52,5,4,4)      && grain
play(6,1,2,1,3,4,2)        && For
play(6,5,2,5,3,4,3)        && pur
play(6,8,2,8,3,2,1)        && ple
play(6,12,2,12,4,2,2)      && moun
play(6,16,2,16,4,4,2)      && tain
play(6,21,2,21,3,4,3)      && maj
play(6,24,2,24,2,1,1)      && es
play(6,26,2,26,4,1,2)      && ties
play(6,32,2,32,1,9,2)      && A
play(6,33,2,33,4,8,2)      && bove
play(6,38,2,38,3,9,2)      && the
play(6,42,2,42,5,10,2)     && fruit
play(6,47,2,47,2,5,2)      && ed
play(6,50,2,50,5,9,4)      && plain
flop = .T.
play(7,1,3,1,1,4,2)        && A
play(7,2,3,2,3,10,3)       && mer
play(7,5,3,5,1,10,1)       && i
play(7,6,3,6,2,9,2)        && ca
play(7,10,3,10,1,7,2)      && A
play(7,11,3,11,3,7,3)      && mer
play(7,14,3,14,1,6,1)      && i
play(7,15,3,15,2,6,2)      && ca
flop = .F.
play(7,19,3,19,3,7,2)      && God
play(7,23,3,23,4,9,2)      && shed
play(7,28,3,28,3,6,2)      && His
play(7,32,3,32,5,5,2)      && grace
play(7,38,3,38,2,4,2)      && on
play(7,41,3,41,4,7,4)      && thee
play(8,1,4,1,3,7,2)        && And
play(8,5,4,5,5,7,3)        && crown
play(8,11,4,11,3,5,1)      && thy
play(8,15,4,15,4,5,2)      && good
play(8,20,4,20,4,7,2)      && with
play(8,25,4,25,5,7,3)      && broth
play(8,30,4,30,2,4,1)      && er
play(8,32,4,32,4,4,2)      && hood
flop = .T.
play(9,1,5,1,4,4,2)        && From
play(9,6,5,6,3,5,2)        && sea
play(9,10,5,10,2,7,2)      && to
play(9,13,5,13,4,4,2)      && shin
play(9,17,5,17,3,9,2)      && ing
flop = .F.
play(9,21,5,21,3,7,4)      && sea

restscreen(5,1,9,70,m_hole) 

@ 12,1 say "Written by Katherine Lee Bates  & Samuel A. Ward"

inkey(1)

set cursor on

*-------------------------
func play
*-------------------------
para r_,c_,line_,start_,length_,freq_,tempo_

* set the screen to the original state
restscreen(5,1,9,70,m_hole)

* put our phrase on the screen in reverse video
set color to N/W
@ r_,c_ say upper(substr(line[line_],start_,length_))

* reset the color for everybody else
set color to W/N

if flop
  if odd
    @ 7,8 say chr(173)
    @ 7,17 say "!"
    odd = .F.
  else
    @ 7,17 say chr(173)
    @ 7,8  say "!"
    odd = .T.
  endif
endif

* play the note
sound(freq[freq_],tempo[tempo_])

