* function drawin - Draws a window with optional shading(black), color
*                   and custom boxing.  Box is filled with spaces
* Called as drawin(tlr,tlc,brr,brc,wcolor,shadow,boxnum,ttit,btit)
*        where:
*               tlr = top left row coordinate
*               tlc = top left columm coordinate
*               brr = bottom right row coordinate
*               brc = bottom right column coordinate
*               wcolor = box color (i.e. 'b/r' produces a red box
*                        with blue lines if lines are desired)
*               shadow = .T. if shadowing desired
*                        .F. if no shadow desired
*               boxnum = 0 for now lines in box
*                        1 for single line box
*                        2 for double line box
*                        3 for double top single side box
*                        4 for single top double side box
*                        5 for single top thick line
*               ttit   = Box Title (offset to left)
*               btit   = Box Instructions (bottom - centered)
*
*        Returns usable line lenght of window
*
function drawin
parameter tlr,tlc,brr,brc,wcolor,shadow,boxnum,ttit,btit
private stlr,stlc,sbrr,sbrc,holdc,boxdesc

if pcount() = 0
   tlr = 0
   tlc = 0
   brr = 24
   brc = 79
   color = 'n/w'
   shadow = .F.
   ttit =  ''
   btit =  ''
   boxnum = 0
endif

if brr > 24 .or. brc > 79 .or. tlr > brr .or. tlc > brc
   return(0)
endif

holdc = setcolor()
if shadow
   stlr = tlr + 1
   stlc = tlc + 1
   if brr < 24
      sbrr = brr + 1
   else
      sbrr = brr
   endif
   if brc < 79
      sbrc = brc + 1
   else
      sbrc = brc
   endif
   set color to n/n
   @ stlr, stlc clear to sbrr, sbrc
endif

set color to &wcolor

do case
   case boxnum = 1
     boxdesc = chr(218)+chr(196)+chr(191)+;
               chr(179)+chr(217)+chr(196)+;
               chr(192)+chr(179)+chr(32)

   case boxnum = 2
     boxdesc = chr(201)+chr(205)+chr(187)+;
               chr(186)+chr(188)+chr(205)+;
               chr(200)+chr(186)+chr(32)

   case boxnum = 3
     boxdesc = chr(213)+chr(205)+chr(184)+;
               chr(179)+chr(190)+chr(205)+;
               chr(212)+chr(179)+chr(32)

   case boxnum = 4
     boxdesc = chr(214)+chr(196)+chr(183)+;
               chr(186)+chr(189)+chr(196)+;
               chr(211)+chr(186)+chr(32)

   case boxnum = 5
     boxdesc = chr(223)+chr(223)+chr(223)+;
               chr(32)+chr(32)+chr(32)+;
               chr(32)+chr(32)+chr(32)

   otherwise
     boxdesc = space(9)

endcase

@ tlr, tlc, brr, brc box boxdesc

if .not. empty(ttit)
   if len(ttit) > brc-tlc-4
      @ tlr, tlc+2 say chr(91)+'Title too Large'+chr(93)
   else
      @ tlr, (tlc+(brc-tlc-2-len(ttit))/5) say chr(91)+ttit+chr(93)
   endif
endif

if .not. empty(btit)
   if len(btit) > brc-tlc-4
      @ brr, tlc+2 say chr(91)+'Text too Large'+chr(93)
   else
      @ brr, (tlc+(brc-tlc-2-len(btit))/2) say chr(91)+btit+chr(93)
   endif
endif

setcolor(holdc)

if boxnum = 0
   return(brc-tlc)
else
   return(brc-tlc-2)
endif

*endfunction drawin

*function msgpos(<expN,expT>)
*Returns padded message string so that <expT> message text
*  will display on screen starting  @ position (column) <expN>
*  Example:
*        set message to 24 center     && set message to line 24
*        msg1 = msgpos(15,'This is a message line')  && call function
*        @ 5, 6 prompt 'First Choice' message msg1   && do prompts
*         menu to message_variable                   && display menu
*
*       Message will appear on line 24 starting in column 15
*

function msgpos
parameter despos, mtext

if len(mtext) > (79 - despos)
   return('* * * Message too long for starting position * * *')
elseif despos > 79 .or. despos < 0
   return('* * * Message starting position out of range * * *')
else
   return(mtext+space(80-((despos+1)*2)-len(mtext)))
endif

*endfunction msgpos

*     Function Stubb(color1,color2)
*      Stubb message for non completed code
*         color1 = color string used clear full background
*         color2 = colors used in drawin
*         returns a .T. (for no good reason)
*
function stubb
parameters color1,color2,Topline
  private holds,holdc,result
  save screen to holds
  holdc = setcolor()
  setcolor(color1)
  clear
  result = drawin(9,17,15,60,color3,.T.,2,Topline,"Press any key to return")
  setcolor(color3)
  @ 12, 20 say 'Function is not available at this time'
  inkey(60)
  setcolor(holdc)
  restore screen from holds
  return(.T.)
*endfunction stubb
