*:*********************************************************************
*:
*: Procedure file: C:\DEVELOP\LIBRARY\ALDEMO.PRG
*:
*:         System: Replacement for Clipper's Alert Function
*:         Author: Bil Simser
*:      Copyright (c) 1992, Ewe-Nique Creations
*:  Last modified: 03/05/92     13:28
*:
*:  Procs & Fncts: DISPLAYALERT()
*:               : LISTASARRAY()
*:
*:          Calls: DISPLAYALERT()     (function  in ALDEMO.PRG)
*:
*:  This is a simple, yet pretty good looking replacement for Clipper's
*:  ALERT() function. I felt that it wasn't the greatest (as most of us
*:  know) and really shouldn't be relied upon that much anyway. So here's
*:  a replacement for it, or just a simple msg box that will return the
*:  number of the selection the user made.
*:  
*:  Feel free to modify it as you see fit and use it in your application.
*:  I seem to be building a repertoire of source code here of nifty
*:  black box functions, so perhaps a library is in the works. (Oh no! Not
*:  ANOTHER library!) If you do use it, please at least mention where you
*:  got the original concept from please...
*:  
*:  Anyways, the function is COMPLETELY compatible with Clipper's own
*:  Alert and expects that the string you pass will be split with a semi-colon
*:  for each line. Here are the parameters.
*:  
*:  DISPLAYALERT(cString, aOptions, cColors, nRow, cCol, nHeader)
*:  
*:  Where:
*:
*:  cString is the string to pass. Must be split with a ";" (just like ALERT())
*:  
*:  aOptions is any valid array of options. If not passed, will default to "Ok"
*:  
*:  cColors is the color string for the box. Will default to "N+/BG" if not there
*:  
*:  nRow is the starting row for the box
*:  
*:  nCol is the starting colomn for the box
*:  
*:  (NOTE: The box will be centered vertically and horizontally if not passed)
*:  
*:  cHeader is a string to display at the top of the screen. If not passed or
*:  the string is too big to fit, it will default to "Select"
*:  
*:  To bypass any options just pass NIL or leave it blank..
*:  
*:  Compile: CLIPPER ALDEMO /N /W /dTEST <-- To see the demo
*:  
*:  Link:    BLINKER FI ALDEMO, SHADOW
*:  
*:  Any modifications, ideas or if you just want to chat Clipper, give me a
*:  call! I write tax software for a living, but I can be a fun guy...
*:  
*:  Documented 03/05/92 at 13:30                SNAP!  version 5.00
*:*********************************************************************
#ifdef TEST
    CLS
    HITE_FIL := 25
    ST_ROW := 0
    OLDCOLOR := SETCOLOR()
    SET COLOR TO "bg/gr+"
    DO WHILE HITE_FIL > 0
       HITE_FIL := HITE_FIL - 1
       @ ST_ROW, 0 SAY REPLICATE("",79)
       ST_ROW := ST_ROW +1
    ENDDO
    SET COLOR TO OLDCOLOR
    AOPT := {"Good","Bad","Ugly"}
    CHOICE = DISPLAYALERT("This is a test;of the Display Alert Function", AOPT, , , ,"This is the Header!")
    DISPLAYALERT("You selected " + AOPT[choice])
    SET COLOR TO
    CLS
#endif

*!*********************************************************************
*!
*!       Function: DISPLAYALERT()
*!
*!      Called by: ALDEMO.PRG                        
*!
*!          Calls: LISTASARRAY()      (function  in ALDEMO.PRG)
*!               : DISPBEGIN()        (function  in ?)
*!               : PADC()             (function  in ?)
*!               : DISPEND()          (function  in ?)
*!
*!*********************************************************************
FUNCTION DISPLAYALERT(CSTRING, AOPTIONS, CCOLORS, NROW, NCOL, CHEADER)

/* Setup variables... */
LOCAL CSCREEN, ASTRING := {}
LOCAL NLENGTH := 0, NLINES, NWIDE, NTOP, NLEFT, NBOTT, NRIGHT, NWIDTH := 0
LOCAL COLDCOLOR := SETCOLOR()

/* Set Enviroment */
SET WRAP ON
SET CURSOR OFF

/* Parse the string into an array to determine the size of the box */
ASTRING := LISTASARRAY(CSTRING, ";")

/* Determine longest line in array */
FOR I = 1 TO LEN(ASTRING)
   IF LEN(ASTRING[i]) > NLENGTH
      NLENGTH := LEN(ASTRING[i])
   ENDIF
NEXT

/* Process options passed or set default to "Ok" if none */
IF(AOPTIONS != NIL, IF(VALTYPE(AOPTIONS) == "C", AOPTIONS := LISTASARRAY(AOPTIONS, ","),;
AOPTIONS := AOPTIONS), ;
   AOPTIONS := {"Ok"})

/* Determine the number of lines in the box and postion of box */
NLINES := LEN(ASTRING) + 4
NWIDE  := NLENGTH + 4
IF(NROW == NIL, NTOP   := INT((MAXROW() - NLINES) / 2), NTOP := NROW)
IF(NCOL == NIL, NLEFT  := INT((MAXCOL() - NWIDE) / 2), NLEFT := NCOL)
NBOTT  := NTOP + NLINES
NRIGHT := NLEFT + NWIDE

/* Create the buttons and position them in the box */
FOR I = 1 TO LEN(AOPTIONS)
   NWIDTH := NWIDTH + LEN(AOPTIONS[i])
NEXT
NFREESPACE := NWIDE - NWIDTH
NBETWEEN   := INT(NFREESPACE / (LEN(AOPTIONS) + 1))
NBPOS       := NLEFT + NBETWEEN

/* Begin the Display! */
DISPBEGIN()
CSCREEN := SAVESCREEN(NTOP, NLEFT, NBOTT + 1, NRIGHT + 2)
@ NTOP, NLEFT SAY "  " COLOR "N/W+"
@ NTOP, NLEFT + 3 SAY SPACE(NWIDE - 2) COLOR "W+/N"
@ NTOP, NLEFT + 4 SAY IF(EMPTY(CHEADER), "Select", IF(LEN(CHEADER) > (NWIDE - 3), "Select", CHEADER)) COLOR "W+/N"
IF(CCOLORS == NIL, SETCOLOR("N+/bg"), SETCOLOR(CCOLORS))
SCROLL(NTOP + 1, NLEFT, NBOTT, NRIGHT)

/* Display the text */
FOR I = 1 TO LEN(ASTRING)
   NTPOS := NLEFT + INT((NWIDE - LEN(ASTRING[i])) / 2)
   @ NTOP + 1 + I, NTPOS SAY ASTRING[i]
NEXT

/* Display the options */
FOR I = 1 TO LEN(AOPTIONS)
   @ NBOTT - 1, NBPOS PROMPT "" + PADC(AOPTIONS[i],LEN(AOPTIONS[i]) + 2) + ""
   @ NBOTT, NBPOS + 1 SAY REPLICATE("", (LEN(AOPTIONS[i]) + 4)) COLOR "N/bg"
   @ NBOTT - 1, NBPOS + LEN(AOPTIONS[i]) + 4 SAY "" COLOR "N/bg"
   NBPOS := NBPOS + NBETWEEN + LEN(AOPTIONS[i])
NEXT
SHADOW(NTOP + 1, NLEFT + 1, NBOTT, NRIGHT)
DISPEND()
MENU TO NOPT
SETCOLOR(COLDCOLOR)
RESTSCREEN( NTOP, NLEFT, NBOTT + 1, NRIGHT + 2, CSCREEN)

/* Re-set Enviroment */
SET WRAP OFF
SET CURSOR ON

RETURN NOPT

*!*********************************************************************
*!
*!       Function: LISTASARRAY()
*!
*!      Called by: DISPLAYALERT()     (function  in ALDEMO.PRG)
*!
*!*********************************************************************
FUNCTION LISTASARRAY(CLIST, CDELIMITER )
LOCAL NPOS, ALIST := {}                           // Define an empty array

DO WHILE (NPOS := AT(CDELIMITER, CLIST)) != 0
   AADD(ALIST, SUBSTR(CLIST, 1, NPOS - 1))        // Add a new element
   CLIST := SUBSTR(CLIST, NPOS + 1)
ENDDO
AADD(ALIST, CLIST)                                // Add final element
RETURN ALIST                                      // Return the array
*: EOF: ALDEMO.PRG
