************************************************************************
* DEMO2 - Autographing                  5/1/91
* Peter M. Freese                       Pinnacle Publishing, Inc.
*
* Example program which allows you to to dynamically move and resize a
* graph.  This basically shows off the autographing function and gives
* you a good feel for what it can do.  Experiment!  Try modifying the
* DEMO.DBF data to see how the data affects the graph and scaling.
*
* Note that most of this code is just processing the different
* keystrokes, and that all the graphing is still taken care of with a
* single function call.
************************************************************************

#include "inkey.ch"
local data := {}, xlabels := {}
// patterns and colors for 2 groups
local attributes := { {6,9}, {3,12} }   // icons and colors
local redraw := .T.                     // force initial display
local x := 675                          // initial graph coords
local y := 500
local w := 1150                         // initial graph size
local h := 800
local v

use demo

// store data in arrays
DBEVAL( {|| AADD(data,{score1,score2}),AADD(xlabels,name) })

sethires(0)                             // switch to graphics modes

do while .T.
  if redraw
    clrscreen()
    // draw graph centered at x,y
    AutoLineGraph(data,w,h,x-w/2,y-h/2,attributes)
    AutoLabel(xlabels)
  end
  k := inkey(0)                         // wait for a keypress
  redraw := .T.                         // assume we'll be redrawing
  do case
  // now modify the origin or the size, based on what key was pressed
  case k = K_ESC
    exit                                // if ESC pressed, time to leave
  case k = K_LEFT
    x -= 50                             // move 50 left
  case k = K_RIGHT
    x += 50                             // move 50 right
  case k = K_UP
    y += 50                             // move 50 up
  case k = K_DOWN
    y -= 50                             // move 50 down
  case k = K_CTRL_LEFT
    w := max(w-50,50)                   // decrease width by 50
  case k = K_CTRL_RIGHT
    w += 50                             // increase width by 50
  case k = K_PGDN
    h := max(h-50,50)                   // decrease height by 50
  case k = K_PGUP
    h += 50                             // increase height by 50
  otherwise
    // if no valid key was pressed, we don't need to redraw the graph
    redraw := .F.
  end
end
settext()                               // return to text mode

