************************************************************************
* DEMO1 - Autographing                  5/1/91
* Peter M. Freese                       Pinnacle Publishing, Inc.
*
* Example of AutoGraph functions showing various calls.  If we wanted to
* override any of the parameters, all we have to do is add them to the
* function call.
*
* Link instructions: (for EGA/VGA only)
* RTLINK FI demo1,agraph,dgevga,nulexvga li dge
************************************************************************

local data := {}, xlabels := {}
use demo
// store numeric fields to data array and labels to xlabels array
DBEVAL( { || AADD(data, {score1,score2,score3}), AADD(xlabels,name) })

sethires(0)

// First some Clustered Bar graphs...

clrscreen()                             // Clear the screen
AutoCBarGraph(data)                     // display the graph
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
AutoCBarGraph(data,800,300)             // specify width and height
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
// specify patterns and colors
AutoCBarGraph(data,,,,,{{4,12},{5,13},{6,14}})
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
AutoCBarGraph(data,,,,,,60,80)          // specify range
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

// Now some line graphs...

clrscreen()                             // Clear the screen
AutoLineGraph(data)                     // display the graph
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
AutoLineGraph(data,800,300)             // specify width and height
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
// specify icons and colors
AutoLineGraph(data,,,,,{{4,12},{5,13},{6,14}})
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

clrscreen()                             // Clear the screen
AutoLineGraph(data,,,,,,60,80)          // specify range
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

data[5,1] := nil                        // set all the data points
data[5,2] := nil                        // at 5 to nil to demonstrate
data[5,3] := nil                        // missing data
clrscreen()                             // Clear the screen
AutoLineGraph(data)                     // display the graph
AutoLabel(xlabels)                      // display axes and labels
inkey(0)                                // wait for a keypress

settext()                               // return to text mode

