***************************************************************************
* AELASTD.PRG - Functions for # days in month, last day of month & first 
*                day of month
*
* Written By  - Milton F. Shaw Jr.
*               (c) Copyright 1992, Auto Exec Inc., ALL RIGHTS RESERVED
***************************************************************************
*
* Released to Public Domain by - Auto Exec BBS (508) 833-0508
*
* Compile:  CLIPPER AELASTD /N
*
************************** Returns # of Days in a Month *******************
FUNCTION MONTHDAYS(ae_date)
LOCAL last_day,month_no,num_days

IF ae_date=NIL
   ae_date:=date()
ELSEIF VALTYPE(ae_date)!='D' .OR. EMPTY(ae_date)
   RETURN(0)
ENDIF

month_no:=MONTH(ae_date)

num_days:=31

DO CASE
        CASE month_no=4 .OR. month_no=6 .OR. month_no=9 .OR. month_no=11
             num_days:=30
        CASE month_no=2
             IF YEAR(ae_date) % 4 = 0 .AND. YEAR(ae_date) % 100!=0
                num_days:=29
             ELSEIF YEAR(ae_date) % 100 = 0 .AND. YEAR(ae_date) % 400 =0
                num_days:=29
             ELSE
                num_days:=28
             ENDIF
ENDCASE
RETURN(num_days)


*************************** Returns First Day of Month ******************
FUNCTION FIRST_DAY(ae_date)
IF ae_date=NIL
   ae_date:=date()
ELSEIF VALTYPE(ae_date)!='D'
   RETURN CTOD("")
ENDIF
RETURN ae_date-(DAY(ae_date)-1)


*************************** Returns Last Day of Month ********************
FUNCTION LAST_DAY(ae_date)
IF ae_date=NIL
   ae_date:=date()
ELSEIF VALTYPE(ae_date)!='D'
   RETURN CTOD("")
ENDIF
RETURN ae_date+(MONTHDAYS(ae_date)-DAY(ae_date))


********************** Returns Character Last Day of Month ****************
FUNCTION LAST_DAYC(ae_date)
IF ae_date=NIL
   ae_date=date()
ELSEIF VALTYPE(ae_date)!='D'
   RETURN CTOD("")
ENDIF
RETURN CDOW(ae_date+(MONTHDAYS(ae_date)-DAY(ae_date)))

********************* Returns Character First Day of Month ******************
FUNCTION FIRST_DAYC(ae_date)
IF ae_date=NIL
   ae_date:=date()
ELSEIF VALTYPE(ae_date)!='D'
   RETURN CTOD("")
ENDIF
RETURN CDOW(ae_date-(DAY(ae_date)-1))






   
