/*                        Auto Exec BBS
                         (508) 833-0508
                        1200/2400/9600 HST
                   8-N-1, 3 Nodes, PcBoard 14/E3
*/
/*-----------------------------------------------------------------------*/
/* AECLIP1.C  - Clipper Functions                                        */
/* Author: Milton F. Shaw Jr.                                            */
/* Copyright: Auto Exec Inc., (c) 1989, ALL RIGHTS RESERVED              */
/* Revision: Rev 1., May 9, 1989                                         */
/* Editor - QuickC                                                       */
/* Compiler - MSC 5.1                                                    */
/* Supporting BBS - Auto Exec BBS (508) 833-0508, 8-N-1, 1200/2400/9600  */
/*-----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------*/
/* compiling Batch File: for clipper program <clip prg>                  */
/*  make obj - cl/c /AL /F 0x4000 /Gs /Zl /Oalt /FPa aeclip1.c           */
/*  link /NOE /STACK:0x4000 <clip prg>,,,clipper+extend+aeclip1          */
/*  tlink <clip prg>,,,clipper+extend+aeclip1                            */
/*  plink86 fi <clip prg> lib clipper,extend,aeclip1                     */
/*-----------------------------------------------------------------------*/
/*                            Clipper Functions                          */
/*-----------------------------------------------------------------------*/
/*      Vmode()          - Determine 40/80 Mono/Color                    */
/*      ReBoot()         - Reboot the machine with soft boot             */
/*      NumFlop()        - Ascii value of Last Drive on Machine          */
/*      CurDrv()         - Ascii value of Drive currently logged on      */
/*      SetDrv()         - Change Drives - Pass # of Drive ,ie, 1,2,3    */
/*      MkDir()          - Make Directory                                */
/*      RmDir()          - Remove Directory                              */
/*      ChDir()          - Change Directories                            */
/*      RenDir()         - Rename Directory must give full pathnames     */
/*      InsMem()         - Amount of Machine Memory installed            */
/*      NumSer()         - Number of Serial Ports                        */
/*      NumPrt()         - Number of Printer Parallel Ports              */
/*      MathCo()         - Logic for Math Co-processor installed, on true*/
/*      NumOn()          - Logic state of NumLock - if on - true         */
/*      CapsOn()         - Logic state of CapsLock - if on - true        */
/*      InsOn()          - Logic state of Ins Key  - if on - true        */
/*-----------------------------------------------------------------------*/
/* Functions that return values to Clipper from 'C' are:                 */
/*  Type                                        Function                 */
/*  -------------                               -------------            */
/*  Character                                   _retc(char*)             */
/*  Date                                        _retds(char*)            */
/*  Logical                                     _retl(int)               */
/*  Integer                                     _retni(int)              */
/*  Long                                        _retnl(long)             */
/*  Double                                      _retnd(double)           */
/*  String                                      _retclen(char*,int)      */
/*  Void - No Return Value                      _ret()                   */
/*************************************************************************/
#include "ctype.h"
#include "stdlib.h"
#include "bios.h"
#include "dos.h"
#include "stdio.h"
#include "extend.h"
#include "direct.h"
#define EQLIST 0x410

/***************************************************************************/
/*  DOS Functions                                                          */
/***************************************************************************/

/***************************************************************************/
/* Clipper Function Vmode() - Color/Mono 40/80 Column                      */
/***************************************************************************/
/* Clipper Command - x=Vmode() returns 1,2 or 3                            */
/*                   1 = 40 col color, 2 = 80 col color, 3 = 80 col mono   */
/***************************************************************************/
CLIPPER Vmode()
{
	int far *farptr;
	unsigned int eq, data;
	farptr = (int far *) EQLIST;
	eq = *(farptr);
	data = (eq >> 4) & 3;
	_retni(data);
}


/***************************************************************************/
/*  Clipper Function - ReBoot() - Soft Boot the machine                    */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - ReBoot(), example to reboot is  ReBoot()             */
/***************************************************************************/
CLIPPER ReBoot()
{
	union REGS r;
	int86(0x19,&r,&r);
	_ret();
}

/***************************************************************************/
/*  Clipper Function - NumFlop() - Returns # of floppy drives installed    */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - NumFlop(), example x=NumFlop() returns number        */
/***************************************************************************/
CLIPPER NumFlop()
{
     unsigned elist,d_drives=0;
     elist=_bios_equiplist();
     if (elist & 0x0001)
     {
        d_drives=((elist & 0x00C0) >> 6)+1;
        _retni(d_drives);
     }
}

/***************************************************************************/
/* Clipper Function to Change Drives                                       */
/***************************************************************************/
/* Clipper Command - SetDrv() - Must Pass # of Drive SetDrv(1) for 'A'     */
/***************************************************************************/
CLIPPER SetDrv()
{
	unsigned drive,maxdrives;
	drive = _parni(1);
	_dos_setdrive(drive,&maxdrives);
	_dos_getdrive(&drive);
}


/***************************************************************************/
/* Clipper Function - Number of Serial Ports                               */
/*-------------------------------------------------------------------------*/
/* Clipper Command - NumSer(), example x=NumSer() returns number of ports  */
/***************************************************************************/
CLIPPER NumSer()
{
     unsigned elist, s_ports=0;
     elist=_bios_equiplist();
     s_ports=(elist &0x0E00) >> 9;
     _retni(s_ports);
}
/****************************************************************************/
/* Clipper Function - Number of Printer Parallel Ports                      */
/****************************************************************************/
/* Clipper Command - NumPrt(), example x=NumPrt() returns number of ports   */
/****************************************************************************/
CLIPPER NumPrt()
{
	int far *farptr;
	unsigned eq, data;
	farptr = (int far *) EQLIST;
	eq = *(farptr);
	data = eq >> 14;
	_retni(data);
}
/***************************************************************************/
/* Clipper Function - Math Coprocessor Installed                           */
/*-------------------------------------------------------------------------*/
/* Clipper Command - MathCo()   returns 1 if installed                     */
/***************************************************************************/
CLIPPER MathCo()
{
  unsigned elist,d_drives=0;
  elist=_bios_equiplist();
  if ((elist & 0x0002) >>1) _retl(1);
  else _retl(0);
}


/***************************************************************************/
/*  Clipper Function - InsMem() - Returns amount of Memory installed       */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - InsMem(), Example x=InsMem() return amount in K      */
/***************************************************************************/
CLIPPER InsMem()
{
    unsigned memsize;
    memsize=_bios_memsize();
    _retni(memsize);
}

/***************************************************************************/
/*  Clipper Function - CurDrv() - returns the currently logged drive       */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - CurDrv() - Exp - Drive=CHR(CurDrv) will return letter*/
/***************************************************************************/
CLIPPER CurDrv()
{
	union REGS r;
	int cur_d_rive;

	r.h.ah=25;
	int86(0x21,&r,&r);
	cur_d_rive=r.h.al;
	_retni(cur_d_rive+65);
}

/***************************************************************************/
/*  Clipper Function - CapsOn() - returns logic state of Caps Key          */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - CapsOn()                    true if On               */
/***************************************************************************/
CLIPPER CapsOn()
{
	union REGS r;

	r.h.ah=2;
	int86(0x16,&r,&r);
	if (r.h.al & 64) _retl(1);
	else _retl(0);
}


/***************************************************************************/
/*  Clipper Function - InsOn() - returns logic state of Ins Key          */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - InsOn()                    true if On               */
/***************************************************************************/
CLIPPER InsOn()
{
	union REGS r;

	r.h.ah=2;
	int86(0x16,&r,&r);
	if (r.h.al & 128) _retl(1);
	else _retl(0);
}


/***************************************************************************/
/*  Clipper Function - NumOn() - returns logic state of Num Key          */
/*-------------------------------------------------------------------------*/
/*  Clipper Command - NumOn()                    true if On               */
/***************************************************************************/
CLIPPER NumOn()
{
	union REGS r;

	r.h.ah=2;
	int86(0x16,&r,&r);
	if (r.h.al & 32) _retl(1);
	else _retl(0);
}


/****************************************************************************/
/* Clipper Function to Make Directory                                       */
/*--------------------------------------------------------------------------*/
/* Clipper Command - MkDir(<name of Directory to Make>)                     */
/****************************************************************************/
CLIPPER MkDir() 
{
     int mkdir(char *path);
     if(mkdir(_parc(1))) _retl(0);
     else _retl(1);
}

/*****************************************************************************/
/* Clipper Function to Change Directory                                      */
/*---------------------------------------------------------------------------*/
/* Clipper Command ChDir(<directory name to change to>)                      */
/*****************************************************************************/
CLIPPER ChDir()
{
     int chdir(char *path);
     if(chdir(_parc(1))) _retl(0);
     else _retl(1);
}

/******************************************************************************/
/* Clipper Function to Remove Directory                                       */
/*----------------------------------------------------------------------------*/
/* Clipper Command - RmDir(<directory name>)                                  */
/******************************************************************************/
CLIPPER RmDir()
{
     int rmdir(char *path);
     if(rmdir(_parc(1))) _retl(0);
     else _retl(1);
}
/****************************************************************************/
/* Clipper Function to Rename Directory                                     */
/*--------------------------------------------------------------------------*/
/* Clipper Command RenDir(<old directory name>,<new directory name>)        */
/****************************************************************************/
CLIPPER RenDir()
{
  int rename(const char *oldname, const char *newname);
  if(rename(_parc(1),_parc(2))) _retl(0);
  else _retl(1);
}

