Rjust2.PRG
* Program ....: Rjust2.PRG  
* Author .....: Chuck Litzell  
* Date .......: February 1, 1988  
* Version ....: dBASE III PLUS, versions 1.0 and 1.1.  
* Notes ......: Walks through a database, right-justifying the  
*               strings in a field by inserting blanks between  
*               words.  Blanks at the left of the string are not  
*               expanded; so, left indents will be unaltered.  
*  
*               A string must be at least 75% full to be justified.  

*               You can change this rule by resetting the constant  
*               "threshold" below.  
*  
*               Rjust2 uses the same algorithm as Rjust1, but calls 
*                             Pos.BIN to find spaces faster.  
*  
*               Syntax:  
*  
*                     DO Rjust2 WITH <database>, <field>, <width>  
*  
*                        database := name of the database  
*                        field    := name of the field to justify  
*                        width    := width of justified strings  
*  
PARAMETERS dbffile, fieldname, width

SET TALK OFF 
LOAD Pos
 
* ---Constants for Pos.  
equal    = CHR(1)  
notequal = CHR(2)  
forward  = CHR(1)  
backward = CHR(2)  
stepone  = CHR(1)  
first    = CHR(1)  
ok       = CHR(1)
 
* ---Program constants.  
blank     = " "  
dirflag   = .T.  
threshold = .75
 
* ---Set verbose to .F. to suppress display while the program works.  
verbose   = .T.
 
USE &dbffile  
GO TOP  
DO WHILE .NOT. EOF()  
   string = &fieldname  
   IF LEN(TRIM(string)) < threshold * width  
      IF verbose  
         ? TRIM(string)  
      ENDIF  
      SKIP  
      LOOP  
   ENDIF
 
   * ---Toggle dirflag.  
   dirflag = IIF(dirflag, .F., .T.)  
   adjust =  IIF(dirflag, forward, backward)
 
   * ---Prepare string by removing spaces from the right.  Spaces on the  
   * ---left are removed, too, but they are remembered and put back  
   * ---after the rest of the string is justified.  
   indent = LEN(string) - LEN(LTRIM(string))
 
   * ---Remove blanks from both ends of string.
   string = TRIM(LTRIM(string))
 
   * ---Initialize Pos with the TRIMmed string. 
   strvar = "I" + string  
   CALL Pos WITH strvar
 
   * ---Count the number of spaces by continually asking  
   * ---Pos to find the next one, until it can't find another.  
   nblanks = 0  
   DO WHILE .T.  
      strvar = "X" + equal + stepone + CHR(nblanks + 1) + forward + blank  
      CALL Pos WITH strvar  
      IF strvar <> ok   
         * ---No more blanks.  
         EXIT  
      ENDIF  
      nblanks = nblanks + 1  
   ENDDO
 
   * ---Number of spaces that need to be distributed.  
   ntoput = width - indent - LEN(string)
 
   * ---How many blanks to add at a shot?  
   atashot   = INT(ntoput / nblanks)  
   remainder = MOD(ntoput, nblanks)
 
   * ---Occur is the occurrence of a blank we're looking for.  
   * ---We'll start looking for the first.  
   occur = 1
 
   * ---Loop until all the spaces have been distributed.  
   DO WHILE ntoput > 0  
      * ---Send the current string to Pos.  
      strvar = "I" + string  
      CALL Pos WITH strvar
 
      * ---Find the space.  
      strvar = "X" + equal + stepone + CHR(occur) + adjust + blank  
      CALL Pos WITH strvar
 
      * ---The location of the space that was found.  
      where = ASC(SUBSTR(strvar, 2, 1))
 
      * ---Number of spaces to insert is atashot+1 if  
      * ---the remainder hasn't been exhausted.  
      nsp = atashot  
      IF remainder > 0  
         nsp = nsp + 1  
         remainder = remainder - 1   
      ENDIF
 
      * ---Insert the spaces.  
      string = STUFF(string, where, 0, SPACE(nsp))
 
      * ---Adjust the pointer to look past the last blank found  
      * ---and the ones inserted.  
      occur  = occur + nsp + 1  
      ntoput = ntoput - nsp  
   ENDDO
 
   * ---Put the string back in the field.  
   REPLACE &fieldname WITH SPACE(indent) + string  
   IF verbose  
      ? TRIM(&fieldname)  
   ENDIF  
   SKIP  
ENDDO
RELEASE MODULE POS
RETURN  
* EOP: Rjust2.PRG


