/*
    DEMO.PRG
    Copyright (c) Angelito Dizon.  All Rights Reserved.

    Demonstrates various features of ADread(), a mouseable and extensible
    replacement of READMODAL().

    In-line documentation was intentionally avoided in this program.  It
    was not designed to instruct, but to show the ADread features.  See
    the various instructional examples in Read.Doc for this kind of info.

    Compile and link with either of the accompanying batch files, CB.BAT and
    CR.BAT.
*/

#include "read.ch"
#include "inkey.ch"

//---------
func main()
field dbfname, shared, rlocked, date, comments
local xdbfname, xshared, xrlocked, xdate, xcomments
local aScn, nT := 17, nL := 10, nB := 23, nR := 69, getlist[0], aReadRetval
local aReadConfig := ADr_defaults()
local cColor := setcolor( if( iscolor(), "W+/BG, GR+/R,,, B/BG", ) )

use demo
cls
Xinstructions()

xdbfname = dbfname
xshared = shared
xrlocked = rlocked
xdate = date
xcomments = comments

aScn = ADbox( nT, nL, nB, nR )
@nT+0, nL+2 say "[-][?]";
            color if( iscolor(), "R/BG", "W+/N" )
@nT+1, nL+2 say "Database name         " adget xdbfname picture "@!"
@nT+2, nL+2 say "Opened in shared mode?" adget xshared
@nT+3, nL+2 say "Locked record number  " adget xrlocked 
@nT+4, nL+2 say "Date locked           " adget xdate
@nT+5, nL+2 say "Comments              " adget xcomments picture "@S33"
aReadConfig[R_KEYS] = { K_F2 }
aReadConfig[R_KHANDLER] = {|e,c,p,nth,nk| Xmessage(), .F.}
aReadConfig[R_LBUTTONS] = {;
                                {nT, nL+2, nT, nL+4 },;
                                {nT, nL+5, nT, nL+7 };
                          }
aReadConfig[R_LBHANDLER] = {|e,c,p,nth,mr,mc| Xlbhandler(e,c,p,nth,mr,mc)}
aReadConfig[R_KEYVALIDBLOCK] = {|cKey,nPos,nthGet,cBuffer| Xkeyvalid(cKey,nPos,nthGet,cBuffer)}
aReadRetval = ADread( getlist, aReadConfig )

if aReadRetval[2] != K_ESC .and. aReadRetval[2] != RX_ABORT;  // IF ADread() was not aborted
.and. ascan( aReadRetval[1], .T. ) > 0                        // .AND. at least one of the Gets was updated   
    dbfname = xdbfname                                        // THEN update the database
    shared = xshared
    rlocked = xrlocked
    date = xdate
    comments = xcomments
endif

? ""
? "Exit Code: ", aReadRetval[2]
? "  Updated?"
? "       Updated Values"
? "      "
? aReadRetval[1][1], dbfname
? aReadRetval[1][2], shared
? aReadRetval[1][3], rlocked
? aReadRetval[1][4], date
? aReadRetval[1][5], comments
setcolor( cColor )
return nil


//------------------------------
func Xlbhandler(e,c,p,nth,mr,mc)
local lRetval

ADm_rwait()

if nth = 1      // clicked [-]
    lRetval = ADr_save()
elseif nth = 2  // clicked [?]
    Xmessage()
    lRetval = .F.
endif

return lRetval


//----------------------------------------------
func Xkeyvalid( cKey, nPos, nthGet, cGetBuffer )
local lValid := .t.

if nthGet = 4   // will accept only October, November and December dates
    if nPos = 1
        if cKey != "1"
            lValid = .f.
        endif
    elseif nPos = 2
        if ( left( cGetBuffer, 1 ) + cKey ) > "12"
            lValid = .f.
        endif
    endif
endif

return lValid


//-------------
func Xmessage()
local cColor := if( iscolor(), "B/W", "W+/N" )
local nCursor := setcursor(0), nRow := row(),  nCol := col()
local aScn := ADbox( 10, 9, 12, 70, cColor )

if ADr_varid() == "XDBFNAME"
    @11,11 say "Enter the name of a database, without the .DBF extension" color cColor
elseif ADr_varid() == "XSHARED"
    @11,11 say "Enter a TRUE if it is opened in shared mode, else a FALSE" color cColor
elseif ADr_varid() == "XRLOCKED"
    @11,11 say "Enter the record number of the record to lock or check" color cColor
elseif ADr_varid() == "XDATE"
    @11,11 say "Enter the date you think the record may have been locked" color cColor
elseif ADr_varid() == "XCOMMENTS"
    @11,11 say "Enter anything you want. Press [TAB] to expand to memoedit" color cColor
endif

ADywait()
ADm_rwait()
ADrestscn( aScn )
setpos( nRow, nCol )
setcursor( nCursor )
return nil

//------------------
func Xinstructions()
ADbox( 0,0,16,79,,,.F. )
@0,30 say " ADread() Demonstration "
@1,2 say "Check these out: (There are more demo examples in READ.DOC.)"
@2,2 say "     Left-click any Get to jump to it."
@3,2 say "     'Comments' is a memo field.  Go to it then left-click it.  It will"
@4,2 say "      expand to a memoedit().  While in memoedit, left-click [-] to return"
@5,2 say "      to the Get, updating it with the memoedited text.  You may abort the"
@6,2 say "      the memoedit by clicking the right button."
@7,2 say "     You can also press [TAB] to expand the Get.  While in memoedit, [TAB]"
@8,2 say "      and [ESC] saves and aborts, respectively."
@9,2 say "     Press [F2] or left-click [?] to display a Get-sensitive message"
@10,2 say "     Left-click [-] to save the Gets and exit ADread()."
@11,2 say "     Click the right button or press [ESC] to abort ADread()."
@12,2 say "     The LEFT and RIGHT arrows behave like UP and DOWN if the cursor is at"
@13,2 say "      first or last position."
@14,2 say "     The 'Date Locked' Get processes every key press such that only '10',"
@15,2 say "      '11', and '12' are accepted in the first 2 positions."
return nil
