external setmode, scroll, fopen, fread, file, fclose
external devout, setcolor

#include "adl.ch"

* Code Blocks Structure 
* 
* This is the compiled code block structure. The Run block passed to PERFORM is 
* for each line in the form {nComand, CodeBlock, nLineNo} see "aCode" in code 
* below
*
* { 'Function name', {
*                     {13, {Param1Name, Param2Name, ...ParamnName}, nLineNo},
*                     {14, {
*                           {PrivateVar1Name,  Privatevar2CodeBlk},
*                           {PrivateVarnName,  PrivatevarnCodeBlk},
*                          }, nLineNo},
*
*                     {15, {
*                           {StaticVar1Name,  Staticvar2CodeBlk},
*                           {StaticVarnName,  StaticvarnCodeBlk},
*                          }, nLineNo},
*
*                     {12, {BeginEndCodeBlock1, ..BeginEndCodeBlockn}, nLineNo},
*
*                     {nComand, CodeBlock, nLineNo}
*                                                    1 - IF / DO CASE
*                                                    2 - ELSEIF / CASE
*                                                    4 - ELSE/OTHERWISE
*                                                    5 - ENDIF/ENDCASE
*                                                    6 - EXIT
*                                                    7 - LOOP
*                                                    8 - DO WHILE /WHILE/ FOR
*                                                    9 - RETURN
*                                                   10 - <Expression>
*                                                   11 - ENDDO/NEXT
*
*                    }}


FUNCTION main (file, p1,p2,p3,p4,p5)
   LOCAL cCode, hLogFile

   IF file(file)
      cCode = MEMOREAD (file)
      hLogFile = FCREATE('run.log')
      SetADL (ADL_LOGFILE, hLogFile)
      SetADL (ADL_TRACE, .T.)
      SetADL (ADL_PARSE, .T.)
      SetADL (ADL_RUNBLK, {|aCode| qout('Executing line '+str(aCode[3]))} )

      PERFORM (cCode, p1,p2,p3,p4,p5)

      IF ! empty( SetADL (ADL_ERROR) )
         QOUT (setADL(ADL_ERROR) )
      ENDIF

      FCLOSE (hLogFile)
   ELSE
      QOUT('File '+file+' not found')
   ENDIF

   RETURN NIL


FUNCTION WaitForKey()
   RETURN Inkey(0)







