* adirlst  9/12/90  7:56 pm
* use array and modulus to display a partial DOS directory
* Great example of automatic line counter using Modulus. 
* Credits: Tom Retting's book for the code. 
* Credits: Jerry Schuler consultant programmer "C" ,Clipper,Pascal,Hardware 
           for the Modulus explanation (213 835-6605) 
* Jim Allen finances (paid for the services)    
*  
clear
num_files=adir('*.prg')
declare dbf[num_files]
adir('*.prg',dbf)
asort(dbf)

* Explaination of what the code actually does
* dbf[i] is the -- array name + element number
* i is the array element-number counter
* num_files=adir('*.dbf')  returns the number of entries in the array.
*    Counts the files that match the  *.dbf  pattern. 
* dbf[num_files] names the array DBF and 
*    and specifies the number of elements num_files=adir('*.dbf')
* n%n = modulus  returns remainder of first n divided by second n
* space(12-len(dbf[i]))  insert a number of spaces 
*   befor filename (creates a right justified display)   
* asort(dbf)  sort the dbf array alphabetically on filename *.dbf   

col=2
* make a box
@ 0,col-2 to 23,col+13 double

* step thru the array one element  'i'=element at a time
for i=1 to num_files
   * display a line with automatic (%) line counter 
   @   ((i-1)%22) +1, col say space(12-len(dbf[i])) +dbf[i]
   * creates 5 columns accross
   * if line (or element) is 22 jump to next column
   if ((i-1)%22)+1=22
      col=col+16
      if col>79
         @ 0,0 say ""
         * this was just time to quit. Didn't try to display all of directory
         quit
      endif
      * create a new box at the new column position 
       @ 0,col-2 to 23,col+13 double
   endif
   *do while ((i-1)%22)+1=22 .and. inkey()<>27
      * just a pause at item 22 if needed
   *enddo
next
*
quit

text
This is one of the most creative ways I have seen of doing 
incrementing line counters. In my case it eliminated many lines of code. 
One thing I have not checked is how much extra memory is used by pulling in 
the Modulus (%) operator from the Clippers Library. 

The modlus operater returns the remainder of the first number divided by the
second (N1%N2). You have to remember back to the time before calculators 
to understand what is happening.  Back in grade school they taught 
LONG division which provided us with whole number remainders.


                 LONG DIVISION              MODERN CALCULATOR

                  __11___
                11) 123 | 2 remainder         123/11=11.18
                        |
                        |

     For the purpose of understanding Modulus:
     In the above example the remainder is whole number 2 not .18
     So 123 modlus 11 = 2.

examples:   1/9 = 0 with a remander of 1             -->   1 % 9 = 1

          103/9 = 11 with a remander of 4           -->  103 % 9 = 4
                  (11 * 9 = 99) + 4 = 103

          255/4 = 63 with a remander of 3            --> 255 % 4 = 3
                   (63 * 4 = 252) + 3 = 255

          87/23 = 3 with a remander of  18          -->   87 % 3 = 18
                   (3 * 23 = 69) + 18 = 87


The modlus operater will always produce a number between 0 and 1 less than the
modlus number.

            ?? % 9   will produce number ranging from  0 thur 8.
            ?? % 60  will produce number ranging from  0 thur 59.

for i=1 to num_files
   @ ((i-1)%9) +1, 10 say space(12-len(dbf[i])) +dbf[i]
next
*

In the above example i increments from 1 to num_files. The incrementing 
takes place at the bottom of the for loop, at the NEXT command when i the 
element number increments as a function of the for next loop.

"i" is never changed by the modlus(%) operator!  "i" is just used to 
generate another value (the line number) for the SAY command.

((i-1)%9)        Remainder            
If i was 4, 4%9 = 4
         5  5%9 = 5
         6  6%9 = 6
         7  7%9 = 7
         8  8%9 = 8
         9  9%9 = 0
         10 10%9 = 1
         11 11%9 = 2
         12 12%9 = 3
         13 13%9 = 4
         14 14%9 = 5
         15 15%9 = 6
         16 16%9 = 7
         17 17%9 = 8
         18 18%9 = 0
         19 19%9 = 1

So if i=14  in this statement...

@   ((i-1)%9) +1, 10 say 'Anything' 

   is really saying:
        @   ((14-1)%9) +1, 10 say....
        @   ((13)%9) +1, 10   say....   &&(13 / 9)   has a remander of 4)
        @   4+1,10            say.....
        @   5,10              say space(12-len(dbf[i])) +dbf[i]

**************END***************
endtext

