;ITOA
;replacement for 'C' library function
;basic routine from PC MAGZINE, modified for Clipper
;
        .model large,C
        .code
itoa    proc    USES DS SI, arg1:WORD , arg2:PTR, arg3:WORD , arg4:word
        lds     si,arg2
        mov     cx,arg4
        dec     cx
addspace:
        mov     byte ptr [si],'0'
        inc     si
        loop    addspace
nomore:
        mov     byte ptr [si],0
        mov     ax,arg1
        mov     cx,arg3

        push    si              ; and save that address.
        or      ax,ax           ; test sign of 16-bit value,
        pushf                   ; and save sign on stack.
        jns     itoa1           ; jump if value was positive.
        neg     ax              ; find absolute value.

itoa1:  cwd                     ; divide value by radix to extract
        div     cx              ; next digit for forming string.

        add     dl,'0'          ; convert remainder to ASCII digit
        cmp     dl,'9'          ; in case converting to hex ASCII,
        jle     itoa2           ; jump if in range 0-9,
        add     dl,'A'-'9'-1    ; correct digit if in range A-F.

itoa2:  dec     si              ; back up through buffer
        mov     [si],dl         ; store this character into string.
        or      ax,ax
        jnz     itoa1           ; no, convert another digit.

        popf                    ; was original value negative?
        jns     itoa3           ; no, jump

        dec     si              ; yes,store sign into output string.
        mov     byte ptr [si],'-'

itoa3:  pop     ax              ; calculate length of string
        sub     ax,si
        ret                     ; back to caller.

itoa    endp
        end

