

*  PROTECT.PRG
*  Brian Larkin
*  1/17/92

*     This illustrates one method to add password protection to
*     your application.  Essentially, you store a dummy password
*     in the application code. Then compile and link.  The first
*     time the application is run, it checks to see if the dummy
*     password is unchanged.  If it is unchanged, it asks the user
*     for a name and then, using Clipper's low-level DOS file
*     function, it physically writes over the dummy password in
*     the application EXE file on the disk with the new password.
*     To keep the password away from clever eyes, the program
*     encripts it before 'burning' it into the EXE file.

*     Each time the application is run, it check the password. If
*     it is not the original dummy, it asks the user for the
*     password, unencripts the application's password and compares
*     the two.

*     The encription algorhythm used here is simple.  All it does
*     is add 66 plus the position of each password character to
*     the value of the character and then converts the value to
*     its ASCII character.  Unencription works in reverse.

*     To test this code, be sure to name the file "PROTECT.PRG" or
*     else change the cInfile variable name.

*     The sequence "#~#" plus 27 "0"s is used here as the dummy
*     password.  This is what the 'burn in' procedure looks for.
*     Note that the exact sequence must be unique in your code.  If
*     it appeared twice, the 'burn in' wouldn't know the right one to
*     replace.


*  protect.prg
CLEAR
PRIVATE cInfile, cString, nAddNum, cEnc, cUnEnc, cOldPw, lRetVal, nCount
PRIVATE nTemp

cInfile = "PROTECT.EXE"       && name of the application
cString = SPACE(30)           && maximum length of password
nAddNum = 66                  && number to be added to encripted character
nCount = 1                    && character counter for blind input
cOldPw = Ret_pw()             && password in the application

*  if the original dummy password is still inplace, burn in a new one
IF (cOldPw=("#~#" + REPLICATE("0",27)))  && dummy password rephrased

   *  in practice, you would want to add a loop with counter here in
   *  to make the user verify the entry name

   @ 5,0 SAY "Enter your name" GET cString PICTURE "@A!"
   READ
   IF EMPTY("cString")
      QUIT
   ENDIF

   *  encript the password adding enough spaces to fill the 30 character
   *  string
   cEnc = LEFT(Encript(TRIM(cString),nAddNum)+SPACE(29),30) && encript

   *  burn in the new password
   Burn_pw(cInfile,cOldPw,cEnc, 30)                         && burn in

   @ 7,0 SAY "OK "+TRIM(cString)+" Remember your password"

ELSE

   *  in practice, you would want to add a loop with counter here in
   *  to make the user verify the entry name and give a chance to redo
   *  in case of entering a typo

   *  this will echo "*" as characters are entered
   @ 5,0 SAY "Enter your name"
   @ 5,17
   cString = ""
   DO WHILE .T.

      INKEY(0)  && process each key stroke with inkey() allows non visible entry

      IF (nCount = 1 .AND. EMPTY("cString"))
         QUIT
      ELSEIF (LASTKEY() = 27)
         QUIT
      ENDIF

      nTemp = Proc_key()  && integer value in range -1 to 1

      IF (nTemp = -2)      && we're finished entering
         EXIT
      ELSE
         IF (nTemp > 0)
            @ 5, 17 SAY REPLICATE("*",nCount)  && we're adding a character
         ELSE
            @ 5, 17 SAY REPLICATE("*",nCount)+" "  && deleting character
         ENDIF

         nCount = (nCount+nTemp)   && keep track of number of characters
      ENDIF

      IF (nCount = 30)  && we've hit the limit
         EXIT
      ENDIF
   ENDDO

   cUnEnc = UnEncript(Ret_pw(), nAddNum)  && now unencript app's password

   IF UPPER(TRIM(cString)) = UPPER(TRIM(cUnEnc))  && compare
      @ 7,0 SAY "OK "+cString
   ELSE
      @ 7,0 SAY "SORRY, "+TRIM(cString)+"! THIS JUST IS NOT YOUR DAY."
      TONE(250,5)
   ENDIF
ENDIF
RETURN

FUNCTION proc_key
*  process one keystroke
PRIVATE nRetVal
DO CASE
CASE LASTKEY() = 8                     && backspace
   cString = SUBSTR(cString, 1, LEN(cString)-1)
   nRetVal = -1
CASE LASTKEY() = 19                    && cursor left
   cString = SUBSTR(cString, 1, LEN(cString)-1)
   nRetVal = -1
CASE LASTKEY() = 13                    && enter/exit
   nRetVal = -2
CASE UPPER(CHR(LASTKEY())) $ " ABCDEFGHIJKLMNOPQRSTUVWXYZ"  && allowed keys
   cString = cString + UPPER(CHR(LASTKEY()))
   nRetVal = 1
OTHERWISE
   nRetVal = 0
ENDCASE
RETURN (nRetVal)

FUNCTION ret_pw
*  this is the dummy password that will be rewritten by this program
RETURN "#~#000000000000000000000000000"

FUNCTION burn_pw
*  the 'burn in function'
*  cInfile is the name of this application (i.e., the EXE file on disk)
*  cOldPw is the original password in Ret_pw()
*  cNewPw is the new password
*  nPwLen is the length of the password field - here it is 30
*  nFh is the handle of the file to be opened
*  cBuffer is a buffer for the Fread()
*  nStPos is a position in the file
*  nOs is a position in the buffer string
PARAMETERS cInfile,cOldPw,cNewPw,nPwLen
PRIVATE nOs,cBuffer,nStPos,nFh
nFh = Fopen(cInfile,2)    && open for read/write
IF !Ferror() = 0
   ? "OPEN error, DOS:",FERROR()
   QUIT
ENDIF
cBuffer = SPACE(4096)     && large buffer speeds the reads
nStPos = Fseek(nFh, 0, 0) && move DOS file pointer to top of file
DO WHILE .T.
   nNumRead = Fread(nFh, @cBuffer, 4096) && use nNumRead the ck for eof
   nOs = AT(cOldPw, cBuffer)             && position of old password
   IF nOs > 0
      Fseek(nFh, (nStPos+nOs)-1, 0)      && move the pointer into position
      Fwrite(nFh, cNewPw, nPwLen )       && write the new password
      FCLOSE(nFh)                        && close the file
      RETURN .T.
   ENDIF
   IF nNumRead < 4096                    && we're at the end
      FCLOSE( nFh)                       && close the file
      RETURN .F.
   ELSE
      nStPos = Fseek(nFh, -31, 1)        && move back incase we're on cusp
      cBuffer = SPACE(4096)              && reset buffer
   ENDIF
ENDDO

FUNCTION encript
*  encription procedure
*  returns an encripted string
*  takes ASC val of a character, adds nAddNum + I (position in string)
*     to it, then converts to ASCII CHR, and adds to cEncripted string
*  cString - password to be encripted
*  nAddNum - number to be added to ASC value of each character
PARAMETERS cString,nAddNum
PRIVATE cEncripted,I
cEncripted = ""
FOR I = 1 TO LEN(cString)
   cEncripted = (cEncripted + CHR( ASC( SUBSTR(cString,I,1))+nAddNum+I))
NEXT
RELEASE ALL EXCEPT cEncripted
RETURN (cEncripted)

FUNCTION unencript
*  decription procedure
*  returns an decripted string
*  cString - password to be decripted
*  nAddNum - number to be subracted from the ASC value of each character
*  nChar - used for handling spaces
PARAMETERS cString,nAddNum
PRIVATE cUnEncripted,I,nChar
cUnEncripted = ""
FOR I = 1 TO LEN(cString)
   nChar = ASC( SUBSTR(cString,I,1))
   IF (nChar=32)
      nChar = (nChar+nAddNum+I)
   ENDIF
   cUnEncripted = (cUnEncripted + CHR( nChar-nAddNum-I))
NEXT
RELEASE ALL EXCEPT cUnEncripted
RETURN (cUnEncripted)
