******************************************************************************
*** function: memvared
*** author  : Gary Blatt
*** purpose : to provide an easy,simple add routine to any database file
***           NOTE: MEMO FIELDS NOT SUPPORTED
*** syntax  : memvared(<expn1>,<expn2>)
***           where <expn1>=row to start display on
***                 <expn2>=number of fields to display on screen at a time
*** returns : 0 = all ok
***           1 = <expn2> is greater than total number of fields
***           2 = <expn1> + <expn2> is greater than 22
***           3 = memo fields exist in the database (NOT SUPPORTED)
***           4 = user aborted add of the record
******************************************************************************                    
function memvared
parameters trow,dispnum

private trow,dispnum,numflds,fname,ftype,flen,fdec,mvar,mpic,gname,rname
private fldptr,roffset,scount,mcorr,sname

*** get total number of fields in database
numflds=fcount()

*** do some error checking
if dispnum>numflds
   return  (1)
endif
if trow+dispnum>22
    return (2)
endif       

*** get field information into arrays
declare fname[numflds],ftype[numflds],flen[numflds],fdec[numflds],mvar[numflds]
declare mpic[numflds]
afields(fname,ftype,flen,fdec)
*** double-check for memo fields
for i = 1 to numflds
   if ftype[i]='M'
      return (3)
   endif
next
      
*** create memory variables & picture formats
for i = 1 to numflds
   mvar[i]='m_'+fname[i]
   do case
      case ftype[i]='C' .and. flen[i]<=66
         mpic[i]=replicate('X',flen[i])
      case ftype[i]='C' .and. flen[i]>66
         mpic[i]='@S66'   
      case ftype[i]='N' .and. fdec[i]=0
         mpic[i]=replicate('9',flen[i])
      case ftype[i]='N' .and. fdec[i]<>0
         mpic[i]=replicate('9',flen[i]-3)+'.'+replicate('9',fdec[i])
      case ftype[i]='D'
         mpic[i]='@D'
      case ftype[i]='L'
         mpic[i]='Y'      
   endcase            
next i

*** initialize loop variables
fldptr = 1
roffset=0
scount=1

*** start main loop
do while fldptr<=numflds
*** check for last display screen  
  if fldptr+dispnum>=numflds
      center(trow,'Adding Records to '+alias()+' Last Screen')   
   else
      center(trow,'Adding Records to '+alias()+' Screen # '+str(scount,1))
   endif
*** get data into memory variables   
   @trow+1,0 clear
   for i= fldptr to min(fldptr+(dispnum-1),numflds)
      gname=mvar[i]
      do case
         case ftype[i]='C'
            &gname=spac(flen[i])
         case ftype[i]='N'
            &gname=0
         case ftype[i]='D'
            &gname=ctod('  /  /  ')
         case ftype[i]='L'
            &gname=.f.      
      endcase      
      @i-roffset+trow,1 say pad(fname[i],12) get &gname picture mpic[i]
   next i
   read
*** check for this screen correct & if last screen to save record
   mcorr=' '
   if fldptr+dispnum>=numflds
      eprompt='Save This Record,Re-edit This Screen,Abort Add (S/R/A)'   
      pstr='SRA'
   else
      eprompt='Continue To Next Screen,Re-edit This Screen,Abort Add (C/R/A)'
      pstr='CRA'
   endif   
   @trow+dispnum+2,10 say eprompt get mcorr pict '!' valid valchk('mcorr',pstr)
   read
   do case
      case mcorr='R'
        loop
      case mcorr='A'
        return (4)
      case mcorr='C' .or. mcorr='S'    
         fldptr=fldptr+dispnum
         roffset=roffset+dispnum
         scount=scount+1
   endcase
enddo   
*** add record to database
appe blan
for i= 1 to numflds
   sname=mvar[i]
   rname=fname[i]
   replace &rname with &sname    
next
return (0)

function valchk
parameters chkvar,chkstr

return(if(&chkvar $ '&chkstr',.t.,.f.))

**** this function CENTER is compliments of Richard Low
**** Author of Rlib
* Function: CENTER
* Author..: Richard Low
* Syntax..: CENTER( [exp<N>,] exp<C> )
* Returns.: Column number to center <expC> on an 80 column monitor.
*           If <expN> is specified, it displays exp<C> centered on
*           row exp<N>.

FUNCTION CENTER
PARAMETERS p1, p2

DO CASE
   *-- if 1st parameter is character, no row number given
   CASE TYPE('p1') = 'C'
      *-- just return column to center, making sure its positive
      RETURN MAX( INT((80-LEN(p1))/2), 0 )

   *-- if 1st parm is numeric, and 2nd parm is character
   CASE TYPE('p1') = 'N' .AND. TYPE('p2') = 'C'
      *-- make sure it is in range 0 to 24
      IF p1 >= 0 .AND. p1 <= 24
         *-- say it on screen
         @ p1,(80-LEN(p2))/2 SAY p2
      ENDIF
      *-- and return value (make sure it is positive
      RETURN MAX( INT((80-LEN(p2))/2), 0 )

ENDCASE

*-- otherwise bad parms
RETURN (0)

