*** ACHOO3.prg  demo achoose() v.3  ***

** Here is a 'no-add' version of the new, simpler AChoose().  There is also an
** 'add' version, which allows the user to insert new items into the picklist.
** If you are interested, let me know, and I'll post it.
**
** The idea of Achoose is the user may find an item on a picklist by typing the
** first few characters.  For long lists, this beats the AChoice initial-letter-
** only seek.  (With the 'add' version, the user simply keeps on typing to
** insert a new item.)
**
** You pass Achoose window coords, a sorted array (of type Character, case
** insensitive), a parallel array of Logical, and optionally an intital current
** item number.  Achoose returns the selected item number ( 0 for ESC ).
**
** Improvements over previous versions:
**      . shorter
**      . does not call GET / READ or SET KEY
**      . can be called from a GetIt N_NEWFLD() state
**      . not case-sensitive
**
**                             26-April-90  Garrett M. Derner  [71511,142]

declare test[18], ltest[18]
afill( ltest, .T. )
test[1] = 'aaa'
test[2] = 'BAB'
test[3] = 'BBB'
test[4] = 'BBC'
test[5] = 'cde'
test[6] = 'Ced'
test[7] = 'fFf'
test[8] = 'gGG'
test[9] = 'GMD'
test[10] = 'hij'
test[11] = 'klm'
test[12] = 'Nop'
test[13] = 'Qrs'
test[14] = 'TSR'
test[15] = 'Ttt'
test[16] = 'tuv'
test[17] = 'wxy'
test[18] = 'Zzz'

clear

* call achoose with 'GMD' intitial item; dislay selected item.
choice = achoose( 5, 35, 15, 39, test, ltest, 9 )
* warning: a 'not found' msg is displayed on the line *above* the defined box

clear
if choice = 0
    @ 5, 36 say 'ESC pressed'
else
    @ 5, 36 say test[ choice ]
endif

********************************************************************************
FUNC AChoose
* Copyright (c) 1989, 1990 Garrett M. Derner            Compuserve 71511,142
*
* Purpose: Get name from picklist; seeks to each successive user letter input
* Syntax:  AChoose(t, l, b, r, name_array, parallel_array, [initial_index])
* Returns: index of array item selected
*
* Required to be present for AChoose:
*   FUNC AChooseFun [requires AChooseExcept(), AChoiceBoa(), AChoiceEoa()]
*   FUNC AScanSoft
*   FUNC Sim_Cursor
*
PARAMETERS t, l, b, r, array, larray, achoose_initial
PRIVATE achoice_initial, scan_string, scan_return, scan_start, choice, ;
  lines, lower, line, i, j
STORE achoose_initial to achoice_initial
STORE '' TO scan_string
STORE 1 TO scan_return, scan_start
STORE b - t - 1 TO lines      && Number of items displayed onscreen

* Unlike ACHOICE(), AChoose() draws a border onscreen; the numbers t, l, b, r
*  are its coordinates. The picklist is displayed immediately within this box,
*  at coordinates t + 1,  l + 1,  r - 1,  b - 1.
*  User keystrokes that match array elements are displayed on the top border.
@ t, l  TO  b, r  DOUBLE
Sim_cursor( t, l + 1 )

DO WHILE .T.

    * Call ACHOICE() with udf AChooseFun(), and an initial pointer position:
    choice = ACHOICE(t + 1,  l + 1,  b - 1,  r - 1, ;
                          array, larray,  "AChooseFun",  achoice_initial)

    * ACHOICE() continues until a keyboard exception occurs as a result of
    * user striking Esc, Enter, Backspace, left, or a text character.
    * AChooseFun() then calls AChooseExcept(), which manipulates 3 variables:
    *      scan_string       array search string  (partial name input)
    *      scan_start        begin search position (for faster search)
    *      scan_return       index of found name / request to AChoose()
    *
    * AChooseExcept() stores a number in scan_return equal to -2, -1, 0, or a
    * positive value equaling index of first string matching user keystrokes.

    DO CASE
       CASE scan_return = -1     && ENTER key struck (or ESC on initial name)
            EXIT

       CASE scan_return = 0      && Keystrokes toward name not found.
            @ t - 1, l say scan_string + ' not found'
            scan_string = left(scan_string, len(scan_string) - 1)
            @ t, l + 1 + len(scan_string) say ;
                if( len(scan_string) >= r - l - 1,  chr(187), chr(205) )

       OTHERWISE                  && Keystrokes toward name found
            * Prepare to call ACHOICE() again, with found initial current item:
            achoice_initial = scan_return

            * Display search string (user keystrokes) on top border line:
            @ t, l + 1  SAY scan_string
            sim_cursor(t, l + 1 + len(scan_string))
            @ t, l + 1 + len(scan_string) say ;
                if( len(scan_string) >= r - l - 1,  chr(187), chr(205) )

            * erase any 'not found' msg
            @ t - 1, l say space( len(scan_string) + 12 ) 

    ENDCASE
ENDDO
RETURN choice

********************************************************************************
FUNC AChooseFun && Process keystrokes for the ACHOICE() call in AChoose()
* Required to be present for AChooseFun:
*      FUNC AChooseExcept
*      FUNC AChoiceBoa
*      FUNC AChoiceEoa
PARAMETERS status, current_index    && Automatic parameters passed by ACHOICE()
PRIVATE request
*
stroke = LASTKEY()
*
DO CASE
   CASE status = 1                && Beginning-of-array
        request = AchoiceBoa()

   CASE status = 2                && End-of-array
        request = AchoiceEoa()

   CASE status = 3                && Key exception
        request = AChooseExcept(stroke, current_index)

   OTHERWISE
        request = 2               && Continue ACHOICE()
ENDCASE
RETURN request         && Request to ACHOICE()

********************************************************************************
FUNC AChooseExcept        && Process key exception; called by AChooseFun()
PARAMETERS action_key, current
PRIV n
* Scans AChoose() array 'array'
* Changes the AChoose() variables 'scan_string', 'scan_start,' & 'scan_return'
* Sometimes uses the AChoose() screen position parameters 't' & 'l'
DO CASE
  case action_key = 1       && home
    KEYBOARD CHR(31)      && simulate Ctrl-PgUp to go to first element
    return 2

  case action_key = 6       && end
    KEYBOARD CHR(30)      && simulate Ctrl-PgDn to go to last element
    return 2

  CASE action_key = 27     && esc struck
      * Esc struck from ACHOICE() ...exit AChoose()
      scan_return = -1   && Exit AChoose()
      RETURN 0      && first exit ACHOICE(), returning 0

  CASE action_key = 13     && enter struck
      * Enter struck from ACHOICE() ... AChoose() returns no. of selected item
      scan_return = -1   && Exit AChoose()
      RETURN 1         && first exit ACHOICE(), returning index of current item

  CASE action_key = 8 .or. action_key = 19      && Backspace or left struck
      * Trim search string:
      scan_string = ;
        IF(LEN(scan_string) = 0, '', LEFT(scan_string, LEN(scan_string) - 1))
      * Search array:
      for n = 1 to len(array)
            if lower(array[n]) = lower(scan_string)
                scan_return = n
                exit
            endif
      next
      if n > len(array)
            scan_return = 0
      endif
      RETURN 0

  CASE action_key < 32         && Do not accept control characters
      RETURN 2

  CASE LEN(scan_string) = LEN(array[1])  && Total match; do same as if Enter hit
      scan_return = -1   && Exit AChoose(), return index of current item;
      RETURN 1         && first exit ACHOICE(), returning index of current item

  OTHERWISE
      * Concatonate lowercase of key struck onto search string:
      scan_string = scan_string + CHR(action_key)

      * Search array:
      scan_start = IF(scan_return > 0, scan_return, scan_start)
      scan_start = IF(scan_start = 0, 1, scan_start)
*      for n = scan_start to len(array)     && reliable?
      for n = 1 to len(array)
            if lower(array[n]) = lower(scan_string)
                scan_return = n
                exit
            endif
      next
      if n > len(array)
            scan_return = 0
      endif
      RETURN 0
ENDCASE

********************************************************************************
FUNC AchoiceBoa      && Process Beginning-Of-Array:
@ t, l - 1  say [ ]
RETURN 2                     && continue ACHOICE()

********************************************************************************
FUNC AchoiceEoa      && Process End-Of-Array:
@ b, l - 1  say [ ]
RETURN 2                     && continue ACHOICE()

********************************************************************************
FUNC AScanSoft
* Search array of strings or numbers & find where value belongs.
* Elements of array must be in ascending order.
*
PARAMETERS array, value, start
i = IF(PCOUNT() = 3, start, 1)
DO WHILE .T.
    IF TYPE('array[i]') $ 'UL'               && Element undefined
        i = IF(TYPE('array[1]') = 'U', 0, i)
        EXIT
    ENDIF
    IF value <= array[i]                 && Insert position found
        EXIT
    ENDIF
    i = i + 1
ENDDO
RETURN i

********************************************************************************
func sim_cursor
parameters row, col

c_flash = '7+/0+'                              && flashing color, monochrome

prevcolor = setcolor(c_flash)
@ row, col  say chr(223)
setcolor (prevcolor)


