* Please excuse the terse "help".  This is a program I wrote to browse arrays
* and show other programmers how easy it is to use Tbrowse with arrays...
*
*                     John Wright

#include "INKEY.CH"

*!*****************************************************************************
*!
*!       Function: ABROWSE()
*!
*!          Calls: DISPSTRU()         (function  in ABROWSE.PRG)
*!               : EXT_NAME()         (function  in ABROWSE.PRG)
*!
*!*****************************************************************************
FUNCTION abrowse( cSkeleton )
LOCAL oBrowse, nArrPos := 1, aList, nKeypress, cKeyPress

CLEAR SCREEN
SETCOLOR( "N/W, W/N" )

cSkeleton  := IF( VALTYPE( cSkeleton ) <> "C", "*.*", cSkeleton )

* Fill the array with data
aList := DIRECTORY( cSkeleton )

IF LEN( aList ) < 1
   ? "No files found matching: "+cSkeleton
   RETURN .F.
ENDIF

* Setup the browse object for the array
oBrowse := TBROWSENEW( 4, 16, MAXROW()-6, 63 )

* Draw a box around the Tbrowse area
Dispbox( oBrowse:nTop-1, ;
   oBrowse:nLeft-1, ;
   oBrowse:nBottom+2, ;
   oBrowse:nRight+1 )

@ oBrowse:nBottom, oBrowse:nLeft-1 SAY ""
@ oBrowse:nBottom, oBrowse:nRight SAY "Ĵ"
@ oBrowse:nBottom+1, oBrowse:nLeft SAY SPREAD( " [Esc] = Exit", ;
   STR( LEN(aList), 6, 0 ) + " files ",;
   (oBrowse:nRight-oBrowse:nLeft)+1 )

oBrowse:headSep := ''
oBrowse:colSep  := '  '
oBrowse:footSep := ''

* Setup the columns
oBrowse:ADDCOLUMN( TBCOLUMNNEW( 'NAME', { || PAD(aList[ nArrPos, 1 ],12) } ) )
oBrowse:ADDCOLUMN( TBCOLUMNNEW( PADL('SIZE',9), ;
   { || STR( aList[ nArrPos, 2 ], 9, 0 ) } ) )
oBrowse:ADDCOLUMN( TBCOLUMNNEW( '  DATE', { || aList[ nArrPos, 3 ] } ) )
oBrowse:ADDCOLUMN( TBCOLUMNNEW( '  TIME', { || aList[ nArrPos, 4 ] } ) )

* Change the Tbrowse positioning routines for arrays instead of databases.
oBrowse:skipBlock :=  { | nMove | SkipArray( nMove, @nArrPos, LEN( aList ) ) }
oBrowse:goTopBlock := { || nArrPos := 1 }
oBrowse:goBottomBlock := { || nArrPos := LEN( aList ) }

SET CURSOR OFF

DO WHILE nKeypress != K_ESC
   
   DO WHILE ! ( oBrowse:STABILIZE() )
   ENDDO
   
   nKeypress := INKEY( 0 )
   cKeypress := UPPER( CHR( nKeyPress ) )

   DO CASE
   CASE nKeyPress == K_UP;             oBrowse:UP()
   CASE nKeyPress == K_DOWN;           oBrowse:DOWN()
   CASE nKeyPress == K_LEFT;           oBrowse:LEFT()
   CASE nKeyPress == K_RIGHT;          oBrowse:RIGHT()
   CASE nKeyPress == K_PGUP;           oBrowse:PAGEUP()
   CASE nKeyPress == K_PGDN;           oBrowse:PAGEDOWN()
   CASE nKeyPress == K_CTRL_PGUP;      oBrowse:GOTOP()
   CASE nKeyPress == K_CTRL_PGDN;      oBrowse:GOBOTTOM()
   CASE nKeyPress == K_HOME;           oBrowse:HOME()
   CASE nKeyPress == K_END;            oBrowse:END()
   CASE nKeyPress == K_CTRL_HOME;      oBrowse:PANHOME()
   CASE nKeyPress == K_CTRL_END;       oBrowse:PANEND()
   CASE nKeyPress == K_TAB;            oBrowse:PANRIGHT()
   CASE nKeyPress == K_SH_TAB;         oBrowse:PANLEFT()
      
   CASE nKeyPress == K_ENTER .AND. ".DBF" $ aList[ nArrPos, 1 ]
      DISPSTRU( aList[ nArrPos, 1 ], oBrowse:nTop+1 )
      
   CASE nKeyPress == K_F7       // file name
      ASORT( aList, , , {|x,y| X[1] < y[1] } )
      oBrowse:GOTOP()

   CASE nKeyPress == K_F8       // file extension & name
      ASORT( aList, , , {|x,y| EXT_NAME( X[1] ) < EXT_NAME( y[1] ) } )
      oBrowse:GOTOP()
      
   CASE nKeyPress == K_F9       // file size
      ASORT( aList, , , {|x,y| X[2] < y[2] } )
      oBrowse:GOTOP()
      
   CASE nKeyPress == K_F10      // file date
      ASORT( aList, , , {|x,y| X[3] < y[3] } )
      oBrowse:GOTOP()
      
   CASE nKeyPress >= 32 .AND. nKeyPress <= 126  // Jump to next match
      IF JumpArray( cKeyPress, @nArrPos, aList, 1 )
         IF oBrowse:rowPos > nArrPos
            oBrowse:rowPos := nArrPos
         ENDIF
         oBrowse:CONFIGURE()
      ENDIF
      
   ENDCASE
   
ENDDO

SET CURSOR ON

RETURN .T.


*!*****************************************************************************
*!
*!       Function: EXT_NAME()
*!
*!      Called by: ABROWSE()          (function  in ABROWSE.PRG)
*!
*!*****************************************************************************
STATIC FUNCTION Ext_Name( cFileName )
* 04/16/93 - Flip name and extension for sorting purposes
LOCAL nPeriod := AT(".",cFileName)
RETURN PAD( SUBSTR( cFileName, nPeriod, 4 ), 4 ) + SUBSTR( cFileName, 1, nPeriod-1 )


*!*****************************************************************************
*!
*!       Function: DISPSTRU()
*!
*!      Called by: ABROWSE()          (function  in ABROWSE.PRG)
*!
*!*****************************************************************************
FUNCTION DISPSTRU( cDbname, nTop, nBottom, cNewColor )
* 04/16/93 - Display the structure of a database
LOCAL cSaveScrn, cOldColor
LOCAL nKeypress, cKeypress, oBrowse, oColumn
LOCAL aList, nArrPos := 1, nRecords

* Fill the array with data
IF DBUSEAREA( , , cDbname, "viewstru" ) <> 0
   aList := DBSTRUCT( cDbname )
   nRecords := LASTREC()
   DBCLOSEAREA()
ELSE
   RETURN .F.
ENDIF

nTop      := IF( VALTYPE( nTop ) <> "N", 5, nTop )
nBottom   := IF( VALTYPE( nBottom ) <> "N", MAXROW()-4, nBottom )
cNewColor := IF( VALTYPE( cNewColor ) <> "C", "w/n,n/w", cNewColor )

cOldColor := SETCOLOR( cNewColor )

* Setup the browse object for the array
oBrowse := TBROWSENEW( nTop, 24, nBottom, 56 )

* Draw a box around the Tbrowse area
cSaveScrn := Savescreen( oBrowse:nTop-3, ;
   oBrowse:nLeft-1, ;
   oBrowse:nBottom+2, ;
   oBrowse:nRight+1 )
Dispbox( oBrowse:nTop-3, ;
   oBrowse:nLeft-1, ;
   oBrowse:nBottom+2, ;
   oBrowse:nRight+1 )

* Display the file name and number of records
@ oBrowse:nTop-2, oBrowse:nLeft SAY SPREAD( UPPER( cDbname ), ;
   "Records: "+LTRIM( STR( nRecords ) ), oBrowse:nRight-oBrowse:nLeft+1 )
@ oBrowse:nTop-1, oBrowse:nLeft-1 SAY "" + ;
   REPLICATE("", oBrowse:nRight-oBrowse:nLeft+1 ) + ""
@ oBrowse:nTop+1, oBrowse:nLeft-1 SAY ""
@ oBrowse:nTop+1, oBrowse:nRight+1 SAY ""
@ oBrowse:nBottom, oBrowse:nLeft-1 SAY ""
@ oBrowse:nBottom, oBrowse:nRight+1 SAY ""
@ oBrowse:nBottom+1, oBrowse:nLeft+4 SAY "Press [Esc] to exit list"

oBrowse:headSep := ''
oBrowse:colSep  := '  '
oBrowse:footSep := ''

* Note use of optional Picture clause and Validation code block for editing.
* Both values must be included in an array and put in the column cargo slot.
oColumn := TBCOLUMNNEW( 'FIELD', { |x| IF( X == NIL, ;
   PAD( aList[ nArrPos, 1 ], 10 ), aList[ nArrPos, 1 ] := X ) } )
oColumn:cargo := { "@K!", {|x| !EMPTY(X) } }
oBrowse:ADDCOLUMN(oColumn)
oColumn := TBCOLUMNNEW( 'TYPE', { |x| IF( X == NIL, ;
   aList[ nArrPos, 2 ], aList[ nArrPos, 2 ] := X ) } )
oColumn:cargo := { "!", {|x| AT( X, "CDLMN" ) <> 0 } }
oBrowse:ADDCOLUMN(oColumn)
oColumn := TBCOLUMNNEW( 'WIDTH', { |x| IF( X == NIL, ;
   STR( aList[ nArrPos, 3 ], 5, 0 ), aList[ nArrPos, 3 ] := VAL(X) ) } )
oColumn:cargo := { "@K99999", {|x| BETWEEN( VAL(X), 1, 250) } }
oBrowse:ADDCOLUMN(oColumn)
oColumn := TBCOLUMNNEW( 'DEC', { |x| IF( X == NIL, ;
   STR( aList[ nArrPos, 4 ], 3, 0 ), aList[ nArrPos, 4 ] := VAL(X) ) } )
oColumn:cargo := { "@K999", {|x| BETWEEN( VAL(X), 0, 9) } }
oBrowse:ADDCOLUMN(oColumn)

* Change the Tbrowse positioning routines for arrays instead of databases.
oBrowse:skipBlock :=  { | nMove | SkipArray( nMove, @nArrPos, LEN( aList ) ) }
oBrowse:goTopBlock := { || nArrPos := 1 }
oBrowse:goBottomBlock := { || nArrPos := LEN( aList ) }

DO WHILE nKeypress != K_ESC
   
   DO WHILE ! ( oBrowse:STABILIZE() )
   ENDDO
   
   nKeypress := INKEY( 0 )
   cKeypress := UPPER( CHR( nKeyPress ) )
   
   DO CASE
   CASE nKeyPress == K_UP;             oBrowse:UP()
   CASE nKeyPress == K_DOWN;           oBrowse:DOWN()
   CASE nKeyPress == K_LEFT;           oBrowse:LEFT()
   CASE nKeyPress == K_RIGHT;          oBrowse:RIGHT()
   CASE nKeyPress == K_PGUP;           oBrowse:PAGEUP()
   CASE nKeyPress == K_PGDN;           oBrowse:PAGEDOWN()
   CASE nKeyPress == K_CTRL_PGUP;      oBrowse:GOTOP()
   CASE nKeyPress == K_CTRL_PGDN;      oBrowse:GOBOTTOM()
   CASE nKeyPress == K_HOME;           oBrowse:HOME()
   CASE nKeyPress == K_END;            oBrowse:END()
   CASE nKeyPress == K_CTRL_HOME;      oBrowse:PANHOME()
   CASE nKeyPress == K_CTRL_END;       oBrowse:PANEND()
   CASE nKeyPress == K_TAB;            oBrowse:PANRIGHT()
   CASE nKeyPress == K_SH_TAB;         oBrowse:PANLEFT()
      
   CASE nKeyPress >= 32 .AND. nKeyPress <= 126  // Jump to next match
      IF JumpArray( cKeyPress, @nArrPos, aList, 1 )
         oBrowse:REFRESHALL()
      ENDIF

   ENDCASE
   
ENDDO

Restscreen(oBrowse:nTop-3, ;
   oBrowse:nLeft-1, ;
   oBrowse:nBottom+2, ;
   oBrowse:nRight+1, cSavescrn )

SETCOLOR( cOldColor )

RETURN .T.

* * * *
*
*	Function SkipArray()
*
FUNCTION SkipArray( nMove, nArrayPos, nArrayLength )

IF nMove > 0
   IF ( nArrayPos + nMove ) > nArrayLength
      nMove := nArrayLength - nArrayPos
   ENDIF
ELSE
   IF ( nArrayPos + nMove ) < 1
      nMove := 1 - nArrayPos
   ENDIF
ENDIF

nArrayPos += nMove

RETURN nMove

* * * *
*
*   Function JumpArray()
*
FUNCTION JumpArray( cLookFor, nArrayPos, aArray, nColumn )
* 04/19/93 - Jump to next array element starting with cLetter.
LOCAL nArrayLen := LEN( aArray ), lChanged := .F.
LOCAL nSpot := IF( nArrayPos < nArrayLen, nArrayPos+1, 1 )
nColumn := IF( VALTYPE( nColumn ) == "N", nColumn, 0 )

DO WHILE nSpot <> nArrayPos
   IF nColumn > 0
      IF aArray[nSpot,nColumn] = cLookFor
         lChanged := ( nArrayPos <> nSpot )
         nArrayPos := nSpot
         EXIT
      ENDIF
   ELSE
      IF aArray[nSpot] = cLookFor
         lChanged := ( nArrayPos <> nSpot )
         nArrayPos := nSpot
         EXIT
      ENDIF
   ENDIF
   nSpot ++
   IF nSpot > nArrayLen
      nSpot := 1
   ENDIF
ENDDO

RETURN lChanged   // did the position change?


FUNCTION Between( TheValue, TheMin, TheMax )
*****************************************************************************
* Parameters:  Value to check, minimum value and maximum value
*
*      Usage:  Can be used with Char, Num or Date values to determine
*              if the value is within a range.
*
*    Returns:  Logical value
*
*    Example: DO WHILE BETWEEN(initial,"A","K")
*****************************************************************************
RETURN TheValue >= TheMin .AND. TheValue <= TheMax


FUNCTION Spread( left_str, right_str, line_len )
**********************************************************************
* Place two character strings flush left and right on a line length
* ? SPREAD("left side","right side",80)
**********************************************************************
RETURN left_str+SPACE(line_len-LEN(left_str+right_str))+right_str

*: EOF: ABROWSE.PRG
