; statsupp.asm
;
; Support routines for status library.  If you have the Microsoft
; library, you don't need these routines.  Change the C accordingly -
; it relies on these names.


; These routines are exported .  They are directly called by C, they
; are NOT Clipper UDFs.

PUBLIC _rmemset                ; Our version of memset
PUBLIC _rmemcpy                ; Our version of memcpy
PUBLIC _rint86                 ; Our version of int86

_code  SEGMENT BYTE PUBLIC 'CODE' ; The code goes in here

ASSUME CS:_code

; void memset(void *ptr, unsigned int num, unsigned int value)
;
; Set num bytes at ptr to value

_rmemset PROC FAR

    PUSH    BP    
    MOV     BP, SP

    PUSH    DS    
    PUSH    ES    
    PUSH    SI    
    PUSH    DI    

    ; First, get destination address.  First parameter is at BP + 06
    ; Remember - LARGE model.
    LES DI, DWORD PTR [BP + 06]

    ; second, get the value to set it to. This is second parameter
    ; at [BP + 0A], since first parameter needed four bytes.
    MOV     AX, WORD PTR [BP + 0Ah]

    ; third, get the length.  This is third parameter at [BP + 0C]
    MOV     CX, WORD PTR [BP + 0Ch]

    ; if they asked for zero, do nothing
    JCXZ    _rms_ret

    ; Get char to set in AL in prep. for STOSB
    MOV     AX, BX

    ; Now do the set
    CLD
    REP     STOSB

_rms_ret:
    POP     DI
    POP     SI
    POP     ES
    POP     DS

    POP     BP

    RET

_rmemset ENDP


; void _rmemcpy(void *dest, void *src, unsigned int num)
;
; Copy num bytes from src to dest


_rmemcpy PROC FAR

    PUSH    BP    
    MOV     BP, SP

    PUSH    DS    
    PUSH    ES    
    PUSH    SI    
    PUSH    DI    

    ; first, get destination pointer
    LES     DI, DWORD PTR [BP + 06]

    ; second, get source pointer
    LDS     SI, DWORD PTR [BP + 0AH]

    ; third, get length
    MOV     CX, WORD PTR [BP + 0EH]

    ; if they asked for zero bytes, skip
    JCXZ    _rms_ret

    ; do the move
    CLD
    REP     MOVSB

_rmc_ret:
    POP     DI
    POP     SI
    POP     ES
    POP     DS

    POP     BP
    RET

_rmemcpy ENDP


; void _rint86(unsigned int int_num, union REGS *inregs,  union REGS *outregs)
;
; Load inregs registers, do interrupt int_num, save registers in
; outregs


wordregs STRUC

    REG_AX    DW 0
    REG_BX    DW 0
    REG_CX    DW 0
    REG_DX    DW 0
    REG_SI    DW 0
    REG_DI    DW 0
    REG_FLAGS DW 0

wordregs ENDS


_rint86 PROC FAR

    PUSH    BP
    MOV     BP, SP

    PUSH    DS
    PUSH    ES
    PUSH    SI    
    PUSH    DI    

    ; first get interrupt # ...
    MOV     AX, WORD PTR [BP + 06]

    ; Now, write it over second byte of INT instruction !!! - See
    ; below
    MOV     CS: BYTE PTR int_label + 1, AL
    
    ; Next, get pointer to input registers.  Use DS to save ES override
    ; instruction bytes ...
    LDS     SI, DWORD PTR [BP + 08]

    ; now load registers
    MOV     AX, [SI.REG_AX]
    MOV     BX, [SI.REG_BX]
    MOV     CX, [SI.REG_CX]
    MOV     DX, [SI.REG_DX]
    MOV     DI, [SI.REG_DI]
    MOV     SI, [SI.REG_SI]     ; This must be last ...

    ; This is very, very naughty.  We have no way of saying :
    ;       INT AL
    ; or
    ;       INT [var]
    ;
    ; All we have is INT <num>.  So, I assemble INT 0, then overwrite
    ; the 0 byte with the real interrupt vector!


int_label:
    INT     0

    ; quick, save flags before they get changed
    PUSHF

    ; save SI for a moment
    PUSH    SI

    ; point to output registers
    LDS     SI, DWORD PTR [BP + 0CH]

    ; save regs
    MOV     [SI.REG_AX], AX
    MOV     [SI.REG_BX], BX
    MOV     [SI.REG_CX], CX
    MOV     [SI.REG_DX], DX
    MOV     [SI.REG_DI], DI

    ; GET old SI back into AX
    POP     AX
    MOV     [SI.REG_SI], AX

    ; now get flags ...
    POP     AX
    MOV     [SI.REG_FLAGS], AX

    ; now do regular return
    POP     DI
    POP     SI
    POP     ES
    POP     DS

    POP     BP
    RET    

_rint86 ENDP

_code ENDS                   ; End of Code segment

    END                      ; End of program
