* LIBFIX
*   Program to replace all occurrences
*       of &OLD_STR with &NEW_STR

* Compile with the switch:  /n

* This code is released to public domain.
*  (That means that somebody may want to clean up my variable naming usage!)

* For testing only:
* Compile with the switch  /dTEST  and  this program will write out an exact
*   duplicate of the input file.  You can use this to verify that program
*   actually copies entire files, byte for byte !
*   (See the CheckIt() function at the end of the program listing.)

FUNCTION libfix( file1, file2 )

// You may use this program to replace all occurrences
//      of a series of characters with another series
// Note both must be the same length (as this program is currently written)
    old_str :=   "CLIPPER501"
    new_str :=   "CLIPPER520"

    nLineFlag := PROCLINE() + 1
    IF LEN(old_str) != LEN(new_str)
        IF nLineFlag > 0
            ?
            ? "Programmer's ERROR:  In program line:  "
            ?? LTRIM( STR( nLineFlag,10,0) )
        ENDIF
        error_msg(" Old and new strings must be the same length. ")
        ERRORLEVEL(254)
        QUIT
    ENDIF

    SETCOLOR("W+/B","N/BG")

    CLEAR

    @ 2,0 to 6,79
    @ 3,1 SAY PADC("Program to replace all occurrences",78)
    @ 4,1 SAY PADC("  of:  " + old_str, 78)
    @ 5,1 SAY PADC("with:  " + new_str, 78)

    IF PCOUNT() > 0 ;
        .AND. UPPER(LTRIM(RTRIM( file1 ))) $ "?~/?~-?~H~/H~-H~HELP~/HELP~-HELP"

?
? "  ͻ "
? "     This program can be used to replace all occurrences of one series       "
? "     of characters or bytes with the contents of another series.             "
? "                                                                             "
? "     This program is currently compiled to solve a problem with upgrading    "
? "     third party libraries from Clipper 5.01 to Clipper 5.2.                 "
? "                                                                             "
? "     The symbol CLIPPER501 in many libraries needs to be changed to          "
? "     CLIPPER520.  This can be accomplished using this program instead of     "
? "     recompiling all of the libraries.                                       "
? "                                                                             "
? "     I suggest first rename the old library with an extension of:  *.L50     "
? "     The program will prompt for the file names for input and output.        "
? "                                                                             "
? "     File names may also be entered on the command line as:                  "
? "         LIBFIX  <Input file>  <Output file>                                 "
? "     Example:                                                                "
? "         LIBFIX  NANFOR.L50  NANFOR.LIB                                      "
? "  ͼ "
        WAIT
        ERRORLEVEL(1)
        QUIT
    ENDIF

    IF PCOUNT() > 0 .AND. file( file1 )
        f_in := UPPER(file1)
        @ 8,1 SAY " File to convert: " + f_in

    ELSE
        f_in := space(13)
        @ 8,10 SAY " Enter file to convert: " GET f_in picture "@!"
        SET CONFIRM ON
        READ
    ENDIF

    f_in := TRIM(f_in)

    IF LEN(f_in) == 0
        ERRORLEVEL(1)
        QUIT
    ENDIF

    IF .NOT. file( f_in )
        error_msg("FILE NOT FOUND: " + f_in)
        ERRORLEVEL(1)
        QUIT
    ENDIF

    IF PCOUNT() > 1
        f_out := UPPER(file2)
        @ 10,1 SAY "Output file name: " + f_out

    ELSE
        f_out := space(13)
        @ 10,10 SAY "Enter output file name: " GET f_out picture "@!"
        SET CONFIRM ON
        READ
    ENDIF

    f_out := TRIM(f_out)
    IF LEN(f_out) == 0
        ERRORLEVEL(1)
        QUIT
    ENDIF

    IF f_in == f_out
        error_msg( "DUPLICATE FILE NAME ERROR" )
        ERRORLEVEL(1)
        QUIT
    ENDIF

    IF FILE( f_out )
        DEVPOS(11,0)
        x_color := SETCOLOR("W+/R")

        ? CHR(7)
        ? " File already exists:  " + f_out
        ?
        SETCOLOR(x_color)
        ? CHR(7)
        l_kill := .F.
        n_row := row()
        @ n_row, 2 SAY "OK to overwrite? " GET l_kill picture "Y"
        SET CONFIRM OFF
        READ
        IF .NOT. l_kill
            ERRORLEVEL(1)
            QUIT
        ENDIF
        @ n_row - 2 ,0 CLEAR TO n_row+1, 79
    ENDIF

    fh_in := FOPEN( f_in )
    IF fh_in < 0
        error_msg("UNABLE TO OPEN FILE: " + f_in)
        ERRORLEVEL(1)
        QUIT
    ENDIF


    fh_out := FCREATE( f_out )
    IF fh_out < 0
        error_msg( "UNABLE TO CREATE OUTPUT FILE: " + f_out)
        FCLOSE(fh_in)
        ERRORLEVEL(1)
        QUIT
    ENDIF


    cStr := SUBSTR(old_str,1)
    cStrLen := LEN(cStr)

    c1 := space(1)

    FSEEK( fh_in , 0 )  // position to beginning of input file

    bytes_in := 0

    bytes_in := FREAD( fh_in, @cStr, cStrLen )
    IF bytes_in < cStrLen
        FCLOSE(fh_in)
        FCLOSE(fh_out)
        FERASE(f_out)
        error_msg("FILE TOO SMALL, COULD NOT CONTAIN DESIRED DATA: " + f_in)
        ERRORLEVEL(1)
        QUIT
    ENDIF

    bytes_out := 0

    nShow := 0

    DEVPOS(12,0)
    ?

    while bytes_in > 0

        // Read next character and temporarily hold it in c1:
        bytes_in := FREAD( fh_in, @c1, 1 )
        IF bytes_in < 1
            // Write out the rest of the buffer:
            bytes_out := FWRITE( fh_out, cStr, cStrLen)
            IF bytes_out < cStrLen
                error_out()
                WAIT
            ELSE
                ?
                ? PADC(" DONE ",80, CHR(205))
                ?
            ENDIF
            EXIT
        ENDIF

        // Write out oldest character:
        bytes_out := FWRITE( fh_out, LEFT(cStr,1), 1)
        IF bytes_out <> 1
            FCLOSE(fh_in)
            FCLOSE(fh_out)
            error_out()
            WAIT
            ERRORLEVEL(1)
            QUIT
        ENDIF

        // Shift buffer and add the next character that was read above:
        cStr := SUBSTR( cStr, 2, cStrLen-1) + c1

        // Check for character series that needs to be subsituted:
        Check_It()

        nShow ++
        IF nShow > 63
            // Show activity only every 64th byte:
            nShow := 0
            ?? "."
            IF inkey() == 27    // Escape key pressed
                FCLOSE(fh_in)
                FCLOSE(fh_out)
                x_color := SETCOLOR("W+/R")
                ? chr(7)
                ? PADC("ESCAPE was pressed.   Program terminated.",80)
                ? PADC("File will be truncated (may not be complete).",80)
                ? chr(7)
                SETCOLOR( x_color)

                quit
            ENDIF
        ENDIF

    enddo


    FCLOSE(fh_in)
    FCLOSE(fh_out)

RETURN (NIL)

******************************
******************************

FUNCTION error_out()

    local x_color := SETCOLOR("W+/R")

    ?
    ? "          Error writing output file.           "
    ? chr(7)
    ? " File will be truncated (may not be complete). "
    ? chr(7)

    SETCOLOR( x_color)

    RETURN (NIL)

***************************

FUNCTION error_msg( c_msg )

    local x_color := SETCOLOR("W+/R")

    ? chr(7)
    ? space(1)
    ?? c_msg
    ?? space(1)
    ? chr(7)

    SETCOLOR( x_color)

    WAIT

    RETURN (NIL)

***************************

FUNCTION Check_It()

    STATIC nCount := 0

    IF cStr == old_str

// Skip the substitution if TEST is defined.  This may be useful if you want
//   to verify that this program actually copies correctly byte for byte !
#ifndef TEST
        // Make the substitution:
        cStr := new_str
#endif
        nCount ++
        ? nCount
        ?? ":  "
        ?? old_str
        ?? " --> "
        ?? new_str
        ?? "  "
        ?
    ENDIF

    RETURN (NIL)

***************************

