#include "box.ch"
#define TRUE   .T.
#define FALSE  .F.
*******************************************************************************
FUNCTION Main
*******************************************************************************
local i := 1,n := 0
Set( 32, FALSE )
SetColor("W/N")
Scroll()

Background()

while i <= 8
  do case
  case i = 1
    cBoxClr := "W/W"
  case i = 2
    cBoxClr := "W/N"
  case i = 3
    cBoxClr := "W/B"
  case i = 4
    cBoxClr := "W/G"
  case i = 5
    cBoxClr := "W/BG"
  case i = 6
    cBoxClr := "W/R"
  case i = 7
    cBoxClr := "W/RB"
  case i = 8
    cBoxClr := "W/GR"
  endcase
  Iter()
  SetColor("W+/N")
  DevPos( 8, 7 ); DevOut( "1" )
  DevPos( 8,27 ); DevOut( "2")
  DevPos( 8,47 ); DevOut( "3")
  DevPos( 8,67 ); DevOut( "4")
  DevPos( 24, 7 ); DevOut( "5")
  DevPos( 24,27 ); DevOut( "6")
  DevPos( 24,47 ); DevOut( "7")
  DevPos( 24,67 ); DevOut( "8")
  if i == 1
    sScr1 := SaveScreen(10,25,14,54)
    cMsg := "Enter the number for"
    cMsg2:= "the technique you Like Best"
    SetColor("B/W","W+/N")
    Scroll(10,25,14,54)
    DispBox( 10, 25, 14, 54, 2 )
    DevPos( 11,30 ); DevOut( cMsg )
    DevPos( 12,27 ); DevOut( cMsg2)
    @ 13,40 GET n PICTURE "9"
    read
    cMsg := "EXAMPLE OF 3D BOX TECHNIQUES IN CLIPPER 5.01 <space> to cycle  colors"
    nMsgLen := LEN(cMsg)/2
    do case                  // n3dT := 3dType--1=3dBox, 2=3DBorder Box
    case n == 1              // nBt  := Box type--1=single; 2=Double
      n3dT:= 1               // cTT  := Texture type--1=Bump; 2=Dip
      nBT := 1
      cTT := "B"
    case n == 2
      n3dT:= 1
      nBT := 2
      cTT := "B"
    case n == 3
      n3dT:= 1
      nBT := 1
      cTT := "D"
    case n == 4
      n3dT:= 1
      nBT := 2
      cTT := "D"
    case n == 5
      n3dT:= 2
      nBT := 1
      cTT := "B"
    case n == 6
      n3dT:= 2
      nBT := 2
      cTT := "B"
    case n == 7
      n3dT:= 2
      nBT := 1
      cTT := "D"
    case n == 8
      n3dT:= 2
      nBT := 2
      cTT := "D"
    endcase
    if n3dT == 1
      ThreeD_Box(10, 40-nMsgLen-4,14,40+nMsgLen+3,nBT,"BG/W",cTT,TRUE)
    else
      ThreeD_Bord(10, 40-nMsgLen-4,14,40+nMsgLen+3,nBT,"BG/W",cTT,TRUE)
    endif
    Set ( 16, 0 )
    SetColor("N/W")
    DevPos( 12, 40-nMsgLen ); DevOut( cMsg)
  endif
  i++
  kKey := Inkey()
  while kKey == Inkey(0)
  enddo
  DevPos( 0, 0 )
  Set ( 16, 1 )
enddo
SetColor("W/N")
Scroll()
return nil

*******************************************************************************
FUNCTION Iter()
*******************************************************************************

ThreeD_Box(1, 2,6,16,1,cBoxClr,"B",.T.)
ThreeD_Box(1,22,6,36,2,cBoxClr,"B",.T.)
ThreeD_Box(1,42,6,56,1,cBoxClr,"D",.T.)
ThreeD_Box(1,62,6,76,2,cBoxClr,"D",.T.)

ThreeD_Bord(17, 2,22,16,1,cBoxClr,"B",.T.)
ThreeD_Bord(17,22,22,36,2,cBoxClr,"B",.T.)
ThreeD_Bord(17,42,22,56,1,cBoxClr,"D",.T.)
ThreeD_Bord(17,62,22,76,2,cBoxClr,"D",.T.)

return nil

*******************************************************************************
FUNCTION ThreeD_Bord(nTop,nLeft,nBottom,nRight,nBxtyp,cBoxClr,cType,lShad)
*******************************************************************************
local kKey,cTopLine,cForeClr,cBackClr,nSlashLoc,cMsg
public cBoxChr1,cBoxChr2,cBoxChr3,cBoxChr4
if( nBxTyp  == NIL,nBxTyp  := 1,nBxTyp    := nBxTyp)
if( cBoxClr == NIL,cBoxClr := "N/W",cBoxClr := cBoxClr)
if( cType   == NIL,cType   := "B",cType  := cType)
nSlashLoc= At("/",cBoxClr)
cForeClr := SubStr(cBoxClr,1,nSlashLoc -1)
cBackClr := SubStr(cBoxClr, nSlashLoc+1,Len(cBoxClr)-Len(cForeClr)+1)

if nBxTyp == 1
  cBoxChr1 := ""
  cBoxChr2 := ""
  cBoxChr3 := ""
  cBoxChr4 := ""
else
  cBoxChr1 := ""
  cBoxChr2 := ""
  cBoxChr3 := ""
  cBoxChr4 := ""
endif

SetColor(cBoxClr)

// Draw box Background
Scroll(nTop,nLeft,nBottom,nRight)

// Outside of Border..

// Set colors to Highlites
if cType == "D"
  if cBackClr == "W"
    cBoxClr := "N/"+cBackClr
  elseif cBackClr == "N"
    cBoxClr := "W/"+cBackClr
  elseif cBackClr == "B"
    cBoxClr := "W/"+cBackClr
  else
    cBoxClr := "N+/"+cBackClr
  endif
  SetColor(cBoxClr)
endif
if cType == "B"
  cBoxClr := "W+/"+cBackClr
  SetColor(cBoxClr)
endif

BoxLoLite(nTop,nLeft+1,nBottom,nRight-1,nBxTyp,cType,cBackClr)
BoxHiLite(nTop,nLeft+1,nBottom,nRight-1,nBxTyp,cType,cBackClr)

// Reset the coords for inside box

nTop    := nTop + 1
nLeft   := nLeft + 3
nBottom := nBottom - 1
nRight  := nRight - 3

// Inside of Border

// Set colors to Highlites
if cType == "D"
  cBoxClr := "W+/"+cBackClr
  SetColor(cBoxClr)
endif
if cType == "B"
  if cBackClr == "W"
    cBoxClr := "N/"+cBackClr
  elseif cBackClr == "N"
    cBoxClr := "W/"+cBackClr
  elseif cBackClr == "B"
    cBoxClr := "W/"+cBackClr
  else
    cBoxClr := "N+/"+cBackClr
  endif
  SetColor(cBoxClr)
endif

// Draw the Box
DispBox( nTop, nLeft, nBottom, nRight, Iif(nBxtyp== 2 , 2, 1))

// Set colors to shadows
if cType == "D"
  if cBackClr == "W"
    cBoxClr := "N/"+cBackClr
  elseif cBackClr == "N"
    cBoxClr := "W/"+cBackClr
  elseif cBackClr == "B"
    cBoxClr := "W/"+cBackClr
  else
    cBoxClr := "N+/"+cBackClr
  endif
  SetColor(cBoxClr)
endif
if cType == "B"
  cBoxClr := "W+/"+cBackClr
  SetColor(cBoxClr)
endif

cTopLine := Replicate((cBoxChr1),(nRight-nLeft))
DevPos( nTop, nLeft ); DevOut( cTopLine )
DevPos( nTop, nLeft ); DevOut( cBoxChr2 )
for i = 1 to (nBottom - nTop - 1)
  DevPos( nTop+i, nLeft ); DevOut( cBoxChr3 )
next
DevPos( nTop+i, nLeft ); DevOut( cBoxChr4 )

// Reset the coords to default for Shadow

nTop    := nTop - 1
nLeft   := nLeft - 3
nBottom := nBottom + 1
nRight  := nRight + 3

if lShad
 Shadow(nTop,nLeft,nBottom,nRight)
endif

DevPos(0,0)
return nil


*******************************************************************************
FUNCTION Shadow(nTop,nLeft,nBottom,nRight)                                && 
*******************************************************************************
local nShadTop, nShadLeft, nShadBottom, nShadRight,a,b
nShadTop   := nShadBottom := MIN(nBottom + 1, MAXROW())
nShadLeft  := nLeft + 1
nShadRight := MIN(nRight + 1, MAXCOL())

a := Replicate("X", nShadRight - nShadLeft + 1 )
b := Transform( SaveScreen(nShadTop, nShadLeft, nShadBottom, nShadRight),a)

RestScreen( nShadTop, nShadLeft, nShadBottom, nShadRight,b)

nShadTop    := nTop + 1
nShadLeft   := nShadRight := Min(nRight + 1, MaxCol())
nShadBottom := nBottom

a := Replicate("X", nShadBottom - nShadTop + 1 )

RestScreen( nShadTop, nShadLeft, nShadBottom, nShadRight,b)

return nil

*******************************************************************************
FUNCTION Background                                                       && 
*******************************************************************************
SetColor("W/N")
Scroll()
SetColor("BG+/N")
for i = 0 to 24
  nRow := i
  DevPos( nRow,0 ); DevOut( Replicate(Chr(176),80) )
next i
return nil


*******************************************************************************
FUNCTION ThreeD_Box(nTop,nLeft,nBottom,nRight,nBxTyp,cBoxClr,cType,lShad)
*******************************************************************************
local kKey,cTopLine,cForeClr,cBackClr,nSlashLoc,cMsg
public cBoxChr1,cBoxChr2,cBoxChr3,cBoxChr4
if( lShad   == NIL, lShad  := TRUE, lShad := lShad)
if( nBxTyp  == NIL,nBxTyp  := 1,nBxTyp    := nBxTyp)
if( cBoxClr == NIL,cBoxClr := "N/W",cBoxClr := cBoxClr)
if( cType   == NIL,cType   := "B",cType  := cType)
nSlashLoc   := At("/",cBoxClr)
cForeClr    := SubStr(cBoxClr,1,nSlashLoc -1)
cBackClr    := SubStr(cBoxClr, nSlashLoc+1,Len(cBoxClr)-Len(cForeClr)+1)

if nBxTyp == 1
  cBoxChr1 := ""
  cBoxChr2 := ""
  cBoxChr3 := ""
  cBoxChr4 := ""
else
  cBoxChr1 := ""
  cBoxChr2 := ""
  cBoxChr3 := ""
  cBoxChr4 := ""
endif

SetColor(cBoxClr)

// Draw box Background
Scroll(nTop,nLeft,nBottom,nRight)

// Sets the color of the Shadow/highlight of the box
// Depending upon which 3D Type is called
// Draw the Box
BoxLoLite(nTop,nLeft+1,nBottom,nRight-1,nBxTyp,cType,cBackClr)
BoxHiLite(nTop,nLeft+1,nBottom,nRight-1,nBxTyp,cType,cBackClr)

// Shadow the Box
if lShad
 Shadow(nTop,nLeft,nBottom,nRight)
endif

DevPos(0,0)
return nil

*******************************************************************************
FUNCTION BoxLoLite(nTop,nLeft,nBottom,nRight,nBoxTyp,cType,cBackClr,n3Dt)
*******************************************************************************
Iif(cBackClr <> "W" , cBackClr := cBackClr, cBackClr := "W")
Iif( ValType( n3Dt ) <> "N" ,n3Dt := 1, n3Dt := n3Dt )
if cType == "B"
  if n3Dt == 1
    cBoxLowClr := "W+/"+cBackClr
  else
    cBoxLowClr := "N/"+cBackClr
  endif
    SetColor(cBoxLowClr)
endif
if cType == "D"
  if n3Dt == 1
    if cBackClr == "W"
      cBoxLowClr := "N/"+cBackClr
    elseif cBackClr == "N"
      cBoxLowClr := "W/"+cBackClr
    elseif cBackClr == "B"
      cBoxLowClr := "W/"+cBackClr
    else
      cBoxLowClr := "N+/"+cBackClr
    endif
  else
    if cBackClr == "W"
      cBoxLowClr := "W/"+cBackClr
    elseif cBackClr == "N"
      cBoxLowClr := "N/"+cBackClr
    elseif cBackClr == "B"
      cBoxLowClr := "N/"+cBackClr
    else
      cBoxLowClr := "W+/"+cBackClr
    endif
  endif
  SetColor(cBoxLowClr)
endif
DispBox( nTop, nLeft, nBottom, nRight, (nBoxTyp) )

return nil

*******************************************************************************
FUNCTION BoxHiLite(nTop,nLeft,nBottom,nRight,nBoxTyp,cType,cBackClr)
*******************************************************************************
Iif(cBackClr <> "W" , cBackClr := cBackClr, cBackClr := "W")
if cType == "B"
  if cBackClr == "W"
    cBoxHiClr := "N/"+cBackClr
  elseif cBackClr == "N"
    cBoxHiClr := "W/"+cBackClr
  elseif cBackClr == "B"
    cBoxHiClr := "W/"+cBackClr
  else
    cBoxHiClr := "N+/"+cBackClr
  endif
  SetColor(cBoxHiClr)
endif
if cType == "D"
  cBoxHiClr := "W+/"+cBackClr
  SetColor(cBoxHiClr)
endif
// Draw the Shadows/Highlights
  cTopLine := Replicate((cBoxChr1),(nRight-nLeft))
  DevPos( nTop, nLeft ); DevOut( cTopLine )
  DevPos( nTop, nLeft ); DevOut( cBoxChr2 )
  for i = 1 to (nBottom - nTop - 1)
    DevPos( nTop+i, nLeft ); DevOut( cBoxChr3 )
  next
  DevPos( nTop+i, nLeft ); DevOut( cBoxChr4 )

return

