/***
* FCSAMPLES.PRG file
* First Class' classes collection
*
* (c) 1994 Grupo EIDOS
*
* Helio Yago
*/
//
#include "Common.ch"
#include "1stclass.ch"

CLASS FcGet From GET
   VISIBLE:
      VAR         xBuffer    , ;
                  cFill      , ;
                  lFix

   READONLY:
      VAR         bInternal  , ;
                  bReal      , ;
                  lNRight    , ;
                  lCRight    , ;
                  lCLeft     , ;
                  nLenBuff   , ;
                  nLenDec    , ;
                  cComma

   VISIBLE:
      MESSAGE     Init         METHOD Init
      MESSAGE     Update       METHOD Update
      MESSAGE     Insert       METHOD Insert
      MESSAGE     OverStrike   METHOD OverStrike
      MESSAGE     Right        METHOD FcRight
      MESSAGE     Left         METHOD FcLeft
      MESSAGE     BackSpace    METHOD BackSpace
      MESSAGE     Delete       METHOD FcDelete
      MESSAGE     SetFocus     METHOD SetFocus
      MESSAGE     KillFocus    METHOD KillFocus
      MESSAGE     ReDisplay    METHOD ReDisplay
      MESSAGE     rNumbers     METHOD rNumbers
      MESSAGE     rChr         METHOD rChr
      MESSAGE     ChrFill      METHOD ChrFill

ENDCLASS
// -
METHOD Init( nRow      , ;
            nCol       , ;
            bBlock     , ;
            cVarName   , ;
            cPicture   , ;
            cColorSpec , ;
            bValid     , ;
            bWhen      , ;
            lDisplay   , ;
            lRight     , ;
            lLeft      , ;
            cFill      , ;
            lFix         )

   STATIC k
   LOCAL lNRight := .F. , ;
         lCRight := .F. , ;
         lCLeft  := .F.
   DEFAULT lDIsplay TO .F.       , ;
           bBlock   TO { || NIL }, ;
           lRight   TO .F.       , ;
           lLeft    TO .F.       , ;
           lFix     TO .F.

   IF lRight
      DEFAULT cFill    TO ""
   ELSE
      DEFAULT cFill    TO "0"
   END IF

   ::xBuffer   := Eval( bBlock )
   ::bReal     := bBlock
   ::bInternal := {|x|IIF(pCount()==0,::xBuffer,::xBuffer:=x)}

   ::QParent(k):Init(nRow,nCol,::bInternal,cVarName,cPicture,cColorSpec)

   IF     ::Type == "N" .AND. lRight
      lNRight    := .T.
   ELSEIF ::Type == "C"
      lCRight    := lRight
      lCLeft     := lLeft
   END IF

   ::PostBlock   := bValid
   ::PreBlock    := bWhen
   ::lNRight     := lNRight
   ::lCRight     := lCRight
   ::lCLeft      := lCLeft
   ::cFill       := cFill
   ::lFix        := lFix

   IF ::lNRight
      IF Empty( ::Picture )
         ::Picture := AutoPict( ::xBuffer )
      END IF
      ::cComma := IIF( Upper(SubStr( ::Picture , 2 , 1 ) ) == "E" , "." , "," )
   END IF

   IF lDIsplay
      ::Display()
   END IF
RETURN Self
// -
METHOD Update( lUpdate )
   DEFAULT lUpdate TO .T.
   IF lUpdate
      eVal( ::bReal , ::xBuffer )
   ELSE
      ::xBuffer := Eval( ::bReal )
      ::Display()
   END IF
RETURN Self
// -
METHOD Insert( cKey )
   STATIC k
   IF !::lNRight
      IF !::lCLeft
         ::ChrFill( .T. )
         ::QParent(k):Insert( cKey )
      ELSE
         ::rChr( cKey )
      END IF
   ELSE
      ::rNumbers( cKey )
   END IF
RETURN SelF
// -
METHOD OverStrike( cKey )
   STATIC k
   IF !::lNRight
      IF !::lCLeft
         ::ChrFill( .T. )
         ::QParent(k):OverStrike( cKey )
      ELSE
         ::rChr( cKey )
      END IF
   ELSE
      ::rNumbers( cKey )
   END IF
RETURN Self
// -
METHOD rNumbers( cKey )
   STATIC k

   IF cKey == "-" .AND. SubStr( ::Buffer , 1 , 1 ) $ " -"
      ::Buffer := Transform( Val( StrTran( ::Buffer , ::cComma ) )*-1 , ::Picture )
      ::ReDisplay()
      RETURN Self
   END IF

   IF SubStr( ::Buffer,1,1) # " " .AND. ;
            ( ::Pos < ::DecPos )  .AND. ( ::nLenBuff # 1 )
      Tone(125,0)
      RETURN Self
   END IF

   IF     ::nLenDec == 0
          ::Buffer  := SubStr( ::Buffer , 2 ) + cKey

   ELSEIF ::nLenDec  # 0 .AND. ( ::Pos < ::DecPos )

      ::Buffer := SubStr( ::Buffer , 2 , ::DecPos - 2 ) + ;
           cKey + SubStr( ::Buffer , ::DecPos , ::nLenDec )

   ELSEIF ::nLenDec # 0 .AND. ( ::Pos >= ::DecPos )

      ::QParent(k):OverStrike( cKey )

   END IF

   ::ReDisplay()

RETURN Self
// -
METHOD ReDisplay()
   LOCAL cVal := StrTran( ::Buffer , ::cComma )
         cVal := StrTran( cVal , "," , "." )
   ::Buffer   := Transform( Val( cVal ) , ::Picture )
   ::Display()
   ::Changed := .T.
RETURN Self
// -
METHOD FcRight()
   STATIC k
   IF !::lNRight .AND. !::lCLeft .OR. (::lNRight.AND.(::Pos>=::DecPos-2))
      ::QParent(k):Right()
   END IF
RETURN Self
// -
METHOD FcLeft()
   STATIC k
   IF !::lNRight .AND. !::lCLeft .OR. (::lNRight.AND.(::Pos>::DecPos))
      ::QParent(k):Left()
   END IF
RETURN Self
// -
METHOD BackSpace()
   STATIC k
   IF !::lNRight
      IF ::lCLeft
         ::Buffer := ::cFill + Left( ::Buffer , ::nLenBuff - 1 )
         ::Display()
         ::Changed := .T.
      ELSE
         ::QParent(k):BackSpace()
         ::ChrFill( .T. )
      END IF
   ELSE
      ::Delete()
   END IF
RETURN Self
// -
METHOD FcDelete()
   STATIC k
   IF !::lNRight
      IF ::lCLeft
         ::Buffer := ::cFill + Left( ::Buffer , ::nLenBuff - 1 )
         ::Display()
         ::Changed := .T.
      ELSE
         ::QParent(k):Delete()
         ::ChrFill( .T. )
      END IF
   ELSE
      IF ::Pos # ::DecPos - 1
         RETURN Self
      END IF
      IF     ::nLenDec == 0
      ::Buffer := " " + Left( ::Buffer , ::nLenBuff - 1 )
      ELSEIF ::nLenDec  # 0 .AND. ( ::Pos < ::DecPos )
      ::Buffer := " " + Left( ::Buffer , ::DecPos - 2 ) + ;
      SubStr( ::Buffer , ::DecPos , ::nLenDec )
      END IF
      ::ReDisplay()
   END IF
RETURN Self
// -
METHOD SetFocus()
   STATIC k
   ::QParent(k):SetFocus()
   ::nLenBuff := Len( ::Buffer )
   ::nLenDec  := ( ::nLenBuff - ::DecPos ) + 1
   IF ::lNRight
      ::End()
      IF ::nLenDec # 0
         ::ToDecPos()
         ::Left()
      END IF
   ELSEIF ::lCLeft
      ::End()
   END IF
   ::ChrFill( .T. )
RETURN Self
// -
METHOD KillFocus()
   STATIC k
   ::ChrFill( .F. )
   ::QParent(k):KillFocus()
RETURN Self
// -
METHOD ChrFill( lFill )
   IF !::lCRight .AND. !::lCLeft
      RETURN Self
   END IF

   IF ::nLenBuff == 1
      ::Home()
      RETURN Self
   END IF

   IF ::lCRight // filled on the right hand

      IF lFill
         ::Buffer := PadR( Trim( ::Buffer ) , ::nLenBuff , ::cFill )
      ELSE
         IF !::lFix
            ::Buffer  := StrTran( ::Buffer  , ::cFill , " " )
            ::xBuffer := StrTran( ::xBuffer , ::cFill , " " )
         END IF
      END IF

   ELSE         // filled on the left hand

      IF lFill
         ::Buffer := PadL( LTrim( ::Buffer ) , ::nLenBuff , ::cFill )
      ELSE
         IF !::lFix
            ::Buffer  := StrTran( ::Buffer  , ::cFill , " " )
            ::xBuffer := StrTran( ::xBuffer , ::cFill , " " )
         END IF
      END IF

   END IF
   ::Display()
RETURN Self
// -
METHOD rChr( cKey )
   IF SubStr( ::Buffer , 1 , 1 ) # ::cFill
      Tone(125,0)
      RETURN SELF
   END IF

   ::Buffer := SubStr( ::Buffer , 2 ) + cKey
   ::Display()
   ::Changed := .T.
RETURN Self
// -
FUNCTION AutoPict( nVar )
   STATIC cPict  := "999,999,999,999,999,999,999,999,999"
   LOCAL cVar    := Str( nVar )
   LOCAL nLenVar := Len( cVar )
   LOCAL nPosDec := At(  "." , cVar )
   IF nPosDec > 0
      RETURN "@E " + Right( cPict , ( nPosDec - 1 ) * 1.30 ) + ;
               "." + Replicate( "9" , nLenVar - nPosDec )
   END IF
RETURN "@E " + Right( cPict , nLenVar * 1.30 )
