/***
* TSBROW.PRG file
* First Class' classes collection
*
* (c) 1994 Grupo EIDOS
*
* Ramn Delgado
* Alfonso Fraguas
*/
//
#include "1stClass.CH"
#include "TSBrw.CH"

CLASS TSpeedBrowse FROM TBrowse
   HIDDEN:
      VAR nAncho                    // AS NUMERIC

   VISIBLE:
      VAR BMinima                   // AS NUMERIC
      VAR BPrimera                  // AS NUMERIC
      VAR BActual                   // AS NUMERIC
      VAR BUltima                   // AS NUMERIC
      VAR BMaxima                   // AS NUMERIC
      VAR BColumnas                 // AS ARRAY
      VAR BTipo                     // AS CHARACTER


      // Redefine parent class
      MESSAGE Left      METHOD xLeft
      MESSAGE Right     METHOD xRight
      MESSAGE Home
      MESSAGE End
      MESSAGE PanHome
      MESSAGE PanEnd
      MESSAGE PanLeft
      MESSAGE PanRight
      MESSAGE AddColumn

      // New methods
      MESSAGE Init      METHOD Db
      MESSAGE SetLeft
      MESSAGE SetRight
      MESSAGE LenView
      MESSAGE DelAll
      MESSAGE LenCol
ENDCLASS
// -
METHOD Db( nTop, nLeft, nBottom, nRight ), ;
         ( nTop, nLeft, nBottom, nRight )
   ::BMinima   := 0
   ::BPrimera  := 0
   ::BActual   := 1
   ::BUltima   := 0
   ::BMaxima   := 0
   ::BColumnas := {}
   ::BTipo     := '.SpeedBrow.'
   ::nAncho    := ::nRight - ::nLeft+1
RETURN Self
// -
METHOD xLeft()
   STATIC _hPLeft

   IF ::BActual > ::BPrimera
      ::QParent(_hPLeft):left()
      ::BActual--

   ELSEIF ::BActual <= ::BMinima+1 .AND. ::BActual>1
      IF ::freeze > 0
         ::QParent(_hPLeft):Left()
         ::BActual := ::colPos
      END IF

   ELSEIF ::BActual == ::BPrimera .AND. ::BActual > ::BMinima+1
      ::SetLeft()
      ::BActual--
      ::Colpos := ::BActual - ::BPrimera + ::BMinima+1
   END IF

RETURN Self
// -
METHOD xRight()
   STATIC _hPRight

   IF ::BActual < ::BUltima
      ::QParent(_hPRight):right()
      ::BActual++
   ELSEIF ::BActual == ::BUltima .AND. ::BUltima< ::BMaxima
      ::SetRight()
      ::BActual++
      ::Colpos := ::BActual - ::BPrimera + ::BMinima+1
   END IF

RETURN Self
// -
METHOD SetLeft()
   LOCAL nLenBrow  := ::nRight - ::nLeft+1               ,;
         nLenView

   ::insColumn(::BMinima+1,::BColumnas[--::BPrimera])

   WHILE ::LenView() > nLenBrow .AND. ::BUltima > ::BPrimera

      ::delColumn(::Colcount)
      ::BUltima--

   END WHILE

   WHILE (nLenView := ::LenView()) < nLenBrow .AND. ::BPrimera-1 > ::BMinima

      ::InsColumn( ::BMinima+1, ::BColumnas[--::BPrimera] )

   END WHILE

   IF nLenView > nLenBrow
      ::Delcolumn( ::BMinima+1 )
      ::BPrimera++
   END IF

RETURN NIL
// -
METHOD SetRight()
   LOCAL nLenBrow := ::nRight - ::nLeft+1                ,;
         nLenView

   ::insColumn( ::ColCount+1, ::BColumnas[++::BUltima] )

   WHILE ::LenView() > nLenBrow .AND. ::BPrimera < ::BUltima
      ::delColumn(::BMinima+1)
      ::BPrimera++
   END WHILE

   WHILE (nLenView := ::LenView()) < nLenBrow .AND. ::BUltima+1 < ::BMaxima
      ::InsColumn( ::colCount+1, ::BColumnas[++::BUltima] )
   END WHILE

   IF nLenView > nLenBrow
      ::Delcolumn(::colcount)
      ::BUltima--
   END IF

RETURN NIL
// -
METHOD End()
   STATIC _hPEnd

   ::BActual:=::BUltima
   ::QParent(_hPEnd):End()
RETURN Self
// -
METHOD PanEnd()
   STATIC _hPPanEnd

   IF ::BUltima <> ::BMaxima
      ::DelAll()
      ::BPrimera := ::BMaxima+1
      ::BUltima  := ::BMaxima
      ::SetLeft()
      ::BActual := ::BMaxima
      ::ColPos  := ::ColCount
   ELSE
      ::End()
   END IF

RETURN Self
// -
METHOD Home()
   STATIC _hPHome

   IF ::BActual <> ::colPos
      ::BActual := ::BPrimera
      ::QParent(_hPHome):Home()
   ELSE
      ::Dehilite()
      ::BActual:=1
      ::colpos:=1
      ::Hilite()
   END IF

RETURN Self
// -
METHOD PanHome()

   IF ::BPrimera <> ::Bminima+1
      ::DelAll()
      ::BPrimera := ::BMinima+1
      ::BUltima  := ::BMinima
      ::SetRight()
      ::ColPos  := 1
      ::BActual := 1
   ELSE
      ::Home()
   END IF

RETURN Self
// -
METHOD PanLeft()

   IF ::BPrimera > ::BMinima+1
      ::SetLeft()
      IF ::BActual > ::BUltima
         ::BActual := ::BUltima
      END IF
      ::Colpos := ::BActual - ::BPrimera + ::BMinima+1
   END IF

RETURN Self
// -
METHOD PanRight()

   IF ::BUltima <> ::BMaxima
      ::SetRight()
      IF ::BActual < ::BPrimera
         ::BActual := ::BPrimera
      END IF
      ::Colpos := ::BActual - ::BPrimera + ::Bminima+1
   END IF

RETURN Self
// -
METHOD LenView()
LOCAL nT                                                                 ,;
      nLenView:=0                                                        ,;
      nPos:=1

   IF ::Freeze > 0
      FOR nT:= 1 TO ::BMinima
         nLenView += ::LenCol( ::BColumnas[nT], nPos++ )
      NEXT
   END IF

   FOR nT := ::BPrimera TO ::BUltima
      nLenView += ::LenCol( ::BColumnas[nT], nPos++ )
   NEXT

RETURN nLenView
// -
METHOD LenCol( oCol, nPos )
   LOCAL nLen := ::ColWidth( nPos )

   IF nPos > 1
      nLen += If( oCol:ColSep <> NIL, Len(oCol:ColSep), Len(::Colsep) )
   END IF

RETURN nLen
// -
METHOD DelAll()

   WHILE ::colCount > ::Freeze
      ::delColumn(::Colcount)
   END WHILE

RETURN Self
// -
METHOD AddColumn( oCol )
   STATIC _hPAddCol
   LOCAL nLenCol

   ::QParent(_hPAddCol):AddColumn(oCol)

   nLenCol := ::LenCol( oCol, ::ColCount )

   IF ::nAncho - nLenCol >= 0
      ::nAncho -= nLenCol
      ::BUltima := ::ColCount
   ELSE
      ::DelColumn( ::ColCount )
   ENDIF
   ::BMaxima++
   aAdd( ::BColumnas, oCol )
   ::BMinima  := ::Freeze
   ::BActual  := 1
   ::BPrimera := ::BMinima+1

RETURN Self
