/*-------------------------------- 132Col_5.PRG ------------------------------*
* Copyright 1992, Samer Najia, all rights reserved
*
* Purpose: Small function for switching to extended text mode, and a routine as
*          an example of how to use it
*
* Written By: Samer Najia (72267,1615) based on suggestions from
*             David Reynolds (73730,2047) and Larry M. Rappaport.
*
* Note:
*   Feel free to download this PRG and use it in your applications.  You'll
*   receive support for this library commensurate with what you paid for it --
*   that is, no support is provided.  I'll take any comments or suggestions
*   sent to my CIS ID.
*
* Compiler Note:
*   Compile with /DTEST to enable the test program on linking
*
* Requires:
*   NanFor.LIB Version 2 and later.  Depends on FT_Hex2Dec() and FT_Int86()
*
* Samer Najia
* CIS ID: 72267,1615
*----------------------------------------------------------------------------*/
#ifdef TEST

    cCode := SPACE(2)

    DO WHILE .T.
        CLEAR
        // get the mode code
        // at worst, the screen will blank out and nothing will happen

        @ 10,10 SAY "Hex Code for text mode:" GET cCode PICTURE "@!"
        READ
        IF LASTKEY() == 27
            EXIT
        ENDIF

        CLEAR

        SwitchMode(cCode)

        FOR n = 0 TO MAXROW()
            @ n,0 SAY "This is row #: " + ALLTRIM(STR(n))
        NEXT
        // Check out the effects on @ x,y SAY...
        @ 0,0 SAY "Total Columns = " + ALLTRIM(STR(MAXCOL() + 1)) +;
                            "   Total Rows    = " + ALLTRIM(STR(MAXROW() + 1))
        @ 1,0 SAY "1234567890                                                     "
        @ 1,15 SAY "1234567890                                                    "
        @ 1,MAXCOL() - 15 SAY "1234567890                                         "
        @ 2,0 SAY "Press a key                                                    "
        INKEY(0)
    ENDDO

    // go back to normal

    IF ISCOLOR()
        SwitchMode("3")
    ELSE
        SwitchMode("7")
    ENDIF
    CLEAR

    RETURN
#endif
/*---------------------------------------------------------------------------*/

FUNCTION SwitchMode(cVidMode)
/*------------------------------- SwitchMode() -------------------------------*
* Purpose: To switch video modes on a VGA (or maybe even an EGA) card to be
*          able to access those hard to get to text modes that might be built
*          into the hardware.  For example, 132 column mode (text) is not a
*          standard on any video card, but it may be supported.  If it is, and
*          the appropriate parameter is know, this function can enable it.
*          With this, MAXROW() and MAXCOL() are also set.  Returns an array
*          containing the old MAXROW() + 1, MAXCOL() + 1 setting:
*                  {nOldRows,nOldCols}
*
* Parameters:
*   1) cVidMode   c,2   Hex code defining the video mode to switch to.  For
*                       example, on an ATI VGA-Wonder, 23h is 132x25 colour --
*                       pass 23 (omit the trailing h) to enable this mode.
*
* Written By: Samer Najia (72267,1615) based on suggestions from
*             David Reynolds (73730,2047) and Larry M. Rappaport -- thanks to
*             both of you for showing me the light.  I won't be skeptical
*             anymore.
*----------------------------------------------------------------------------*/
LOCAL aRegs := {},n,nOldRows := MAXROW() + 1,nOldCols :=  MAXCOL() + 1

IF VALTYPE(cCode) <> "C"
    cCode :=  ""
ENDIF

IF !EMPTY(cCode)
    FOR n = 1 TO 10
        AADD(aRegs,NIL)
    NEXT

    cVidMode := ALLTRIM(cVidMode)

    aRegs[1] := FT_Hex2Dec(cVidMode)
    FT_Int86(FT_Hex2Dec("10"),aRegs)
    INKEY(0.5)  // seems like the system needs some time to resolve itself
    SETMODE()  // recalc internal values
ENDIF

RETURN ({nOldRows,nOldCols})
/*---------------------------------------------------------------------------*/
