*------------------------------- 132Col87.PRG --------------------------------*
* Purpose: Small function to switch to extended text modes under EGA/VGA
*
* Note:
*   Summer '87 version
*
* Written By: Samer Najia
*-----------------------------------------------------------------------------*

FUNCTION SwitchMode
PARAMETERS cCode
*------------------------------- SwitchMode() --------------------------------*
* Purpose: To enable access to a video boards extended text modes
*
* Parameters:
*   1) cCode   c     Hexadecimal representation of the extended text mode
*                    supported by the video board.  Note that this varies from
*                    board to board (hence the need for drivers)
*
* Note:
*   1) Summer '87 version
*   2) This is the version converted from the CLIPPER 5 variant.  The CLIPPER 5
*      variant uses NanFor.LIB to access int86.  This version uses
*      the interrupt tweakers available in FUNCKy (V 1.0+)
*   3) Might work on EGA boards, but not tested on them.  This function works
*      fine for VGA boards.
*   4) cCode = "7" resets to 80x25 for colour adapters, cCode = "3" resets to
*      80x25 for mono adapters.
*
* Syntax:
*   1) SwitchMode("23")  switches to 132x25 mode on the ATI VGA Wonder
*
* Written By: Samer Najia based on suggestions by David Reynolds and
*             Larry Rappaport
*-----------------------------------------------------------------------------*
*--- Set the AX Register value
Reg_AX(Hex2Dec(cCode))
*--- Call int86 (or 10H)
Interrupt(Hex2Dec("10"))
RETURN ("")
