;  Copyright (c) 1991 Michael Kragl   All rights reserved.
;                     Compuserve: 75070,2113
;
;  MY_CLIPBRD
;  Copy Clipper-String to Microsoft Windows-Clipboard
;
;--------------------------------------------------------------------------
;       sample call from clipper:                                         |
;--------------------------------------------------------------------------
; |   external MY_CLIPBRD
; |   cliadr:="Teststring"
; |   ii=my_clipbrd(@cliadr)
; |
; |   do case
; |           case ii = 0
; |                   ii=my_clipbrd(@cliadr)      //sometimes it does'nt work for the 1st time
; |                   if ii = 0
; |                           ?"this function is only supported under Windows"
; |                           inkey(3)
; |                   else
; |                           ?"ok - 2"
; |                   endif
; |           case ii = 1
; |                   ?"ok"
; |           case ii = 2
; |                   ?"problem with EmptyClipboard"
; |                   inkey(3)
; |           case ii = 3
; |                   ?"problem with CloseClipboard"
; |                   inkey(3)
; |           case ii = 4
; |                   ?"problem with SetClipboardData"
; |                   inkey(3)
; |           otherwise
; |                   ?"????????????????"+str(ii)
; |                   inkey(3)
; |   endcase
;--------------------------------------------------------------------------
PUBLIC               MY_CLIPBRD
EXTRN                __RETNI:FAR        ;return integer
EXTRN                __PARC:FAR         ;get character parameter
EXTRN                __PARCLEN:FAR      ;get character parameter
EXTRN                __PARNI:FAR        ;get character parameter
;--------------------------------------------------------------------------
DGROUP GROUP _MY_DATA
_MY_DATA SEGMENT 'DATA'
    slen dw 0h
_MY_DATA ENDS
;--------------------------------------------------------------------------
_MY_CODE   SEGMENT 'CODE'
             ASSUME cs:_MY_CODE, ds:DGROUP

MY_CLIPBRD PROC    FAR
;--------------------------------------------------------------------------
     push    bp              ; save registers
     mov     bp,sp
     push    ds
     push    es
     push    si
     push    di
;--------------------------------------------------------------------------
     mov  ax,1700h            ; IdentifyWinOldApVersion
     int  2fh
     cmp  ax,2                ; Support Version 2?
     je   OK                  ; if yes, then j ok
     cmp ax,1700h             ; running under Windows?
     je   NOWINDOW            ;
;--------------------------------------------------------------------------
OK:
     mov  ax,1701h            ; OpenClipboard
     int  2fh
     cmp  ax,0                ; ok?
     jne EMPTYCB              ; error if 0
     mov bx,2                 ;return  2  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
EMPTYCB:
     mov  ax,1702h            ; EmptyClipboard
     int  2fh
     cmp  ax,0                ; ok?
     jne MOVEIT               ; error if 0
     mov bx,2                 ;return  2  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
MOVEIT:
     mov ax,1
     push ax
     call __PARCLEN           ;find length of paramter -> ax
     add SP,2
     inc ax                   ;add 1 for terminating zero !! (this was hard to find for me)
     mov slen,ax
;--------------------------------------------------------------------------
     mov ax,1                 ;find address of parameter
     push ax                  ;address in dx:ax
     call __PARC
     add sp,2
;--------------------------------------------------------------------------
     mov  es,dx               ;String in ES:BX
     mov  bx,ax               ;
     mov dx,7                 ; CF_OEM_TEXT  for conversion to ansi
     mov SI,0                 ;length in  SI:CX
     mov cx,slen
     mov ax,1703H             ;SetClipboardData
     int 2fh
     cmp  ax,0
     jne COPYOK
     mov bx,4                 ;return  4  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
COPYOK:
     mov  ax,1708h            ; CloseClipboard
     int  2fh
     cmp  ax,0
     jne  CLOSOK              ; if 0 error
     mov bx,3                 ;return  3  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
CLOSOK:
     mov bx,1                 ;return .t. to clipper
     jmp RETNC1
;--------------------------------------------------------------------------
NOWINDOW:
     mov  bx,0
;--------------------------------------------------------------------------
RETNC:
     mov  ax,1708h            ; CloseClipboard
     int  2fh                 ; int 2fh
;--------------------------------------------------------------------------
RETNC1:
     push bx
     call __RETNI
     add      sp,2
;--------------------------------------------------------------------------
     pop     di               ; restore registers
     pop     si
     pop     es
     pop     ds
     pop     bp
     cld

     ret
;-------------------------------------------------------------------

MY_CLIPBRD ENDP               ; end of procedure

_MY_CODE      ENDS            ; end of code segment
              END
