


;-----------------------------------------------------------------------;
; DECIHEX - Main Program - Converts dicimal input to keyboard           ;
;           to hex on screen                                            ;
;-----------------------------------------------------------------------;
decihex segment
        org     100h

        assume  cs:decihex

;MAIN PART OF PROGRAM. Connects procedures together

repeat: call    decibin         ;keyboard to binary
        call    crlf            ;print cr and lf
        call    binihex         ;binary to screen
        call    crlf            ;print cr and lf

        jmp     repeat          ;do it again

        int     20h

;---------------------------------------------------------------;
; DECIBIN.ASM--Procedure to get decimal digits from keyboard    ;
; and convert them to binary number in bx.                      ;
;---------------------------------------------------------------;

decibin proc near

        mov     bx,0                    ;Clear BX for number

;Get digit from keyboard and convert to binary

newchar:
        mov     ah,1                    ;keyboard input
        int     21h                     ;call DOS
        sub     al,30h                  ;ASCII to binary
        jl      exit                    ;jump if < 0
        cmp     al,9d                   ;is it > 9d?
        jg      exit                    ;yes, not dec digit
        cbw                             ;byte in AL to word in AX
                                        ;digit is now in AX
;Multiply number in BX by 10 decimal
        xchg    ax,bx                   ;trade digit & number
        mov     cx,10d                  ;put 10 dec in CX
        mul     cx                      ;number times 10
        xchg    ax,bx                   ;trade number & digit

;Add digit in AX to number in BX
        add     bx,ax                   ;add digit to number
        jmp     newchar                 ;get next digit

exit:
        ret                             ;return from decibin


decibin endp


 

;-----------------------------------------------------------------------;
; This procedure outputs the contents of the BX register                ;
; to the screen in hex.                                                 ;
;-----------------------------------------------------------------------;
binihex proc    near

        mov     ch,4            ;number of digits
rotate: mov     cl,4            ;set count to 4 bits
        rol     bx,cl           ;left digit to right
        mov     al,bl           ;move to AL
        and     al,0fh          ;mask off left digit
        add     al,30h          ;comvert hex to ASCII
        cmp     al,3ah          ;is it >9?
        jl      printit         ;jump if digit =0 to 9
        add     al,7h           ;digit is A to F
printit:
        mov     dl,al           ;put ASCII char in DL
        mov     ah,2            ;Display Output funct
        int     21h             ;call DOS
        dec     ch              ;done 4 digits ?
        jnz     rotate          ;not yet

        ret                     ;return from binihex

binihex endp


;-----------------------------------------------------------------------;
; crlf - Procedure to print carriage return                             ;
;        and linefeed.                                                  ;
;-----------------------------------------------------------------------;
crlf    proc    near

        mov     dl,0dh          ;carriage return
        mov     ah,2            ;display funcrion
        int     21h             ;call DOS

        mov     dl,0ah          ;linefeed
        mov     ah,2            ;display function
        int     21h             ;call DOS

        ret                     ;return from crlf

crlf    endp

decihex ends

        end









