


;------------------------------------------------------------------;
; SHIFT STATUS TEST PROGRAM-Examines KB_FLAG register, displays    ;
;                    shift status continuously (in hex). Press     ;
;                    one of the keys listed on page 283 of "The    ;
;                    Waite Group Assembly Language Primer For      ;
;                    the IBM PC & XT."                             ;
;------------------------------------------------------------------;

sh_stat equ     2h              ;shift status function
key_rom equ     16h             ;keyboard ROM call

display equ     2h              ;DOS display routine
doscall equ     21h             ;DOS interrupt number

return  equ     0dh             ;carriage return

;******************************************************************;
prognam segment                 ;define code segment
;-------------------------------------------------------------------
main    proc    far             ;main part of program

        assume  cs:prognam

again:  mov     ah,sh_stat      ;sh status function
        int     key_rom         ;call kbd ROM routine
        mov     bx,ax           ;put result in BX
        call    binihex         ;print out result
        mov     dl,return       ;print carriage return
        mov     ah,display
        int     doscall
        jmp     again           ;repeat

main    endp                    ;end of main part of program
;-------------------------------------------------------------------




;-----------------------------------------------------------------------;
; BINIHEX-Procedure to convert binary number in the BX register         ;
; to the screen in hex.                                                 ;
;-----------------------------------------------------------------------;
binihex proc    near

        mov     ch,4            ;number of digits
rotate: mov     cl,4            ;set count to 4 bits
        rol     bx,cl           ;left digit to right
        mov     al,bl           ;move to AL
        and     al,0fh          ;mask off left digit
        add     al,30h          ;comvert hex to ASCII
        cmp     al,3ah          ;is it >9?
        jl      printit         ;jump if digit =0 to 9
        add     al,7h           ;digit is A to F
printit:
        mov     dl,al           ;put ASCII char in DL
        mov     ah,2            ;Display Output funct
        int     21h             ;call DOS
        dec     ch              ;done 4 digits ?
        jnz     rotate          ;not yet
        ret                     ;done subroutine

binihex endp

;-----------------------------------------------------------------------;
prognam ends                    ;end of code segment
;************************************************************************

        end                     ;end assembly






