;
;
;   This code is from Appendix G of the book "80386 Technical Reference"
; by Edmond Strauss.  It is a foundation to build upon to put a 386 into
; virtual 8086 mode.  Because the 386 specific opcodes have been hardcoded
; it should compile with most MASMs.  I have left in most all the comments
; that were in the code except some unimplemented code that was commented
; out.  The program is run from DOS in real mode and gives back the
; familiar DOS prompt.
;
;
CR 		EQU	0DH
LF		EQU	0AH
EOS		EQU	0FFH
DOS		EQU	21H
OP_SIZE		EQU	66H
P_SIZE		EQU	67H
MOV_PBX_AX	EQU	89H	;mov [bx+i8],ax

; 80386 eflag bits
VMFL		EQU	2H
RFFL		EQU	1H
NTFL		EQU	04000H
IOPLFL		EQU	03000H

; 8086 flag bits
OFL		EQU	00800H
DFL		EQU	00400H
IFL		EQU	00200H
TFL		EQU	00100H
SFL		EQU	00080H
ZFL		EQU	00040H
AFL		EQU	00010H
PFL		EQU	00004H
CFL		EQU	00001H
;
LDT_BIT		EQU	4
NULL_ALIAS	EQU	00H
GDT_ALIAS	EQU	08H
LDT_ALIAS	EQU	0CH
IDT_ALIAS	EQU	10H
MON_TSS_SEL	EQU	18H
TMP_TSS_SEL	EQU	20H
MON_LDT_SEL	EQU	28H
FLAT_SEL	EQU	30H

; ldts
MON_CODE_SEL	EQU	14H
MON_DATA_SEL	EQU	1CH
MON_STACK_SEL	EQU	24H


DESC		STRUC
	lim_0_15	DW	0	; limit bits (0..15)
	bas_0_15	DW	0	; base bits (0..15)
	bas_16_23	DB	0	; base bits (16..23)
	access		DB	0	; access byte
	gran		DB	0	; granularity byte
	bas_24_31	DB	0	; base bits (24..31)
DESC		ENDS

; 386 GATE template
;
GDESC	STRUC
	off_0_15	DW	0	; offset (0..15)
	sel		DW	0	; selector
	dw_count	DB	0	; 0-31 (upper 3 bits 0)
	gaccess		DB	0	;access byte
	off_16_31	DW	0	;offset (16..31)
GDESC	ENDS

TSS_STRUCT	STRUC
	tss_back	DD	?
	tss_stk0	DQ	?
	tss_stk1	DQ	?
	tss_stk2	DQ	?
	tss_cr3		DD	?
	tss_eip		DD	?
	tss_eflag	DD	?
	tss_eax		DD	?
	tss_ecx		DD	?
	tss_edx		DD	?
	tss_ebx		DD	?
	tss_esp		DD	?
	tss_ebp		DD	?
	tss_esi		DD	?
	tss_edi		DD	?
	tss_ES		DD	?
	tss_CS		DD	?
	tss_SS		DD	?
	tss_DS		DD	?
	tss_FS		DD	?
	tss_GS		DD	?
	tss_LDT		DD	?
	tss_dtb		DW	?
	tss_iobm_off	DW	?
	tss_iobitmap	DB	1	DUP(0FFH)
TSS_STRUCT	ENDS

AFIRST		SEGMENT PARA
AFIRST		ENDS
TDATA		SEGMENT
TDATA		ENDS
MON_DATA	SEGMENT
MON_DATA	ENDS
MON_STACK	SEGMENT
MON_STACK	ENDS
MON_CODE	SEGMENT
MON_CODE	ENDS
VM_DATA		SEGMENT
VM_DATA		ENDS
VM_CODE		SEGMENT
VM_CODE		ENDS
ZLAST		SEGMENT PARA
ZLAST		ENDS
;

AFIRST	SEGMENT PARA
first_data	DW	?
AFIRST	ENDS


TDATA	SEGMENT
GDT_pword	LABEL	BYTE
	DW	end_gdt-gdt
b0	DW	gdt
	DW	0

IDT_pword	LABEL	BYTE
	DW	end_idt-idt
b1	DW	idt
	DW	0


;*   *   *   *   *   *   *   *   *   *   *   *******
gdt	LABEL	BYTE

	;null
	DQ	0	; null

	; gdt alias
	DW	end_gdt-gdt	; limit bits(0..15)
b2	DW	gdt	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; idt alias
	DW	end_idt-idt	; limit bits(0..15)
b3	DW	idt	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; mon tss
	DW	end_mon_tss-mon_tss	; limit bits(0..15)
b4	DW	mon_tss	; bas (0..15)
	DB	0	; bas (16..23)
	DB	089h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; tmp tss
	DW	end_tmp_tss-tmp_tss	; limit bits(0..15)
b5	DW	tmp_tss	; bas (0..15)
	DB	0	; bas (16..23)
	DB	089h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; mon ldt
	DW	end_mon_ldt-mon_ldt	; limit bits(0..15)
b6	DW	mon_ldt	; bas (0..15)
	DB	0	; bas (16..23)
	DB	082h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)


	; flat_des	DESC <0FFFFH,0,0,92h,0CFh,0>
	DW	0FFFFH		; limit bits(0..15)
	DW	0	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0CFh	; granularity
	DB	0	; bas (24..31)
end_gdt	LABEL	BYTE

;*   *   *   *   *   *   *   *   *   *   *   *******
; dos +13
;
idt	LABEL	BYTE
	DQ	12+1 DUP(?)
; ex13		our_ex13_iv	LABEL	BYTE
	DW	ex13_int
	DW	MON_CODE_SEL	; sel mon code
	DB	0
	DB	0EEh		; - dpl=3 - 386 interrupt gate
	DB	0
	DB	0
	DQ	256-13 DUP(?)
end_idt	LABEL	BYTE



;*   *   *   *   *   *   *   *   *   *   *   *******
mon_ldt	LABEL	BYTE
	; null
	DQ	0

	; mon_ldt alias
	DW	end_mon_ldt-mon_ldt	; limit bits (0..15)
b7	DW	mon_ldt	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; mon code
	DW	end_mon_code	; limit bits (0..15)
bmc0	DW	0	; bas (0..15)
	DB	0	; bas (16..23)
	DB	09Ah	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; mon data
	DW	end_mon_data	; limit bits (0..15)
bmd1	DW	0	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)

	; mon stack
	DW	end_mon_stack	; limit bits (0..15)
bms2	DW	0	; bas (0..15)
	DB	0	; bas (16..23)
	DB	092h	; access
	DB	0	; granularity
	DB	0	; bas (24..31)
end_mon_ldt	LABEL	BYTE


;*   *   *   *   *   *   *   *   *   *   *   *******
mon_tss	LABEL	BYTE
	DD	0			; mon_back
	DW	mon_tos,0,MON_STACK_SEL,0	; mon_stk0
	DQ	0			; mon_stk1
	DQ	0			; mon_stk2
	DD	0			; mon_cr3
	DW	begin_mon,0		; mon_eip
	DW	0,0			; mon_eflag IFL,0
	DD	0			; mon_eax
	DD	0			; mon_ecx
	DD	0			; mon_edx
	DD	0			; mon_ebx
	DW	mon_tos,0		; mon_esp
	DD	0			; mon_ebp
	DD	0			; mon_esi 
	DD	0			; mon_edi
	DW	MON_DATA_SEL,0		; mon_ES
	DW	MON_CODE_SEL,0		; mon_CS
	DW	MON_STACK_SEL,0		; mon_SS
	DW	MON_DATA_SEL,0		; mon_DS
	DW	MON_DATA_SEL,0		; mon_FS
	DW	MON_DATA_SEL,0		; mon_GS
	DW	MON_LDT_SEL,0		; mon_LDT
	DW	0			; mon_dtb
	DW	$ +2 -mon_tss		; mon_bm_off i/o bitmap (bm)
	DB	401h /8 DUP(0)		; the bm ;7/15 B0 chip
end_mon_tss	LABEL	BYTE
	DB	0FFh			; end_bm


;*   *   *   *   *   *   *   *   *   *   *   *******
tmp_tss	LABEL	BYTE
	DD	0			; _back
	DW	mon_tos,0,MON_STACK_SEL,0	; _stk0
	DQ	0			; _stk1
	DQ	0			; _stk2
	DD	0			; _cr3
	DW	begin_mon,0		; _eip
	DW	IFL,0			; _eflag
	DD	0			; _eax
	DD	0			; _ecx
	DD	0			; _edx
	DD	0			; _ebx
	DW	mon_tos,0		; _esp
	DD	0			; _ebp
	DD	0			; _esi 
	DD	0			; _edi
	DW	MON_DATA_SEL,0		; _ES
	DW	MON_CODE_SEL,0		; _CS
	DW	MON_STACK_SEL,0		; _SS
	DW	MON_DATA_SEL,0		; _DS
	DW	MON_DATA_SEL,0		; _FS
	DW	MON_DATA_SEL,0		; _GS
	DW	MON_LDT_SEL,0		; _LDT
	DW	0			; _dtb
	DW	end_mon_tss +2		; _bm_off
	DB	0FFh			; end_bm
end_tmp_tss	LABEL	BYTE
	DB	16 DUP(?)


;*   *   *   *   *   *   *   *   *   *   *   *******
; baseinit
;
	DW	(end_base_table-base_table) /4
base_table	LABEL	WORD
	DW	b0
	DW	TDATA
	DW	b1
	DW	TDATA
	DW	b2
	DW	TDATA
	DW	b3
	DW	TDATA
	DW	b4
	DW	TDATA
	DW	b5
	DW	TDATA
	DW	b6
	DW	TDATA
	DW	b7
	DW	TDATA
	DW	bmc0
	DW	MON_CODE
	DW	bmd1
	DW	MON_DATA
	DW	bms2
	DW	MON_STACK
end_base_table	LABEL	WORD
TDATA	ENDS


;*   *   *   *   *   *   *   *   *   *   *   *******
MON_DATA	SEGMENT
end_mon_data	LABEL	BYTE
MON_DATA	ENDS


;*   *   *   *   *   *   *   *   *   *   *   *******
MON_STACK	SEGMENT
	DW	512 DUP(?)
; mon_tos	LABEL	DWORD
mon_tos	DW	dos_ret,0
	DW	VM_CODE,0
	DW	IFL OR IOPLFL, VMFL
	DW	vm_tos,0,VM_DATA,0
	DW	VM_DATA,0,VM_DATA,0,VM_DATA,0,VM_DATA,0
end_mon_stack	LABEL	BYTE
MON_STACK	ENDS


;*   *   *   *   *   *   *   *   *   *   *   *******
BEEP	MACRO
LOCAL	self
	in	al,61h
	mov	ah,al
	or	al,3
	nop
	nop
	nop
	nop
	nop
	nop
	out	61h,al	;beeper
	mov	cx,1000h
self:	loop	self
	mov	al,ah
	out	61h,al
ENDM

PUTCH_VL	MACRO
LOCAL	wait1
LOCAL   wait2
LOCAL   wait3
	push	ES
	mov	cx,0b800h
	mov	ES,cx
	mov	BYTE PTR ES:[0],al
	mov	BYTE PTR ES:[2],' '
	mov	BYTE PTR ES:[4],' '
	mov	cx,0
wait1:	loop	wait1
	mov	cx,0
wait2:	loop	wait2
	mov	cx,0
wait3:	loop	wait3
	mov	BYTE PTR ES:[0],' '
	pop	ES
ENDM

PUTCH_PL	MACRO
LOCAL	wait1
LOCAL   wait2
LOCAL   wait3
	push	ES
	mov	cx,FLAT_SEL
	mov	ES,cx
	cld
	DB	OP_SIZE
	mov	di,8000h
	DW	00Bh
	DB	P_SIZE
	stosb
	inc	di
	mov	al,' '
	DB	P_SIZE
	stosb
	inc	di
	DB	P_SIZE
	stosb
	mov	cx,0
wait1:	loop	wait1
	mov	cx,0
wait2:	loop	wait2
	mov	cx,0
wait3:	loop	wait3
	DB	OP_SIZE
	mov	di,8000h
	DW	00Bh
	DB	P_SIZE
	stosb
	inc	di
	DB	P_SIZE
	stosb
	inc	di
	DB	P_SIZE
	stosb
	pop	ES
ENDM



;*   *   *   *   *   *   *   *   *   *   *   *******
MON_CODE	SEGMENT
ASSUME	CS:MON_CODE, DS:nothing, ES:nothing
;
;    mv86 entry anf monitor
;
;    main entry
; CS		code segment
; DS,ES,SS	ps
;
begin_mon:
	BEEP
end_entry:
	DB	OP_SIZE
	iret


;*   *   *   *   *   *   *   *   *   *   *   *******
rf0:	push	bp
	mov	bp,0
	jmp	reflect
SIZE_RF	EQU	$ -rf0
rf1:	push	bp
	mov	bp,1
	jmp	exs_int

rf2:	push	bp
	mov	bp,2
	jmp	reflect
rf3:	push	bp
	mov	bp,3
	jmp	reflect
rf4:	push	bp
	mov	bp,4
	jmp	reflect
rf5:	push	bp
	mov	bp,5
	jmp	reflect
rf6:	push	bp
	mov	bp,6
	jmp	exs_int
rf7:	push	bp
	mov	bp,7
	jmp	exs_int
rf8:	push	bp
	mov	bp,8
	jmp	reflect
rf9:	push	bp
	mov	bp,9
	jmp	reflect
rf10:	push	bp
	mov	bp,10
	jmp	exs_int
rf11:	push	bp
	mov	bp,11
	jmp	exs_int
rf12:	push	bp
	mov	bp,12
	jmp	exs_int
rf13:	push	bp
	mov	bp,13
	jmp	reflect
rf14:	push	bp
	mov	bp,14
	jmp	reflect
rf15:   push    bp
          mov     bp,15
          jmp     reflect
rf16:     push    bp
          mov     bp,16
          jmp     reflect
rf17:     push    bp
          mov     bp,17
          jmp     reflect
rf18:     push    bp
          mov     bp,18
          jmp     reflect
rf19:     push    bp
          mov     bp,19
          jmp     reflect
rf20:     push    bp
          mov     bp,20
          jmp     reflect
rf21:     push    bp
          mov     bp,21
          jmp     reflect
rf22:     push    bp
          mov     bp,22
          jmp     reflect
rf23:     push    bp
          mov     bp,23
          jmp     reflect
rf24:     push    bp
          mov     bp,24
          jmp     reflect
rf25:     push    bp
          mov     bp,25
          jmp     reflect
rf26:     push    bp
          mov     bp,26
          jmp     reflect
rf27:     push    bp
          mov     bp,27
          jmp     reflect
rf28:     push    bp
          mov     bp,28
          jmp     reflect
rf29:     push    bp
          mov     bp,29
          jmp     reflect
rf30:     push    bp
          mov     bp,30
          jmp     reflect
rf31:     push    bp
          mov     bp,31
          jmp     reflect
rf32:     push    bp
          mov     bp,32
          jmp     reflect
rf33:     push    bp
          mov     bp,33
          jmp     reflect
rf34:     push    bp
          mov     bp,34
          jmp     reflect
rf35:     push    bp
          mov     bp,35
          jmp     reflect
rf36:     push    bp
          mov     bp,36
          jmp     reflect
rf37:     push    bp
          mov     bp,37
          jmp     reflect
rf38:     push    bp
          mov     bp,38
          jmp     reflect
rf39:     push    bp
          mov     bp,39
          jmp     reflect
rf40:     push    bp
          mov     bp,40
          jmp     reflect
rf41:     push    bp
          mov     bp,41
          jmp     reflect
rf42:     push    bp
          mov     bp,42
          jmp     reflect
rf43:     push    bp
          mov     bp,43
          jmp     reflect
rf44:     push    bp
          mov     bp,44
          jmp     reflect
rf45:     push    bp
          mov     bp,45
          jmp     reflect
rf46:     push    bp
          mov     bp,46
          jmp     reflect
rf47:     push    bp
          mov     bp,47
          jmp     reflect
rf48:     push    bp
          mov     bp,48
          jmp     reflect
rf49:     push    bp
          mov     bp,49
          jmp     reflect
rf50:     push    bp
          mov     bp,50
          jmp     reflect
rf51:     push    bp
          mov     bp,51
          jmp     reflect
rf52:     push    bp
          mov     bp,52
          jmp     reflect
rf53:     push    bp
          mov     bp,53
          jmp     reflect
rf54:     push    bp
          mov     bp,54
          jmp     reflect
rf55:     push    bp
          mov     bp,55
          jmp     reflect
rf56:     push    bp
          mov     bp,56
          jmp     reflect
rf57:     push    bp
          mov     bp,57
          jmp     reflect
rf58:     push    bp
          mov     bp,58
          jmp     reflect
rf59:     push    bp
          mov     bp,59
          jmp     reflect
rf60:     push    bp
          mov     bp,60
          jmp     reflect
rf61:     push    bp
          mov     bp,61
          jmp     reflect
rf62:     push    bp
          mov     bp,62
          jmp     reflect
rf63:     push    bp
          mov     bp,63
          jmp     reflect
rf64:     push    bp
          mov     bp,64
          jmp     reflect
rf65:     push    bp
          mov     bp,65
          jmp     reflect
rf66:     push    bp
          mov     bp,66
          jmp     reflect
rf67:     push    bp
          mov     bp,67
          jmp     reflect
rf68:     push    bp
          mov     bp,68
          jmp     reflect
rf69:     push    bp
          mov     bp,69
          jmp     reflect
rf70:     push    bp
          mov     bp,70
          jmp     reflect
rf71:     push    bp
          mov     bp,71
          jmp     reflect
rf72:     push    bp
          mov     bp,72
          jmp     reflect
rf73:     push    bp
          mov     bp,73
          jmp     reflect
rf74:     push    bp
          mov     bp,74
          jmp     reflect
rf75:     push    bp
          mov     bp,75
          jmp     reflect
rf76:     push    bp
          mov     bp,76
          jmp     reflect
rf77:     push    bp
          mov     bp,77
          jmp     reflect
rf78:     push    bp
          mov     bp,78
          jmp     reflect
rf79:     push    bp
          mov     bp,79
          jmp     reflect
rf80:     push    bp
          mov     bp,80
          jmp     reflect
rf81:     push    bp
          mov     bp,81
          jmp     reflect
rf82:     push    bp
          mov     bp,82
          jmp     reflect
rf83:     push    bp
          mov     bp,83
          jmp     reflect
rf84:     push    bp
          mov     bp,84
          jmp     reflect
rf85:     push    bp
          mov     bp,85
          jmp     reflect
rf86:     push    bp
          mov     bp,86
          jmp     reflect
rf87:     push    bp
          mov     bp,87
          jmp     reflect
rf88:     push    bp
          mov     bp,88
          jmp     reflect
rf89:     push    bp
          mov     bp,89
          jmp     reflect
rf90:     push    bp
          mov     bp,90
          jmp     reflect
rf91:     push    bp
          mov     bp,91
          jmp     reflect
rf92:     push    bp
          mov     bp,92
          jmp     reflect
rf93:     push    bp
          mov     bp,93
          jmp     reflect
rf94:     push    bp
          mov     bp,94
          jmp     reflect
rf95:     push    bp
          mov     bp,95
          jmp     reflect
rf96:     push    bp
          mov     bp,96
          jmp     reflect
rf97:     push    bp
          mov     bp,97
          jmp     reflect
rf98:     push    bp
          mov     bp,98
          jmp     reflect
rf99:     push    bp
          mov     bp,99
          jmp     reflect
rf100:     push    bp
          mov     bp,100
          jmp     reflect
rf101:     push    bp
          mov     bp,101
          jmp     reflect
rf102:     push    bp
          mov     bp,102
          jmp     reflect
rf103:     push    bp
          mov     bp,103
          jmp     reflect
rf104:     push    bp
          mov     bp,104
          jmp     reflect
rf105:     push    bp
          mov     bp,105
          jmp     reflect
rf106:     push    bp
          mov     bp,106
          jmp     reflect
rf107:     push    bp
          mov     bp,107
          jmp     reflect
rf108:     push    bp
          mov     bp,108
          jmp     reflect
rf109:     push    bp
          mov     bp,109
          jmp     reflect
rf110:     push    bp
          mov     bp,110
          jmp     reflect
rf111:     push    bp
          mov     bp,111
          jmp     reflect
rf112:     push    bp
          mov     bp,112
          jmp     reflect
rf113:     push    bp
          mov     bp,113
          jmp     reflect
rf114:     push    bp
          mov     bp,114
          jmp     reflect
rf115:     push    bp
          mov     bp,115
          jmp     reflect
rf116:     push    bp
          mov     bp,116
          jmp     reflect
rf117:     push    bp
          mov     bp,117
          jmp     reflect
rf118:     push    bp
          mov     bp,118
          jmp     reflect
rf119:     push    bp
          mov     bp,119
          jmp     reflect
rf120:     push    bp
          mov     bp,120
          jmp     reflect
rf121:     push    bp
          mov     bp,121
          jmp     reflect
rf122:     push    bp
          mov     bp,122
          jmp     reflect
rf123:     push    bp
          mov     bp,123
          jmp     reflect
rf124:     push    bp
          mov     bp,124
          jmp     reflect
rf125:     push    bp
          mov     bp,125
          jmp     reflect
rf126:     push    bp
          mov     bp,126
          jmp     reflect
rf127:     push    bp
          mov     bp,127
          jmp     reflect
rf128:     push    bp
          mov     bp,128
          jmp     reflect
rf129:     push    bp
          mov     bp,129
          jmp     reflect
rf130:     push    bp
          mov     bp,130
          jmp     reflect
rf131:     push    bp
          mov     bp,131
          jmp     reflect
rf132:     push    bp
          mov     bp,132
          jmp     reflect
rf133:     push    bp
          mov     bp,133
          jmp     reflect
rf134:     push    bp
          mov     bp,134
          jmp     reflect
rf135:     push    bp
          mov     bp,135
          jmp     reflect
rf136:     push    bp
          mov     bp,136
          jmp     reflect
rf137:     push    bp
          mov     bp,137
          jmp     reflect
rf138:     push    bp
          mov     bp,138
          jmp     reflect
rf139:     push    bp
          mov     bp,139
          jmp     reflect
rf140:     push    bp
          mov     bp,140
          jmp     reflect
rf141:     push    bp
          mov     bp,141
          jmp     reflect
rf142:     push    bp
          mov     bp,142
          jmp     reflect
rf143:     push    bp
          mov     bp,143
          jmp     reflect
rf144:     push    bp
          mov     bp,144
          jmp     reflect
rf145:     push    bp
          mov     bp,145
          jmp     reflect
rf146:     push    bp
          mov     bp,146
          jmp     reflect
rf147:     push    bp
          mov     bp,147
          jmp     reflect
rf148:     push    bp
          mov     bp,148
          jmp     reflect
rf149:     push    bp
          mov     bp,149
          jmp     reflect
rf150:     push    bp
          mov     bp,150
          jmp     reflect
rf151:     push    bp
          mov     bp,151
          jmp     reflect
rf152:     push    bp
          mov     bp,152
          jmp     reflect
rf153:     push    bp
          mov     bp,153
          jmp     reflect
rf154:     push    bp
          mov     bp,154
          jmp     reflect
rf155:     push    bp
          mov     bp,155
          jmp     reflect
rf156:     push    bp
          mov     bp,156
          jmp     reflect
rf157:     push    bp
          mov     bp,157
          jmp     reflect
rf158:     push    bp
          mov     bp,158
          jmp     reflect
rf159:     push    bp
          mov     bp,159
          jmp     reflect
rf160:     push    bp
          mov     bp,160
          jmp     reflect
rf161:     push    bp
          mov     bp,161
          jmp     reflect
rf162:     push    bp
          mov     bp,162
          jmp     reflect
rf163:     push    bp
          mov     bp,163
          jmp     reflect
rf164:     push    bp
          mov     bp,164
          jmp     reflect
rf165:     push    bp
          mov     bp,165
          jmp     reflect
rf166:     push    bp
          mov     bp,166
          jmp     reflect
rf167:     push    bp
          mov     bp,167
          jmp     reflect
rf168:     push    bp
          mov     bp,168
          jmp     reflect
rf169:     push    bp
          mov     bp,169
          jmp     reflect
rf170:     push    bp
          mov     bp,170
          jmp     reflect
rf171:     push    bp
          mov     bp,171
          jmp     reflect
rf172:     push    bp
          mov     bp,172
          jmp     reflect
rf173:     push    bp
          mov     bp,173
          jmp     reflect
rf174:     push    bp
          mov     bp,174
          jmp     reflect
rf175:     push    bp
          mov     bp,175
          jmp     reflect
rf176:     push    bp
          mov     bp,176
          jmp     reflect
rf177:     push    bp
          mov     bp,177
          jmp     reflect
rf178:     push    bp
          mov     bp,178
          jmp     reflect
rf179:     push    bp
          mov     bp,179
          jmp     reflect
rf180:     push    bp
          mov     bp,180
          jmp     reflect
rf181:     push    bp
          mov     bp,181
          jmp     reflect
rf182:     push    bp
          mov     bp,182
          jmp     reflect
rf183:     push    bp
          mov     bp,183
          jmp     reflect
rf184:     push    bp
          mov     bp,184
          jmp     reflect
rf185:     push    bp
          mov     bp,185
          jmp     reflect
rf186:     push    bp
          mov     bp,186
          jmp     reflect
rf187:     push    bp
          mov     bp,187
          jmp     reflect
rf188:     push    bp
          mov     bp,188
          jmp     reflect
rf189:     push    bp
          mov     bp,189
          jmp     reflect
rf190:     push    bp
          mov     bp,190
          jmp     reflect
rf191:     push    bp
          mov     bp,191
          jmp     reflect
rf192:     push    bp
          mov     bp,192
          jmp     reflect
rf193:     push    bp
          mov     bp,193
          jmp     reflect
rf194:     push    bp
          mov     bp,194
          jmp     reflect
rf195:     push    bp
          mov     bp,195
          jmp     reflect
rf196:     push    bp
          mov     bp,196
          jmp     reflect
rf197:     push    bp
          mov     bp,197
          jmp     reflect
rf198:     push    bp
          mov     bp,198
          jmp     reflect
rf199:     push    bp
          mov     bp,199
          jmp     reflect
rf200:     push    bp
          mov     bp,200
          jmp     reflect
rf201:     push    bp
          mov     bp,201
          jmp     reflect
rf202:     push    bp
          mov     bp,202
          jmp     reflect
rf203:     push    bp
          mov     bp,203
          jmp     reflect
rf204:     push    bp
          mov     bp,204
          jmp     reflect
rf205:     push    bp
          mov     bp,205
          jmp     reflect
rf206:     push    bp
          mov     bp,206
          jmp     reflect
rf207:     push    bp
          mov     bp,207
          jmp     reflect
rf208:     push    bp
          mov     bp,208
          jmp     reflect
rf209:     push    bp
          mov     bp,209
          jmp     reflect
rf210:     push    bp
          mov     bp,210
          jmp     reflect
rf211:     push    bp
          mov     bp,211
          jmp     reflect
rf212:     push    bp
          mov     bp,212
          jmp     reflect
rf213:     push    bp
          mov     bp,213
          jmp     reflect
rf214:     push    bp
          mov     bp,214
          jmp     reflect
rf215:     push    bp
          mov     bp,215
          jmp     reflect
rf216:     push    bp
          mov     bp,216
          jmp     reflect
rf217:     push    bp
          mov     bp,217
          jmp     reflect
rf218:     push    bp
          mov     bp,218
          jmp     reflect
rf219:     push    bp
          mov     bp,219
          jmp     reflect
rf220:     push    bp
          mov     bp,220
          jmp     reflect
rf221:     push    bp
          mov     bp,221
          jmp     reflect
rf222:     push    bp
          mov     bp,222
          jmp     reflect
rf223:     push    bp
          mov     bp,223
          jmp     reflect
rf224:     push    bp
          mov     bp,224
          jmp     reflect
rf225:     push    bp
          mov     bp,225
          jmp     reflect
rf226:     push    bp
          mov     bp,226
          jmp     reflect
rf227:     push    bp
          mov     bp,227
          jmp     reflect
rf228:     push    bp
          mov     bp,228
          jmp     reflect
rf229:     push    bp
          mov     bp,229
          jmp     reflect
rf230:     push    bp
          mov     bp,230
          jmp     reflect
rf231:     push    bp
          mov     bp,231
          jmp     reflect
rf232:     push    bp
          mov     bp,232
          jmp     reflect
rf233:     push    bp
          mov     bp,233
          jmp     reflect
rf234:     push    bp
          mov     bp,234
          jmp     reflect
rf235:     push    bp
          mov     bp,235
          jmp     reflect
rf236:     push    bp
          mov     bp,236
          jmp     reflect
rf237:     push    bp
          mov     bp,237
          jmp     reflect
rf238:     push    bp
          mov     bp,238
          jmp     reflect
rf239:     push    bp
          mov     bp,239
          jmp     reflect
rf240:     push    bp
          mov     bp,240
          jmp     reflect
rf241:     push    bp
          mov     bp,241
          jmp     reflect
rf242:     push    bp
          mov     bp,242
          jmp     reflect
rf243:     push    bp
          mov     bp,243
          jmp     reflect
rf244:     push    bp
          mov     bp,244
          jmp     reflect
rf245:     push    bp
          mov     bp,245
          jmp     reflect
rf246:     push    bp
          mov     bp,246
          jmp     reflect
rf247:     push    bp
          mov     bp,247
          jmp     reflect
rf248:     push    bp
          mov     bp,248
          jmp     reflect
rf249:     push    bp
          mov     bp,249
          jmp     reflect
rf250:     push    bp
          mov     bp,250
          jmp     reflect
rf251:     push    bp
          mov     bp,251
          jmp     reflect
rf252:     push    bp
          mov     bp,252
          jmp     reflect
rf253:     push    bp
          mov     bp,253
          jmp     reflect
rf254:     push    bp
          mov     bp,254
          jmp     reflect
rf255:     push    bp
          mov     bp,255
          jmp     reflect

TRgs	EQU	WORD PTR [bp] +36
TRfs	EQU	WORD PTR [bp] +32
TRds	EQU	WORD PTR [bp] +28
TRes	EQU	WORD PTR [bp] +24
TRss	EQU	WORD PTR [bp] +20
TRsp	EQU	WORD PTR [bp] +16
TRflag	EQU	WORD PTR [bp] +12
TRcs	EQU	WORD PTR [bp] +8
TRip	EQU	WORD PTR [bp] +4
TRerr	EQU	WORD PTR [bp] +0

;*   *   *   *   *   *   *   *   *   *   *   *******
;
; all we have to do here is modify
; EIP to skip the faulting instruction,
; then got back to the faulting instruction.
; 
; 	ex sequence
; switch stack to level in cs selector of gate.
; push 86 style: gs,gs,ds,es (as 32 bit)
; load segs with 0
; push 86: ss,esp,eflag,cs,eip
; load cs:eip from gate, and go.
; 
; all as 32 bit:
; 	gs	40
; 	fs	36
; 	ds	32
; 	es	28
; 	ss	24
; 	sp	20
; 	flag	16
; 	cs	12
; 	ip	8
; 	errcode	4
; 
; 	bp
; 	bp	<SP
;
ex13_int:
; start	;7/15/86
; 	mov	bp,0Dh
; 	jmp	exs_int
; end
	add	sp,4	;skip past error code!
	push	bp
	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	or	TRflag,IOPLFL
	mov	bx,FLAT_SEL
	mov	DS,bx
	DB	OP_SIZE
	xor	bx,bx
	mov	bx,TRCS
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	add	bx,TRIP
	mov	al,'^'
	PUTCH_PL
	BEEP
	mov	cx,3000h
wait999: loop	wait999
	cmp	BYTE PTR [bx],0F4h	;hlt
	jne	not_hlt
;
	sti
	hlt

	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	pop	bp
	DB	OP_SIZE
	iret
not_hlt:
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	pop	bp
	mov	ax,4C01h
	jmp	rf33


;*   *   *   *   *   *   *   *   *   *   *   *******
;       interrupt/exception reflectors
;*   *   *   *   *   *   *   *   *   *   *   *******
;
;	build 86 handler fram
;	change trap frame to 86 int frame
;	ARGS  ax     int type
;
;*   *   *   *   *   *   *   *   *   *   *   *******
reflect:
	push	ax
	mov	ax,bp
	mov	bp,sp
	push	bx
	push	ax	; save int type
	mov	ax,FLAT_SEL
	mov	DS,ax
	DB	OP_SIZE
	xor	ax,ax
	mov	ax,TRSP	; change tos
	sub	ax,3*2
	mov	TRSP,ax
	DB	OP_SIZE
	xor	bx,bx
	mov	bx,TRSS
	; shl	bx,4
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	shl	bx,1
	DB	OP_SIZE
	add	bx,ax
	mov	ax,TRIP
	; mov	[bx] +0,ax
	DB	P_SIZE,MOV_PBX_AX,43h,0
	mov	ax,TRCS
	; mov	[bx] +2,ax
	DB	P_SIZE,MOV_PBX_AX,43h,2
	mov	ax,TRflag
	; mov	[bx] +4,ax
	DB	P_SIZE,MOV_PBX_AX,43h,4
	pop	bx
	shl	bx,1
	shl	bx,1
	mov	ax,[bx] +0
	mov	TRIP,ax
	mov	ax,[bx] +2
	mov	TRCS,ax
	or	TRFLAG +2,VMFL
	and	TRFLAG +0,NOT IFL
	pop	bx
	pop	ax
	pop	bp
	DB	OP_SIZE
	iret

;*   *   *   *   *   *   *   *   *   *   *   *******
; 1,6,7,8,a,b,c
;
exs_int:
	mov	ax,bp
	add	al,30h
	cmp	al,3Ah
	jb	end_al
	add	al,7
end_al:
	PUTCH_PL
	BEEP
	DB	OP_SIZE
	xor	ax,ax
	; mov	CR0,ax
	DB	00Fh,022h,0c0h
	jmp	flush0
flush0:	jmp	FAR PTR fflush
fflush	LABEL	FAR
	int	19h
	hlt


;*   *   *   *   *   *   *   *   *   *   *   *******
;
; emulate to faulting opcode
; ARGS  ds:si   opcode p
; RET   ax      opcode size
;
; emulate	PROC	NEAR
; emulate	ENDP
;
end_mon_code	LABEL	BYTE
MON_CODE	ENDS


;*   *   *   *   *   *   *   *   *   *   *   *******
VM_DATA SEGMENT
	DW	512 DUP(?)
vm_tos	LABEL	WORD
VM_DATA	ENDS


;*   *   *   *   *   *   *   *   *   *   *   *******
VM_CODE	SEGMENT
ASSUME	CS:	vm_code, ds: tdata, es: NOTHING

;*   *   *   *   *   *   *   *   *   *   *   *******
;
;	main vm code
; from dos
;
begin_vm:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	mov	ax,TDATA
	mov	DS,ax
	mov	ES,ax
	mov	ax,VM_DATA
	mov	SS,ax
	mov	sp,OFFSET vm_tos
;
;  setup tables
;
	cld
	call	init_bases
	call	init_idt
	; lidt	idt_pword
	DB	00Fh,001h,01Eh
	DW	idt_pword
	; lgdt	gdt_pword
	DB	00Fh,001h,016h
	DW	gdt_pword
	mov	bx,TMP_TSS_SEL
	cli
	; mov	ax,CR0
	DB	0Fh,20h,0C0h
	or	ax,1
	; mov	CR0,ax
	DB	00Fh,022h,0C0h
	jmp	SHORT	flush
flush:				; in protected mode level 0
	; ltr	bx
	DB	00Fh,000h,0DBh
	; sti			; in task switch
;
; go virtual
;
	jmp	CS:DWORD PTR vm_entry
vm_entry	LABEL DWORD
	DW	0,MON_TSS_SEL
;
; back to dos
;
dos_ret:
	NOP
;start	;7/15/86
	mov	al,'!'
	PUTCH_VL
	cli
	BEEP
	sti
	mov	al,'@'
	PUTCH_VL
	mov	dx,ZLAST	; dx   keep paragraph size
	sub	dx,AFIRST
	inc	dx
	mov	ax,3100h	; al   return code
	int	DOS
 	int	19h
	hlt


;*   *   *   *   *   *   *   *   *   *   *   *******
; turn all 16 bit offsets into 20 bit linear addresses
;
init_bases	PROC	NEAR
	push	DS
	mov	ax,TDATA
	mov	DS,ax
	mov	si,OFFSET base_table
	mov	cx,base_table -2
	cld
base_fill:
	lodsw
	mov	bx,ax
	lodsw
	xor	dx,dx
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	shl	ax,1
	rcl	dx,1
	add	[bx],ax
	adc	[bx] +2,dl	;6/27/86
	loop	base_fill
	pop	DS
	ret
init_bases	ENDP

;*   *   *   *   *   *   *   *   *   *   *   *******
;	DW	ex13_int
;	DW	MON_CODE_SEL	;sel mon code
;	DB	0
;	DB	0EEh	; - dpl=3 - 386 int gate
;	DB	0
;	DB	0
;
init_idt	PROC	NEAR
	push	DS
	push	ES
	mov	ax,TDATA
	mov	DS,ax		;ds	tdata
	mov	ES,ax		;es	ints
	mov	dx,OFFSET rf0
	mov	di,OFFSET idt
	mov	cx,256
idt_fill:
	mov	ax,dx
	add	dx,SIZE_RF
	add	di,8
	cmp	cx,256-13
	je	over_fill
	sub	di,8
	stosw
	mov	ax,MON_CODE_SEL
	stosw
	mov	ax,0EE00h
	stosw
	xor	ax,ax
	stosw
over_fill:
	loop	idt_fill
	pop	ES
	pop	DS
	ret
init_idt	ENDP


;*   *   *   *   *   *   *   *   *   *   *   *******
;	UTILITIES
;*   *   *   *   *   *   *   *   *   *   *   *******
; ARGS	ax	selector value
; RET	ax	segment value
;
sel2seg	PROC	NEAR
	push	DS
	push	bx
	mov	bx,GDT_ALIAS
	test	ax,4
	jz	have_table
	mov	bx,LDT_ALIAS
have_table:
	mov	DS,bx
	mov	bx,ax
	and	bx,NOT 7
	mov	ax,[bx] +2		;get 16
	test	ax,3
	jz	ok_selector
	int	3
ok_selector:
	shr	ax,1
	shr	ax,1
	pop	bx
	pop	DS
	ret
sel2seg	ENDP

VM_CODE	ENDS

ZLAST	SEGMENT	PARA
last_data	DW	?
ZLAST	ENDS
	
	END	begin_vm

